<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in complience with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
	<xsl:template match="/results">
        <email>
			<xsl:for-each select="row">
				<to><xsl:value-of select="email"/></to>
			</xsl:for-each>
			<subject>New entry: <xsl:value-of select="row[1]/name"/></subject>
			<message>
				<html>
					<p>
					A new entry has been added to your blog <b><xsl:value-of select="row[1]/name"/></b>
					</p>
					<h3><xsl:value-of select="$param/results/row/title"/></h3>
					<p>
					<xsl:value-of select="$param/results/row/summary"/>
					</p>
					<a>
						<xsl:attribute name="href"><xsl:value-of select="$param/results/row/hostname"/>blogxter/myblog/startedit?blogid=<xsl:value-of select="$param/results/row/blogid"/></xsl:attribute>
						edit
					</a>
				</html>
			</message>
		</email>
    </xsl:template>

</xsl:stylesheet>