########################
#Set up Blogxter Database
#Run as user root in mysql database
########################
CREATE DATABASE IF NOT EXISTS blogxter;

########################
#Grant access to user blogxter with password changeme
#Change password to something more secure!
########################
GRANT SELECT,INSERT,UPDATE,DELETE,INDEX, ALTER,CREATE,DROP,REFERENCES ON blogxter.* TO blogxter@localhost IDENTIFIED BY 'changeme'; 
GRANT SELECT,INSERT,UPDATE,DELETE,INDEX, ALTER,CREATE,DROP,REFERENCES ON blogxter.* TO blogxter@localhost.localdomain IDENTIFIED BY 'changeme'; 
FLUSH PRIVILEGES;

#######################
#Set up Tables
#######################
CREATE TABLE IF NOT EXISTS blogxter.blogs (
    id		    MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	name		VARCHAR(255),
	descr		TEXT,
	owner		MEDIUMINT UNSIGNED,
	created		DATETIME,
	access		ENUM("public", "protected", "private"),
	status		ENUM("live", "offline", "closed"),
	hostname	VARCHAR(255)
);

CREATE TABLE IF NOT EXISTS blogxter.users (
    id			MEDIUMINT NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	userid		VARCHAR(255),
	firstname	VARCHAR(128),
	lastname	VARCHAR(128),
	email		VARCHAR(255),
	web			VARCHAR(255),
	biog		TEXT,
	pwd			VARCHAR(50),
	hashedpwd	TEXT,
	reminder	TEXT,
	answer		TEXT,
	status		ENUM("active", "pending", "suspended", "removed")
);

CREATE TABLE IF NOT EXISTS blogxter.sessions (
	token		TEXT,
	userid		MEDIUMINT UNSIGNED ,
	created		DATETIME,
	expires		DATETIME
);

CREATE TABLE IF NOT EXISTS blogxter.categories (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	name		VARCHAR(255),
	descr		TEXT
);

CREATE TABLE IF NOT EXISTS blogxter.categorizations (
	blogid		MEDIUMINT UNSIGNED ,
	categoryid	MEDIUMINT UNSIGNED 
);

CREATE TABLE IF NOT EXISTS blogxter.permissiontypes (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	name		VARCHAR(255),
	descr		TEXT
);

CREATE TABLE IF NOT EXISTS blogxter.permissions (
	groupid		MEDIUMINT UNSIGNED ,
	permid		MEDIUMINT UNSIGNED 
);

CREATE TABLE IF NOT EXISTS blogxter.groups (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	name		VARCHAR(255),
	descr		TEXT
);

CREATE TABLE IF NOT EXISTS blogxter.affiliations (
	userid		MEDIUMINT UNSIGNED ,
	groupid		MEDIUMINT UNSIGNED ,
	blogid		MEDIUMINT UNSIGNED ,
	status		ENUM("approved", "pending")
);

CREATE TABLE IF NOT EXISTS blogxter.entries (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	blogid		MEDIUMINT UNSIGNED ,
	title		TEXT,
	author		MEDIUMINT UNSIGNED ,
	created		DATETIME,
	modified	DATETIME,
	summary		VARCHAR(255),
	entry		LONGTEXT,
	publicid	TEXT,
	status		ENUM("approved","pending", "deleted"),
	FULLTEXT (title, entry)
);

CREATE TABLE IF NOT EXISTS blogxter.comments (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	blogentryid	MEDIUMINT UNSIGNED,
	author		VARCHAR(255),
	email		VARCHAR(255),
	web			TEXT,
	created		DATETIME,
	title		TEXT,
	comment		TEXT,
	status		ENUM("approved","pending"),
	FULLTEXT (title, comment)
);

CREATE TABLE IF NOT EXISTS blogxter.trackbacks (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	blogentryid	MEDIUMINT UNSIGNED,
	title		TEXT,
	URL			TEXT,
	excerpt		TEXT,
	blogname	TEXT,
	created		DATETIME,
	status		ENUM("approved","pending")
);

CREATE TABLE IF NOT EXISTS blogxter.resources (
	id			TEXT,
	mimetype	VARCHAR(255),
	URI			TEXT,
	blogid		MEDIUMINT UNSIGNED,
	title		TEXT,
	descr		TEXT
);

CREATE TABLE IF NOT EXISTS blogxter.tickets (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	userid		MEDIUMINT UNSIGNED,
	guid		VARCHAR(255),
	created		DATETIME,
	type		ENUM("MEMBER", "BLOGREQ", "BLOGINVITE"),
	value		TINYINT
);

CREATE TABLE IF NOT EXISTS blogxter.settings (
	blogid		MEDIUMINT UNSIGNED,
	setting		VARCHAR(128),
	value		TINYINT	UNSIGNED
);

CREATE TABLE IF NOT EXISTS blogxter.system (
	setting		varchar(128),
	value		TEXT
);

#Set default system settings
INSERT INTO blogxter.system VALUES ('WWWHOSTNAME', 'http://localhost:8080/');
INSERT INTO blogxter.system VALUES ('HTTPPROXY', null);
INSERT INTO blogxter.system VALUES ('SMTPHOSTNAME', 'localhost');
INSERT INTO blogxter.system VALUES ('SMTPUSER', null);
INSERT INTO blogxter.system VALUES ('SMTPPASSWORD', null);
INSERT INTO blogxter.system VALUES ('EMAILSENDER', 'blogxter@localhost');
INSERT INTO blogxter.system VALUES ('SMTPPOLLINTERVAL', '10000');

CREATE TABLE IF NOT EXISTS blogxter.messages (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	restype		ENUM("REF", "BLOG", "ENTRY", "TICKET"),
	resid		MEDIUMINT UNSIGNED,
	userid		MEDIUMINT UNSIGNED,
	created		DATETIME,
	subject		VARCHAR(255),
	message		TEXT,
	FULLTEXT (subject, message)
);

CREATE TABLE IF NOT EXISTS blogxter.recipients (
	messageid	MEDIUMINT UNSIGNED,
	userid		MEDIUMINT UNSIGNED,
	status		ENUM("NEW", "READ", "DELETED", "ARCHIVED")
);

CREATE TABLE IF NOT EXISTS blogxter.notificationchannels (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	name		VARCHAR(255),
	descr		TEXT,
	URI			TEXT
);

INSERT INTO blogxter.notificationchannels VALUES (null, 'email', 'email notification', 'ffcpl:/blogPostBox');

CREATE TABLE IF NOT EXISTS blogxter.notifications (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	userid		MEDIUMINT UNSIGNED,
	blogid		MEDIUMINT UNSIGNED,
	channelid	MEDIUMINT UNSIGNED,
	channelxml	MEDIUMTEXT
);

CREATE TABLE IF NOT EXISTS blogxter.hits
(	type		ENUM("blog", "entry"),
	value		MEDIUMINT UNSIGNED,
	created		DATETIME
)

CREATE TABLE IF NOT EXISTS blogxter.logs (
	blogid		MEDIUMINT UNSIGNED,
	time		DATETIME
);

CREATE TABLE IF NOT EXISTS blogxter.lnf (
	blogid		MEDIUMINT UNSIGNED,
	resourceid	TEXT,
	type		ENUM("css","xslt"),
	status		ENUM("test","live")
);

##########
#Polls
##########
CREATE TABLE IF NOT EXISTS blogxter.polls (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	entryid		MEDIUMINT UNSIGNED,
	question	TEXT,
	created		DATETIME,
	status		ENUM("live", "pending", "old"),
	FULLTEXT (question)
);

CREATE TABLE IF NOT EXISTS blogxter.polloptions (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	pollid		MEDIUMINT UNSIGNED,
	choice		TEXT
);

CREATE TABLE IF NOT EXISTS blogxter.pollvotes (
	pollid			MEDIUMINT UNSIGNED,
	optionid		MEDIUMINT UNSIGNED,
	nonrepudiate	VARCHAR(255)
);

########################
#Setup groups, permissions and create admin user
########################
INSERT INTO blogxter.users values (
	null,
	"super",
	"super",
	null,
	null,
	null,
	'super user biog',
	"super",
	MD5("super"),
	null,
	null,
	"active"
);

INSERT INTO blogxter.users values (
	null,
	"guest",
	null,
	null,
	null,
	null,
	null,
	"guest",
	MD5("guest"),
	null,
	null,
	"active"
);

INSERT INTO blogxter.groups values (
	null,
	"super",
	"This is the super user group - users in this group have universal privileges"
);

INSERT INTO blogxter.groups values (
	null,
	"admin",
	"This is the admin group - users in this group can administer their own blogs"
);

INSERT INTO blogxter.groups values (
	null,
	"editor",
	"This is the editor group - editors can manage blog content"
);

INSERT INTO blogxter.groups values (
	null,
	"author",
	"This is the author group - authors can create blog content"
);

INSERT INTO blogxter.groups values (
	null,
	"member",
	"This is the member group - members can view member only blogs"
);

INSERT INTO blogxter.groups values (
	null,
	"public",
	"This is the public group - anyone can read public blogs"
);

INSERT INTO blogxter.permissiontypes values (
	null,
	"read",
	"Read access"
);

INSERT INTO blogxter.permissiontypes values (
	null,
	"write",
	"Write access"
);

INSERT INTO blogxter.permissiontypes values (
	null,
	"edit",
	"Create access"
);

SELECT @supergroupid:=id from blogxter.groups where name='super';
SELECT @admingroupid:=id from blogxter.groups where name='admin';
SELECT @editorgroupid:=id from blogxter.groups where name='editor';
SELECT @authorgroupid:=id from blogxter.groups where name='author';
SELECT @membergroupid:=id from blogxter.groups where name='member';
SELECT @publicgroupid:=id from blogxter.groups where name='public';

SELECT @superid:=id from blogxter.users where userid='super';
INSERT INTO blogxter.affiliations VALUES (@superid, @supergroupid, NULL, "approved");

SELECT @readperm:=id from blogxter.permissiontypes where name='read';
SELECT @writeperm:=id from blogxter.permissiontypes where name='write';
SELECT @editperm:=id from blogxter.permissiontypes where name='edit';

#Setup group permissions
INSERT INTO blogxter.permissions values ( @supergroupid, @readperm);
INSERT INTO blogxter.permissions values ( @supergroupid, @writeperm);
INSERT INTO blogxter.permissions values ( @supergroupid, @editperm);
INSERT INTO blogxter.permissions values ( @editorgroupid, @readperm);
INSERT INTO blogxter.permissions values ( @editorgroupid, @writeperm);
INSERT INTO blogxter.permissions values ( @editorgroupid, @editperm);
INSERT INTO blogxter.permissions values ( @authorgroupid, @readperm);
INSERT INTO blogxter.permissions values ( @authorgroupid, @writeperm);
INSERT INTO blogxter.permissions values ( @membergroupid, @readperm);

#Create Sysadmin blog
INSERT INTO blogxter.blogs values
(	null,
	'Sysadmin',
	'The sysadmin blog for system news and announcements',
	@superid,
	NOW(),
	'public',
	'live'
);

SELECT @sysadminblog:=id from blogxter.blogs where name='Sysadmin';

#Settings for sysadmin blog
INSERT INTO blogxter.settings VALUES (@sysadminblog, 'PUBLIC', 1);
INSERT INTO blogxter.settings VALUES (@sysadminblog, 'MEMBERLISTING', 0);
INSERT INTO blogxter.settings VALUES (@sysadminblog, 'COMMENTS', 1);
INSERT INTO blogxter.settings VALUES (@sysadminblog, 'TRACKBACKS', 0);
INSERT INTO blogxter.settings VALUES (@sysadminblog, 'NOTIFICATIONCOMMENTS', 0);
INSERT INTO blogxter.settings VALUES (@sysadminblog, 'NOTIFICATIONENTRIES', 0);

INSERT INTO blogxter.affiliations VALUES (@superid, @supergroupid, @sysadminblog, "approved");
INSERT INTO blogxter.affiliations VALUES (@superid, @admingroupid, @sysadminblog, "approved");
INSERT INTO blogxter.affiliations VALUES (@superid, @editorgroupid, @sysadminblog, "approved");
INSERT INTO blogxter.affiliations VALUES (@superid, @authorgroupid, @sysadminblog, "approved");
INSERT INTO blogxter.affiliations VALUES (@superid, @membergroupid, @sysadminblog, "approved");
INSERT INTO blogxter.affiliations VALUES (@superid, @publicgroupid, @sysadminblog, "approved");

#Add Welcome entry to Sysadmin blog
INSERT INTO blogxter.entries values (
	null,
	@sysadminblog ,
	'Welcome',
	@superid ,
	NOW(),
	NOW(),
		'<div xmlns:xrl="http://1060.org/xrl">
		<div style="font-size:75px;">Welcome to blogxter</div>
		<h2>Important Notice</h2>
		<div style="font-size:15px; margin-bottom: 10px;">Blogxter is
		licensed under the 1060 Public License. If you use Blogxter
		you must release all your modifications as
		open-source. Support and commercial licenses which permit you to
		keep your code closed can be purchased from <a href="http://www.1060research.com">1060 research</a></div>
		<div style="font-size:15px; margin-bottom: 10px;">Blogxter is an
		application which runs on <i>1060 NetKernel virtual Internet
		OS</i>. More information and downloads are available at <a href="http://www.1060.org">1060.org</a></div>
		</div>',
	MD5('firstentry'),
	'approved'
);

#Setup common resources
INSERT INTO blogxter.resources VALUES ('Style_Narrow_Gutter', null, '/www/view/publish/style_test.xsl', 0, 'test_style','A simple test style');
INSERT INTO blogxter.resources VALUES ('CSS_Blue', null, '/www/view/lnf/css/css_blue_lnf.css', 0, 'Blue Look','Blue Headings, Pale Blue Background, Gold Links');

########################
#Set up BMail Database
########################
CREATE DATABASE IF NOT EXISTS bmail;

########################
#Grant access to user blogxter with password changeme
#Change password to something more secure!
########################
GRANT SELECT,INSERT,UPDATE,DELETE,INDEX, ALTER,CREATE,DROP,REFERENCES ON blogxter.* TO blogxter@localhost IDENTIFIED BY 'changeme'; 
GRANT SELECT,INSERT,UPDATE,DELETE,INDEX, ALTER,CREATE,DROP,REFERENCES ON blogxter.* TO blogxter@localhost.localdomain IDENTIFIED BY 'changeme'; 
FLUSH PRIVILEGES;

