/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.spi.Language;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.builder.PredicateBuilder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public final class SubscribeMethodProcessor
extends AsyncProcessorSupport
implements Navigate<Processor> {
    private final Endpoint endpoint;
    private final Map<AsyncProcessor, Predicate> methods = new LinkedHashMap<AsyncProcessor, Predicate>();
    private Language simple;

    public SubscribeMethodProcessor(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void addMethod(Object pojo, Method method, Endpoint endpoint, String predicate) throws Exception {
        Processor answer = PluginHelper.getBeanProcessorFactory((CamelContext)endpoint.getCamelContext()).createBeanProcessor(endpoint.getCamelContext(), pojo, method);
        answer = PluginHelper.getInternalProcessorFactory((CamelContext)endpoint.getCamelContext()).addUnitOfWorkProcessorAdvice(endpoint.getCamelContext(), answer, null);
        Predicate p = ObjectHelper.isEmpty((String)predicate) ? PredicateBuilder.constant((boolean)true) : this.simple.createPredicate(predicate);
        this.methods.put((AsyncProcessor)answer, p);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            for (Map.Entry<AsyncProcessor, Predicate> entry : this.methods.entrySet()) {
                Predicate predicate = entry.getValue();
                if (!predicate.matches(exchange)) continue;
                return entry.getKey().process(exchange, callback);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    protected void doInit() throws Exception {
        this.simple = this.getEndpoint().getCamelContext().resolveLanguage("simple");
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService(this.methods.keySet());
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.methods.keySet());
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.methods.keySet());
    }

    public String toString() {
        return "SubscribeMethodProcessor[" + String.valueOf(this.endpoint) + "]";
    }

    public List<Processor> next() {
        return new ArrayList<AsyncProcessor>(this.methods.keySet());
    }

    public boolean hasNext() {
        return !this.methods.isEmpty();
    }
}

