// @generated by protobuf-ts 2.1.0 with parameter client_grpc1,generate_dependencies
// @generated from protobuf file "org/apache/beam/model/job_management/v1/beam_job_api.proto" (package "org.apache.beam.model.job_management.v1", syntax proto3)
// tslint:disable
//
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//
//
// Protocol Buffers describing the Job API, api for communicating with a runner
// for job submission over GRPC.
//
import { ServiceType } from "@protobuf-ts/runtime-rpc";
import type { BinaryWriteOptions } from "@protobuf-ts/runtime";
import type { IBinaryWriter } from "@protobuf-ts/runtime";
import { WireType } from "@protobuf-ts/runtime";
import type { BinaryReadOptions } from "@protobuf-ts/runtime";
import type { IBinaryReader } from "@protobuf-ts/runtime";
import { UnknownFieldHandler } from "@protobuf-ts/runtime";
import type { PartialMessage } from "@protobuf-ts/runtime";
import { reflectionMergePartial } from "@protobuf-ts/runtime";
import { MESSAGE_TYPE } from "@protobuf-ts/runtime";
import { MessageType } from "@protobuf-ts/runtime";
import { MonitoringInfo } from "../../pipeline/v1/metrics";
import { Timestamp } from "../../../../../../google/protobuf/timestamp";
import { ApiServiceDescriptor } from "../../pipeline/v1/endpoints";
import { Struct } from "../../../../../../google/protobuf/struct";
import { Pipeline } from "../../pipeline/v1/beam_runner_api";
/**
 * Prepare is a synchronous request that returns a preparationId back
 * Throws error GRPC_STATUS_UNAVAILABLE if server is down
 * Throws error ALREADY_EXISTS if the jobName is reused. Runners are permitted to deduplicate based on the name of the job.
 * Throws error UNKNOWN for all other issues
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.PrepareJobRequest
 */
export interface PrepareJobRequest {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Pipeline pipeline = 1;
     */
    pipeline?: Pipeline; // (required)
    /**
     * @generated from protobuf field: google.protobuf.Struct pipeline_options = 2;
     */
    pipelineOptions?: Struct; // (required)
    /**
     * @generated from protobuf field: string job_name = 3;
     */
    jobName: string; // (required)
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.PrepareJobResponse
 */
export interface PrepareJobResponse {
    /**
     * (required) The ID used to associate calls made while preparing the job. preparationId is used
     * to run the job.
     *
     * @generated from protobuf field: string preparation_id = 1;
     */
    preparationId: string;
    /**
     * An endpoint which exposes the Beam Artifact Staging API. Artifacts used by the job should be
     * staged to this endpoint, and will be available during job execution.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor artifact_staging_endpoint = 2;
     */
    artifactStagingEndpoint?: ApiServiceDescriptor;
    /**
     * (required) Token for the artifact staging. This token also represent an artifact
     * staging session with the artifact staging service.
     *
     * @generated from protobuf field: string staging_session_token = 3;
     */
    stagingSessionToken: string;
}
/**
 * Run is a synchronous request that returns a jobId back.
 * Throws error GRPC_STATUS_UNAVAILABLE if server is down
 * Throws error NOT_FOUND if the preparation ID does not exist
 * Throws error UNKNOWN for all other issues
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.RunJobRequest
 */
export interface RunJobRequest {
    /**
     * (required) The ID provided by an earlier call to prepare. Runs the job. All prerequisite tasks
     * must have been completed.
     *
     * @generated from protobuf field: string preparation_id = 1;
     */
    preparationId: string;
    /**
     * (optional) If any artifacts have been staged for this job, contains the retrieval_token returned
     * from the CommitManifestResponse.
     *
     * @generated from protobuf field: string retrieval_token = 2;
     */
    retrievalToken: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.RunJobResponse
 */
export interface RunJobResponse {
    /**
     * @generated from protobuf field: string job_id = 1;
     */
    jobId: string; // (required) The ID for the executing job
}
/**
 * Cancel is a synchronus request that returns a job state back
 * Throws error GRPC_STATUS_UNAVAILABLE if server is down
 * Throws error NOT_FOUND if the jobId is not found
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.CancelJobRequest
 */
export interface CancelJobRequest {
    /**
     * @generated from protobuf field: string job_id = 1;
     */
    jobId: string; // (required)
}
/**
 * Valid responses include any terminal state or CANCELLING
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.CancelJobResponse
 */
export interface CancelJobResponse {
    /**
     * @generated from protobuf field: org.apache.beam.model.job_management.v1.JobState.Enum state = 1;
     */
    state: JobState_Enum; // (required)
}
/**
 * A subset of info provided by ProvisionApi.ProvisionInfo
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.JobInfo
 */
export interface JobInfo {
    /**
     * @generated from protobuf field: string job_id = 1;
     */
    jobId: string; // (required)
    /**
     * @generated from protobuf field: string job_name = 2;
     */
    jobName: string; // (required)
    /**
     * @generated from protobuf field: google.protobuf.Struct pipeline_options = 3;
     */
    pipelineOptions?: Struct; // (required)
    /**
     * @generated from protobuf field: org.apache.beam.model.job_management.v1.JobState.Enum state = 4;
     */
    state: JobState_Enum; // (required)
}
/**
 * GetJobs is a synchronus request that returns a list of invoked jobs back
 * Throws error GRPC_STATUS_UNAVAILABLE if server is down
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.GetJobsRequest
 */
export interface GetJobsRequest {
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.GetJobsResponse
 */
export interface GetJobsResponse {
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.job_management.v1.JobInfo job_info = 1;
     */
    jobInfo: JobInfo[]; // (required)
}
/**
 * GetState is a synchronus request that returns a job state back
 * Throws error GRPC_STATUS_UNAVAILABLE if server is down
 * Throws error NOT_FOUND if the jobId is not found
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.GetJobStateRequest
 */
export interface GetJobStateRequest {
    /**
     * @generated from protobuf field: string job_id = 1;
     */
    jobId: string; // (required)
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.JobStateEvent
 */
export interface JobStateEvent {
    /**
     * @generated from protobuf field: org.apache.beam.model.job_management.v1.JobState.Enum state = 1;
     */
    state: JobState_Enum; // (required)
    /**
     * @generated from protobuf field: google.protobuf.Timestamp timestamp = 2;
     */
    timestamp?: Timestamp; // (required)
}
/**
 * GetPipeline is a synchronus request that returns a pipeline back
 * Throws error GRPC_STATUS_UNAVAILABLE if server is down
 * Throws error NOT_FOUND if the jobId is not found
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.GetJobPipelineRequest
 */
export interface GetJobPipelineRequest {
    /**
     * @generated from protobuf field: string job_id = 1;
     */
    jobId: string; // (required)
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.GetJobPipelineResponse
 */
export interface GetJobPipelineResponse {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Pipeline pipeline = 1;
     */
    pipeline?: Pipeline; // (required)
}
/**
 * GetJobMessages is a streaming api for streaming job messages from the service
 * One request will connect you to the job and you'll get a stream of job state
 * and job messages back; one is used for logging and the other for detecting
 * the job ended.
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.JobMessagesRequest
 */
export interface JobMessagesRequest {
    /**
     * @generated from protobuf field: string job_id = 1;
     */
    jobId: string; // (required)
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.JobMessage
 */
export interface JobMessage {
    /**
     * @generated from protobuf field: string message_id = 1;
     */
    messageId: string;
    /**
     * @generated from protobuf field: string time = 2;
     */
    time: string;
    /**
     * @generated from protobuf field: org.apache.beam.model.job_management.v1.JobMessage.MessageImportance importance = 3;
     */
    importance: JobMessage_MessageImportance;
    /**
     * @generated from protobuf field: string message_text = 4;
     */
    messageText: string;
}
/**
 * @generated from protobuf enum org.apache.beam.model.job_management.v1.JobMessage.MessageImportance
 */
export enum JobMessage_MessageImportance {
    /**
     * @generated from protobuf enum value: MESSAGE_IMPORTANCE_UNSPECIFIED = 0;
     */
    MESSAGE_IMPORTANCE_UNSPECIFIED = 0,
    /**
     * @generated from protobuf enum value: JOB_MESSAGE_DEBUG = 1;
     */
    JOB_MESSAGE_DEBUG = 1,
    /**
     * @generated from protobuf enum value: JOB_MESSAGE_DETAILED = 2;
     */
    JOB_MESSAGE_DETAILED = 2,
    /**
     * @generated from protobuf enum value: JOB_MESSAGE_BASIC = 3;
     */
    JOB_MESSAGE_BASIC = 3,
    /**
     * @generated from protobuf enum value: JOB_MESSAGE_WARNING = 4;
     */
    JOB_MESSAGE_WARNING = 4,
    /**
     * @generated from protobuf enum value: JOB_MESSAGE_ERROR = 5;
     */
    JOB_MESSAGE_ERROR = 5
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.JobMessagesResponse
 */
export interface JobMessagesResponse {
    /**
     * @generated from protobuf oneof: response
     */
    response: {
        oneofKind: "messageResponse";
        /**
         * @generated from protobuf field: org.apache.beam.model.job_management.v1.JobMessage message_response = 1;
         */
        messageResponse: JobMessage;
    } | {
        oneofKind: "stateResponse";
        /**
         * @generated from protobuf field: org.apache.beam.model.job_management.v1.JobStateEvent state_response = 2;
         */
        stateResponse: JobStateEvent;
    } | {
        oneofKind: undefined;
    };
}
/**
 * Enumeration of all JobStates
 *
 * The state transition diagram is:
 *   STOPPED -> STARTING -> RUNNING -> DONE
 *                                  \> FAILED
 *                                  \> CANCELLING -> CANCELLED
 *                                  \> UPDATING -> UPDATED
 *                                  \> DRAINING -> DRAINED
 *
 * Transitions are optional such that a job may go from STOPPED to RUNNING
 * without needing to pass through STARTING.
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.JobState
 */
export interface JobState {
}
/**
 * @generated from protobuf enum org.apache.beam.model.job_management.v1.JobState.Enum
 */
export enum JobState_Enum {
    /**
     * The job state reported by a runner cannot be interpreted by the SDK.
     *
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * The job has not yet started.
     *
     * @generated from protobuf enum value: STOPPED = 1;
     */
    STOPPED = 1,
    /**
     * The job is currently running.
     *
     * @generated from protobuf enum value: RUNNING = 2;
     */
    RUNNING = 2,
    /**
     * The job has successfully completed. (terminal)
     *
     * @generated from protobuf enum value: DONE = 3;
     */
    DONE = 3,
    /**
     * The job has failed. (terminal)
     *
     * @generated from protobuf enum value: FAILED = 4;
     */
    FAILED = 4,
    /**
     * The job has been explicitly cancelled. (terminal)
     *
     * @generated from protobuf enum value: CANCELLED = 5;
     */
    CANCELLED = 5,
    /**
     * The job has been updated. (terminal)
     *
     * @generated from protobuf enum value: UPDATED = 6;
     */
    UPDATED = 6,
    /**
     * The job is draining its data. (optional)
     *
     * @generated from protobuf enum value: DRAINING = 7;
     */
    DRAINING = 7,
    /**
     * The job has completed draining its data. (terminal)
     *
     * @generated from protobuf enum value: DRAINED = 8;
     */
    DRAINED = 8,
    /**
     * The job is starting up.
     *
     * @generated from protobuf enum value: STARTING = 9;
     */
    STARTING = 9,
    /**
     * The job is cancelling. (optional)
     *
     * @generated from protobuf enum value: CANCELLING = 10;
     */
    CANCELLING = 10,
    /**
     * The job is in the process of being updated. (optional)
     *
     * @generated from protobuf enum value: UPDATING = 11;
     */
    UPDATING = 11
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.GetJobMetricsRequest
 */
export interface GetJobMetricsRequest {
    /**
     * @generated from protobuf field: string job_id = 1;
     */
    jobId: string; // (required)
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.GetJobMetricsResponse
 */
export interface GetJobMetricsResponse {
    /**
     * @generated from protobuf field: org.apache.beam.model.job_management.v1.MetricResults metrics = 1;
     */
    metrics?: MetricResults;
}
/**
 * All metrics for a given job.  Runners may support one or the other or both.
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.MetricResults
 */
export interface MetricResults {
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.MonitoringInfo attempted = 1;
     */
    attempted: MonitoringInfo[];
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.MonitoringInfo committed = 2;
     */
    committed: MonitoringInfo[];
}
/**
 * DescribePipelineOptions provides metadata about the options supported by a runner.
 * It will be used by the SDK client to validate the options specified by or
 * list available options to the user.
 * Throws error GRPC_STATUS_UNAVAILABLE if server is down
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest
 */
export interface DescribePipelineOptionsRequest {
}
/**
 * Type for pipeline options.
 * Types mirror those of JSON, since that's how pipeline options are serialized.
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.PipelineOptionType
 */
export interface PipelineOptionType {
}
/**
 * @generated from protobuf enum org.apache.beam.model.job_management.v1.PipelineOptionType.Enum
 */
export enum PipelineOptionType_Enum {
    /**
     * @generated from protobuf enum value: STRING = 0;
     */
    STRING = 0,
    /**
     * @generated from protobuf enum value: BOOLEAN = 1;
     */
    BOOLEAN = 1,
    /**
     * whole numbers, see https://json-schema.org/understanding-json-schema/reference/numeric.html
     *
     * @generated from protobuf enum value: INTEGER = 2;
     */
    INTEGER = 2,
    /**
     * @generated from protobuf enum value: NUMBER = 3;
     */
    NUMBER = 3,
    /**
     * @generated from protobuf enum value: ARRAY = 4;
     */
    ARRAY = 4,
    /**
     * @generated from protobuf enum value: OBJECT = 5;
     */
    OBJECT = 5
}
/**
 * Metadata for a pipeline option.
 *
 * @generated from protobuf message org.apache.beam.model.job_management.v1.PipelineOptionDescriptor
 */
export interface PipelineOptionDescriptor {
    /**
     * (Required) The option name.
     *
     * @generated from protobuf field: string name = 1;
     */
    name: string;
    /**
     * (Required) Type of option.
     *
     * @generated from protobuf field: org.apache.beam.model.job_management.v1.PipelineOptionType.Enum type = 2;
     */
    type: PipelineOptionType_Enum;
    /**
     * (Optional) Description suitable for display / help text.
     *
     * @generated from protobuf field: string description = 3;
     */
    description: string;
    /**
     * (Optional) Default value.
     *
     * @generated from protobuf field: string default_value = 4;
     */
    defaultValue: string;
    /**
     * (Required) The group this option belongs to.
     *
     * @generated from protobuf field: string group = 5;
     */
    group: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse
 */
export interface DescribePipelineOptionsResponse {
    /**
     * List of pipeline option descriptors.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.job_management.v1.PipelineOptionDescriptor options = 1;
     */
    options: PipelineOptionDescriptor[];
}
// @generated message type with reflection information, may provide speed optimized methods
class PrepareJobRequest$Type extends MessageType<PrepareJobRequest> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.PrepareJobRequest", [
            { no: 1, name: "pipeline", kind: "message", T: () => Pipeline },
            { no: 2, name: "pipeline_options", kind: "message", T: () => Struct },
            { no: 3, name: "job_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<PrepareJobRequest>): PrepareJobRequest {
        const message = { jobName: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<PrepareJobRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: PrepareJobRequest): PrepareJobRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Pipeline pipeline */ 1:
                    message.pipeline = Pipeline.internalBinaryRead(reader, reader.uint32(), options, message.pipeline);
                    break;
                case /* google.protobuf.Struct pipeline_options */ 2:
                    message.pipelineOptions = Struct.internalBinaryRead(reader, reader.uint32(), options, message.pipelineOptions);
                    break;
                case /* string job_name */ 3:
                    message.jobName = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: PrepareJobRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Pipeline pipeline = 1; */
        if (message.pipeline)
            Pipeline.internalBinaryWrite(message.pipeline, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* google.protobuf.Struct pipeline_options = 2; */
        if (message.pipelineOptions)
            Struct.internalBinaryWrite(message.pipelineOptions, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* string job_name = 3; */
        if (message.jobName !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.jobName);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.PrepareJobRequest
 */
export const PrepareJobRequest = new PrepareJobRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PrepareJobResponse$Type extends MessageType<PrepareJobResponse> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.PrepareJobResponse", [
            { no: 1, name: "preparation_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "artifact_staging_endpoint", kind: "message", T: () => ApiServiceDescriptor },
            { no: 3, name: "staging_session_token", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<PrepareJobResponse>): PrepareJobResponse {
        const message = { preparationId: "", stagingSessionToken: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<PrepareJobResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: PrepareJobResponse): PrepareJobResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string preparation_id */ 1:
                    message.preparationId = reader.string();
                    break;
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor artifact_staging_endpoint */ 2:
                    message.artifactStagingEndpoint = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.artifactStagingEndpoint);
                    break;
                case /* string staging_session_token */ 3:
                    message.stagingSessionToken = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: PrepareJobResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string preparation_id = 1; */
        if (message.preparationId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.preparationId);
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor artifact_staging_endpoint = 2; */
        if (message.artifactStagingEndpoint)
            ApiServiceDescriptor.internalBinaryWrite(message.artifactStagingEndpoint, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* string staging_session_token = 3; */
        if (message.stagingSessionToken !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.stagingSessionToken);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.PrepareJobResponse
 */
export const PrepareJobResponse = new PrepareJobResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class RunJobRequest$Type extends MessageType<RunJobRequest> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.RunJobRequest", [
            { no: 1, name: "preparation_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "retrieval_token", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<RunJobRequest>): RunJobRequest {
        const message = { preparationId: "", retrievalToken: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<RunJobRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: RunJobRequest): RunJobRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string preparation_id */ 1:
                    message.preparationId = reader.string();
                    break;
                case /* string retrieval_token */ 2:
                    message.retrievalToken = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: RunJobRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string preparation_id = 1; */
        if (message.preparationId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.preparationId);
        /* string retrieval_token = 2; */
        if (message.retrievalToken !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.retrievalToken);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.RunJobRequest
 */
export const RunJobRequest = new RunJobRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class RunJobResponse$Type extends MessageType<RunJobResponse> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.RunJobResponse", [
            { no: 1, name: "job_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<RunJobResponse>): RunJobResponse {
        const message = { jobId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<RunJobResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: RunJobResponse): RunJobResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string job_id */ 1:
                    message.jobId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: RunJobResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string job_id = 1; */
        if (message.jobId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.jobId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.RunJobResponse
 */
export const RunJobResponse = new RunJobResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class CancelJobRequest$Type extends MessageType<CancelJobRequest> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.CancelJobRequest", [
            { no: 1, name: "job_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<CancelJobRequest>): CancelJobRequest {
        const message = { jobId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<CancelJobRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: CancelJobRequest): CancelJobRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string job_id */ 1:
                    message.jobId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: CancelJobRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string job_id = 1; */
        if (message.jobId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.jobId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.CancelJobRequest
 */
export const CancelJobRequest = new CancelJobRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class CancelJobResponse$Type extends MessageType<CancelJobResponse> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.CancelJobResponse", [
            { no: 1, name: "state", kind: "enum", T: () => ["org.apache.beam.model.job_management.v1.JobState.Enum", JobState_Enum] }
        ]);
    }
    create(value?: PartialMessage<CancelJobResponse>): CancelJobResponse {
        const message = { state: 0 };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<CancelJobResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: CancelJobResponse): CancelJobResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.job_management.v1.JobState.Enum state */ 1:
                    message.state = reader.int32();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: CancelJobResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.job_management.v1.JobState.Enum state = 1; */
        if (message.state !== 0)
            writer.tag(1, WireType.Varint).int32(message.state);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.CancelJobResponse
 */
export const CancelJobResponse = new CancelJobResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class JobInfo$Type extends MessageType<JobInfo> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.JobInfo", [
            { no: 1, name: "job_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "job_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "pipeline_options", kind: "message", T: () => Struct },
            { no: 4, name: "state", kind: "enum", T: () => ["org.apache.beam.model.job_management.v1.JobState.Enum", JobState_Enum] }
        ]);
    }
    create(value?: PartialMessage<JobInfo>): JobInfo {
        const message = { jobId: "", jobName: "", state: 0 };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<JobInfo>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: JobInfo): JobInfo {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string job_id */ 1:
                    message.jobId = reader.string();
                    break;
                case /* string job_name */ 2:
                    message.jobName = reader.string();
                    break;
                case /* google.protobuf.Struct pipeline_options */ 3:
                    message.pipelineOptions = Struct.internalBinaryRead(reader, reader.uint32(), options, message.pipelineOptions);
                    break;
                case /* org.apache.beam.model.job_management.v1.JobState.Enum state */ 4:
                    message.state = reader.int32();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: JobInfo, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string job_id = 1; */
        if (message.jobId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.jobId);
        /* string job_name = 2; */
        if (message.jobName !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.jobName);
        /* google.protobuf.Struct pipeline_options = 3; */
        if (message.pipelineOptions)
            Struct.internalBinaryWrite(message.pipelineOptions, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.job_management.v1.JobState.Enum state = 4; */
        if (message.state !== 0)
            writer.tag(4, WireType.Varint).int32(message.state);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.JobInfo
 */
export const JobInfo = new JobInfo$Type();
// @generated message type with reflection information, may provide speed optimized methods
class GetJobsRequest$Type extends MessageType<GetJobsRequest> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.GetJobsRequest", []);
    }
    create(value?: PartialMessage<GetJobsRequest>): GetJobsRequest {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GetJobsRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GetJobsRequest): GetJobsRequest {
        return target ?? this.create();
    }
    internalBinaryWrite(message: GetJobsRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.GetJobsRequest
 */
export const GetJobsRequest = new GetJobsRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class GetJobsResponse$Type extends MessageType<GetJobsResponse> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.GetJobsResponse", [
            { no: 1, name: "job_info", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => JobInfo }
        ]);
    }
    create(value?: PartialMessage<GetJobsResponse>): GetJobsResponse {
        const message = { jobInfo: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GetJobsResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GetJobsResponse): GetJobsResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.job_management.v1.JobInfo job_info */ 1:
                    message.jobInfo.push(JobInfo.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: GetJobsResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.job_management.v1.JobInfo job_info = 1; */
        for (let i = 0; i < message.jobInfo.length; i++)
            JobInfo.internalBinaryWrite(message.jobInfo[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.GetJobsResponse
 */
export const GetJobsResponse = new GetJobsResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class GetJobStateRequest$Type extends MessageType<GetJobStateRequest> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.GetJobStateRequest", [
            { no: 1, name: "job_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<GetJobStateRequest>): GetJobStateRequest {
        const message = { jobId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GetJobStateRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GetJobStateRequest): GetJobStateRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string job_id */ 1:
                    message.jobId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: GetJobStateRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string job_id = 1; */
        if (message.jobId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.jobId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.GetJobStateRequest
 */
export const GetJobStateRequest = new GetJobStateRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class JobStateEvent$Type extends MessageType<JobStateEvent> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.JobStateEvent", [
            { no: 1, name: "state", kind: "enum", T: () => ["org.apache.beam.model.job_management.v1.JobState.Enum", JobState_Enum] },
            { no: 2, name: "timestamp", kind: "message", T: () => Timestamp }
        ]);
    }
    create(value?: PartialMessage<JobStateEvent>): JobStateEvent {
        const message = { state: 0 };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<JobStateEvent>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: JobStateEvent): JobStateEvent {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.job_management.v1.JobState.Enum state */ 1:
                    message.state = reader.int32();
                    break;
                case /* google.protobuf.Timestamp timestamp */ 2:
                    message.timestamp = Timestamp.internalBinaryRead(reader, reader.uint32(), options, message.timestamp);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: JobStateEvent, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.job_management.v1.JobState.Enum state = 1; */
        if (message.state !== 0)
            writer.tag(1, WireType.Varint).int32(message.state);
        /* google.protobuf.Timestamp timestamp = 2; */
        if (message.timestamp)
            Timestamp.internalBinaryWrite(message.timestamp, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.JobStateEvent
 */
export const JobStateEvent = new JobStateEvent$Type();
// @generated message type with reflection information, may provide speed optimized methods
class GetJobPipelineRequest$Type extends MessageType<GetJobPipelineRequest> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.GetJobPipelineRequest", [
            { no: 1, name: "job_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<GetJobPipelineRequest>): GetJobPipelineRequest {
        const message = { jobId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GetJobPipelineRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GetJobPipelineRequest): GetJobPipelineRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string job_id */ 1:
                    message.jobId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: GetJobPipelineRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string job_id = 1; */
        if (message.jobId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.jobId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.GetJobPipelineRequest
 */
export const GetJobPipelineRequest = new GetJobPipelineRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class GetJobPipelineResponse$Type extends MessageType<GetJobPipelineResponse> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.GetJobPipelineResponse", [
            { no: 1, name: "pipeline", kind: "message", T: () => Pipeline }
        ]);
    }
    create(value?: PartialMessage<GetJobPipelineResponse>): GetJobPipelineResponse {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GetJobPipelineResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GetJobPipelineResponse): GetJobPipelineResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Pipeline pipeline */ 1:
                    message.pipeline = Pipeline.internalBinaryRead(reader, reader.uint32(), options, message.pipeline);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: GetJobPipelineResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Pipeline pipeline = 1; */
        if (message.pipeline)
            Pipeline.internalBinaryWrite(message.pipeline, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.GetJobPipelineResponse
 */
export const GetJobPipelineResponse = new GetJobPipelineResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class JobMessagesRequest$Type extends MessageType<JobMessagesRequest> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.JobMessagesRequest", [
            { no: 1, name: "job_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<JobMessagesRequest>): JobMessagesRequest {
        const message = { jobId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<JobMessagesRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: JobMessagesRequest): JobMessagesRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string job_id */ 1:
                    message.jobId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: JobMessagesRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string job_id = 1; */
        if (message.jobId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.jobId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.JobMessagesRequest
 */
export const JobMessagesRequest = new JobMessagesRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class JobMessage$Type extends MessageType<JobMessage> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.JobMessage", [
            { no: 1, name: "message_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "time", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "importance", kind: "enum", T: () => ["org.apache.beam.model.job_management.v1.JobMessage.MessageImportance", JobMessage_MessageImportance] },
            { no: 4, name: "message_text", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<JobMessage>): JobMessage {
        const message = { messageId: "", time: "", importance: 0, messageText: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<JobMessage>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: JobMessage): JobMessage {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string message_id */ 1:
                    message.messageId = reader.string();
                    break;
                case /* string time */ 2:
                    message.time = reader.string();
                    break;
                case /* org.apache.beam.model.job_management.v1.JobMessage.MessageImportance importance */ 3:
                    message.importance = reader.int32();
                    break;
                case /* string message_text */ 4:
                    message.messageText = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: JobMessage, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string message_id = 1; */
        if (message.messageId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.messageId);
        /* string time = 2; */
        if (message.time !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.time);
        /* org.apache.beam.model.job_management.v1.JobMessage.MessageImportance importance = 3; */
        if (message.importance !== 0)
            writer.tag(3, WireType.Varint).int32(message.importance);
        /* string message_text = 4; */
        if (message.messageText !== "")
            writer.tag(4, WireType.LengthDelimited).string(message.messageText);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.JobMessage
 */
export const JobMessage = new JobMessage$Type();
// @generated message type with reflection information, may provide speed optimized methods
class JobMessagesResponse$Type extends MessageType<JobMessagesResponse> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.JobMessagesResponse", [
            { no: 1, name: "message_response", kind: "message", oneof: "response", T: () => JobMessage },
            { no: 2, name: "state_response", kind: "message", oneof: "response", T: () => JobStateEvent }
        ]);
    }
    create(value?: PartialMessage<JobMessagesResponse>): JobMessagesResponse {
        const message = { response: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<JobMessagesResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: JobMessagesResponse): JobMessagesResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.job_management.v1.JobMessage message_response */ 1:
                    message.response = {
                        oneofKind: "messageResponse",
                        messageResponse: JobMessage.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).messageResponse)
                    };
                    break;
                case /* org.apache.beam.model.job_management.v1.JobStateEvent state_response */ 2:
                    message.response = {
                        oneofKind: "stateResponse",
                        stateResponse: JobStateEvent.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).stateResponse)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: JobMessagesResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.job_management.v1.JobMessage message_response = 1; */
        if (message.response.oneofKind === "messageResponse")
            JobMessage.internalBinaryWrite(message.response.messageResponse, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.job_management.v1.JobStateEvent state_response = 2; */
        if (message.response.oneofKind === "stateResponse")
            JobStateEvent.internalBinaryWrite(message.response.stateResponse, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.JobMessagesResponse
 */
export const JobMessagesResponse = new JobMessagesResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class JobState$Type extends MessageType<JobState> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.JobState", []);
    }
    create(value?: PartialMessage<JobState>): JobState {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<JobState>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: JobState): JobState {
        return target ?? this.create();
    }
    internalBinaryWrite(message: JobState, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.JobState
 */
export const JobState = new JobState$Type();
// @generated message type with reflection information, may provide speed optimized methods
class GetJobMetricsRequest$Type extends MessageType<GetJobMetricsRequest> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.GetJobMetricsRequest", [
            { no: 1, name: "job_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<GetJobMetricsRequest>): GetJobMetricsRequest {
        const message = { jobId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GetJobMetricsRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GetJobMetricsRequest): GetJobMetricsRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string job_id */ 1:
                    message.jobId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: GetJobMetricsRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string job_id = 1; */
        if (message.jobId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.jobId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.GetJobMetricsRequest
 */
export const GetJobMetricsRequest = new GetJobMetricsRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class GetJobMetricsResponse$Type extends MessageType<GetJobMetricsResponse> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.GetJobMetricsResponse", [
            { no: 1, name: "metrics", kind: "message", T: () => MetricResults }
        ]);
    }
    create(value?: PartialMessage<GetJobMetricsResponse>): GetJobMetricsResponse {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GetJobMetricsResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GetJobMetricsResponse): GetJobMetricsResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.job_management.v1.MetricResults metrics */ 1:
                    message.metrics = MetricResults.internalBinaryRead(reader, reader.uint32(), options, message.metrics);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: GetJobMetricsResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.job_management.v1.MetricResults metrics = 1; */
        if (message.metrics)
            MetricResults.internalBinaryWrite(message.metrics, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.GetJobMetricsResponse
 */
export const GetJobMetricsResponse = new GetJobMetricsResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MetricResults$Type extends MessageType<MetricResults> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.MetricResults", [
            { no: 1, name: "attempted", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => MonitoringInfo },
            { no: 2, name: "committed", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => MonitoringInfo }
        ]);
    }
    create(value?: PartialMessage<MetricResults>): MetricResults {
        const message = { attempted: [], committed: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MetricResults>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MetricResults): MetricResults {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.MonitoringInfo attempted */ 1:
                    message.attempted.push(MonitoringInfo.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.MonitoringInfo committed */ 2:
                    message.committed.push(MonitoringInfo.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: MetricResults, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.MonitoringInfo attempted = 1; */
        for (let i = 0; i < message.attempted.length; i++)
            MonitoringInfo.internalBinaryWrite(message.attempted[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* repeated org.apache.beam.model.pipeline.v1.MonitoringInfo committed = 2; */
        for (let i = 0; i < message.committed.length; i++)
            MonitoringInfo.internalBinaryWrite(message.committed[i], writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.MetricResults
 */
export const MetricResults = new MetricResults$Type();
// @generated message type with reflection information, may provide speed optimized methods
class DescribePipelineOptionsRequest$Type extends MessageType<DescribePipelineOptionsRequest> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest", []);
    }
    create(value?: PartialMessage<DescribePipelineOptionsRequest>): DescribePipelineOptionsRequest {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<DescribePipelineOptionsRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: DescribePipelineOptionsRequest): DescribePipelineOptionsRequest {
        return target ?? this.create();
    }
    internalBinaryWrite(message: DescribePipelineOptionsRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest
 */
export const DescribePipelineOptionsRequest = new DescribePipelineOptionsRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PipelineOptionType$Type extends MessageType<PipelineOptionType> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.PipelineOptionType", []);
    }
    create(value?: PartialMessage<PipelineOptionType>): PipelineOptionType {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<PipelineOptionType>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: PipelineOptionType): PipelineOptionType {
        return target ?? this.create();
    }
    internalBinaryWrite(message: PipelineOptionType, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.PipelineOptionType
 */
export const PipelineOptionType = new PipelineOptionType$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PipelineOptionDescriptor$Type extends MessageType<PipelineOptionDescriptor> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.PipelineOptionDescriptor", [
            { no: 1, name: "name", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "type", kind: "enum", T: () => ["org.apache.beam.model.job_management.v1.PipelineOptionType.Enum", PipelineOptionType_Enum] },
            { no: 3, name: "description", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "default_value", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 5, name: "group", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<PipelineOptionDescriptor>): PipelineOptionDescriptor {
        const message = { name: "", type: 0, description: "", defaultValue: "", group: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<PipelineOptionDescriptor>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: PipelineOptionDescriptor): PipelineOptionDescriptor {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string name */ 1:
                    message.name = reader.string();
                    break;
                case /* org.apache.beam.model.job_management.v1.PipelineOptionType.Enum type */ 2:
                    message.type = reader.int32();
                    break;
                case /* string description */ 3:
                    message.description = reader.string();
                    break;
                case /* string default_value */ 4:
                    message.defaultValue = reader.string();
                    break;
                case /* string group */ 5:
                    message.group = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: PipelineOptionDescriptor, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string name = 1; */
        if (message.name !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.name);
        /* org.apache.beam.model.job_management.v1.PipelineOptionType.Enum type = 2; */
        if (message.type !== 0)
            writer.tag(2, WireType.Varint).int32(message.type);
        /* string description = 3; */
        if (message.description !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.description);
        /* string default_value = 4; */
        if (message.defaultValue !== "")
            writer.tag(4, WireType.LengthDelimited).string(message.defaultValue);
        /* string group = 5; */
        if (message.group !== "")
            writer.tag(5, WireType.LengthDelimited).string(message.group);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.PipelineOptionDescriptor
 */
export const PipelineOptionDescriptor = new PipelineOptionDescriptor$Type();
// @generated message type with reflection information, may provide speed optimized methods
class DescribePipelineOptionsResponse$Type extends MessageType<DescribePipelineOptionsResponse> {
    constructor() {
        super("org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse", [
            { no: 1, name: "options", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => PipelineOptionDescriptor }
        ]);
    }
    create(value?: PartialMessage<DescribePipelineOptionsResponse>): DescribePipelineOptionsResponse {
        const message = { options: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<DescribePipelineOptionsResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: DescribePipelineOptionsResponse): DescribePipelineOptionsResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.job_management.v1.PipelineOptionDescriptor options */ 1:
                    message.options.push(PipelineOptionDescriptor.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: DescribePipelineOptionsResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.job_management.v1.PipelineOptionDescriptor options = 1; */
        for (let i = 0; i < message.options.length; i++)
            PipelineOptionDescriptor.internalBinaryWrite(message.options[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse
 */
export const DescribePipelineOptionsResponse = new DescribePipelineOptionsResponse$Type();
/**
 * @generated ServiceType for protobuf service org.apache.beam.model.job_management.v1.JobService
 */
export const JobService = new ServiceType("org.apache.beam.model.job_management.v1.JobService", [
    { name: "Prepare", options: {}, I: PrepareJobRequest, O: PrepareJobResponse },
    { name: "Run", options: {}, I: RunJobRequest, O: RunJobResponse },
    { name: "GetJobs", options: {}, I: GetJobsRequest, O: GetJobsResponse },
    { name: "GetState", options: {}, I: GetJobStateRequest, O: JobStateEvent },
    { name: "GetPipeline", options: {}, I: GetJobPipelineRequest, O: GetJobPipelineResponse },
    { name: "Cancel", options: {}, I: CancelJobRequest, O: CancelJobResponse },
    { name: "GetStateStream", serverStreaming: true, options: {}, I: GetJobStateRequest, O: JobStateEvent },
    { name: "GetMessageStream", serverStreaming: true, options: {}, I: JobMessagesRequest, O: JobMessagesResponse },
    { name: "GetJobMetrics", options: {}, I: GetJobMetricsRequest, O: GetJobMetricsResponse },
    { name: "DescribePipelineOptions", options: {}, I: DescribePipelineOptionsRequest, O: DescribePipelineOptionsResponse }
]);
