/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.util;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class Utils {
    public static final String WINDOWS_EVERYONE = Utils.getWindowsEveryonePrincipalName();

    private Utils() {
    }

    public static boolean isMacOSX() {
        String osName = System.getProperty("os.name");
        return osName.contains("OS X");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name", "").toLowerCase().contains("windows");
    }

    public static void deleteRecursively(File file) throws IOException {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                Utils.deleteRecursively(child);
            }
        }
        Utils.delete(file);
    }

    public static void delete(File file) throws IOException {
        Path path;
        try {
            path = file.toPath();
        }
        catch (InvalidPathException ipe) {
            throw new IOException("Invalid file: " + file, ipe);
        }
        for (int n = 0; n < 10; ++n) {
            try {
                Files.delete(path);
                if (!Files.exists(path, new LinkOption[0])) {
                    return;
                }
                Uninterruptibles.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            catch (DirectoryNotEmptyException dnee) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            catch (AccessDeniedException ade) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            catch (NoSuchFileException nse) {
                return;
            }
        }
        throw new IOException("Could not delete: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String getWindowsEveryonePrincipalName() {
        if (!Utils.isWindows()) return "Everyone";
        try {
            Process process = new ProcessBuilder("whoami", "/groups").start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                do {
                    if ((line = reader.readLine()) == null) return "Everyone";
                } while (line.indexOf("S-1-1-0") == -1);
                String string = line.split("\\s{2,}")[0];
                return string;
            }
            finally {
                process.destroy();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "Everyone";
    }

    public static boolean isPrivate(Path path) throws IOException {
        UserPrincipal everyone = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(WINDOWS_EVERYONE);
        AclFileAttributeView aclFileAttributes = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        for (AclEntry aclEntry : aclFileAttributes.getAcl()) {
            if (!aclEntry.principal().equals(everyone)) continue;
            return false;
        }
        return true;
    }

    public static void setPrivate(Path path) throws IOException {
        UserPrincipal everyone = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(WINDOWS_EVERYONE);
        AclFileAttributeView aclFileAttributes = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        CopyOnWriteArrayList<AclEntry> aclList = new CopyOnWriteArrayList<AclEntry>(aclFileAttributes.getAcl());
        for (AclEntry aclEntry : aclList) {
            if (!aclEntry.principal().equals(everyone) || !aclEntry.type().equals((Object)AclEntryType.ALLOW)) continue;
            aclList.remove(aclEntry);
        }
        aclFileAttributes.setAcl(aclList);
    }

    public static void setPublic(Path path) throws IOException {
        UserPrincipal everyone = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(WINDOWS_EVERYONE);
        AclFileAttributeView aclFileAttributes = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        List<AclEntry> list = aclFileAttributes.getAcl();
        list.add(AclEntry.newBuilder().setPrincipal(everyone).setPermissions(AclEntryPermission.READ_DATA, AclEntryPermission.READ_ACL, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS).setType(AclEntryType.ALLOW).build());
        aclFileAttributes.setAcl(list);
    }
}

