/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.core.BugException;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ClassBasedModelFactory;
import freemarker.ext.beans.ClassChangeNotifier;
import freemarker.ext.beans.ClassIntrospectorBuilder;
import freemarker.ext.beans.MethodAppearanceFineTuner;
import freemarker.ext.beans.MethodSorter;
import freemarker.ext.beans.OverloadedMethods;
import freemarker.ext.beans.SimpleMethod;
import freemarker.ext.beans.UnsafeMethods;
import freemarker.ext.util.ModelCache;
import freemarker.log.Logger;
import freemarker.template.utility.NullArgumentException;
import freemarker.template.utility.SecurityUtilities;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ClassIntrospector {
    private static final Logger LOG;
    private static final String JREBEL_SDK_CLASS_NAME = "org.zeroturnaround.javarebel.ClassEventListener";
    private static final String JREBEL_INTEGRATION_ERROR_MSG = "Error initializing JRebel integration. JRebel integration disabled.";
    static final boolean DEVELOPMENT_MODE;
    private static final ClassChangeNotifier CLASS_CHANGE_NOTIFIER;
    private static final Object ARGTYPES_KEY;
    static final Object CONSTRUCTORS_KEY;
    static final Object GENERIC_GET_KEY;
    final int exposureLevel;
    final boolean exposeFields;
    final MethodAppearanceFineTuner methodAppearanceFineTuner;
    final MethodSorter methodSorter;
    final boolean bugfixed;
    private final boolean hasSharedInstanceRestrictons;
    private final boolean shared;
    private final Object sharedLock;
    private final Map cache = new ConcurrentHashMap(0, 0.75f, 16);
    private final Set cacheClassNames = new HashSet(0);
    private final Set classIntrospectionsInProgress = new HashSet(0);
    private final List modelFactories = new LinkedList();
    private final ReferenceQueue modelFactoriesRefQueue = new ReferenceQueue();
    private int clearingCounter;

    ClassIntrospector(ClassIntrospectorBuilder pa, Object sharedLock) {
        this(pa, sharedLock, false, false);
    }

    ClassIntrospector(ClassIntrospectorBuilder builder, Object sharedLock, boolean hasSharedInstanceRestrictons, boolean shared) {
        NullArgumentException.check("sharedLock", sharedLock);
        this.exposureLevel = builder.getExposureLevel();
        this.exposeFields = builder.getExposeFields();
        this.methodAppearanceFineTuner = builder.getMethodAppearanceFineTuner();
        this.methodSorter = builder.getMethodSorter();
        this.bugfixed = builder.isBugfixed();
        this.sharedLock = sharedLock;
        this.hasSharedInstanceRestrictons = hasSharedInstanceRestrictons;
        this.shared = shared;
        if (CLASS_CHANGE_NOTIFIER != null) {
            CLASS_CHANGE_NOTIFIER.subscribe(this);
        }
    }

    ClassIntrospectorBuilder getPropertyAssignments() {
        return new ClassIntrospectorBuilder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map get(Class clazz) {
        String className;
        Map introspData = (Map)this.cache.get(clazz);
        if (introspData != null) {
            return introspData;
        }
        Object object = this.sharedLock;
        synchronized (object) {
            Map introspData2 = (Map)this.cache.get(clazz);
            if (introspData2 != null) {
                return introspData2;
            }
            className = clazz.getName();
            if (this.cacheClassNames.contains(className)) {
                this.onSameNameClassesDetected(className);
            }
            while (introspData2 == null && this.classIntrospectionsInProgress.contains(clazz)) {
                try {
                    this.sharedLock.wait();
                    introspData2 = (Map)this.cache.get(clazz);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Class inrospection data lookup aborded: " + e);
                }
            }
            if (introspData2 != null) {
                return introspData2;
            }
            this.classIntrospectionsInProgress.add(clazz);
        }
        try {
            Map introspData3 = this.createClassIntrospectionData(clazz);
            Object object2 = this.sharedLock;
            synchronized (object2) {
                this.cache.put(clazz, introspData3);
                this.cacheClassNames.add(className);
            }
            object2 = introspData3;
            return object2;
        }
        finally {
            Object object3 = this.sharedLock;
            synchronized (object3) {
                this.classIntrospectionsInProgress.remove(clazz);
                this.sharedLock.notifyAll();
            }
        }
    }

    private Map createClassIntrospectionData(Class clazz) {
        HashMap introspData = new HashMap();
        if (this.exposeFields) {
            this.addFieldsToClassIntrospectionData(introspData, clazz);
        }
        Map accessibleMethods = ClassIntrospector.discoverAccessibleMethods(clazz);
        this.addGenericGetToClassIntrospectionData(introspData, accessibleMethods);
        if (this.exposureLevel != 3) {
            try {
                this.addBeanInfoToClassIntrospectionData(introspData, clazz, accessibleMethods);
            }
            catch (IntrospectionException e) {
                LOG.warn("Couldn't properly perform introspection for class " + clazz, e);
                introspData.clear();
            }
        }
        this.addConstructorsToClassIntrospectionData(introspData, clazz);
        if (introspData.size() > 1) {
            return introspData;
        }
        if (introspData.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        Map.Entry e = introspData.entrySet().iterator().next();
        return Collections.singletonMap(e.getKey(), e.getValue());
    }

    private void addFieldsToClassIntrospectionData(Map introspData, Class clazz) throws SecurityException {
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ((field.getModifiers() & 8) != 0) continue;
            introspData.put(field.getName(), field);
        }
    }

    private void addBeanInfoToClassIntrospectionData(Map introspData, Class clazz, Map accessibleMethods) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] pda = beanInfo.getPropertyDescriptors();
        if (pda != null) {
            int pdaLength = pda.length;
            for (int i = pdaLength - 1; i >= 0; --i) {
                this.addPropertyDescriptorToClassIntrospectionData(introspData, pda[i], clazz, accessibleMethods);
            }
        }
        if (this.exposureLevel < 2) {
            BeansWrapper.MethodAppearanceDecision decision = new BeansWrapper.MethodAppearanceDecision();
            BeansWrapper.MethodAppearanceDecisionInput decisionInput = null;
            MethodDescriptor[] mda = this.sortMethodDescriptors(beanInfo.getMethodDescriptors());
            if (mda != null) {
                int mdaLength = mda.length;
                for (int i = mdaLength - 1; i >= 0; --i) {
                    String methodKey;
                    PropertyDescriptor propDesc;
                    MethodDescriptor md = mda[i];
                    Method method = ClassIntrospector.getMatchingAccessibleMethod(md.getMethod(), accessibleMethods);
                    if (method == null || !this.isAllowedToExpose(method)) continue;
                    decision.setDefaults(method);
                    if (this.methodAppearanceFineTuner != null) {
                        if (decisionInput == null) {
                            decisionInput = new BeansWrapper.MethodAppearanceDecisionInput();
                        }
                        decisionInput.setContainingClass(clazz);
                        decisionInput.setMethod(method);
                        this.methodAppearanceFineTuner.process(decisionInput, decision);
                    }
                    if ((propDesc = decision.getExposeAsProperty()) != null && !(introspData.get(propDesc.getName()) instanceof PropertyDescriptor)) {
                        this.addPropertyDescriptorToClassIntrospectionData(introspData, propDesc, clazz, accessibleMethods);
                    }
                    if ((methodKey = decision.getExposeMethodAs()) == null) continue;
                    Object previous = introspData.get(methodKey);
                    if (previous instanceof Method) {
                        OverloadedMethods overloadedMethods = new OverloadedMethods(this.bugfixed);
                        overloadedMethods.addMethod((Method)previous);
                        overloadedMethods.addMethod(method);
                        introspData.put(methodKey, overloadedMethods);
                        ClassIntrospector.getArgTypes(introspData).remove(previous);
                        continue;
                    }
                    if (previous instanceof OverloadedMethods) {
                        ((OverloadedMethods)previous).addMethod(method);
                        continue;
                    }
                    if (!decision.getMethodShadowsProperty() && previous instanceof PropertyDescriptor) continue;
                    introspData.put(methodKey, method);
                    ClassIntrospector.getArgTypes(introspData).put(method, method.getParameterTypes());
                }
            }
        }
    }

    private void addPropertyDescriptorToClassIntrospectionData(Map introspData, PropertyDescriptor pd, Class clazz, Map accessibleMethods) {
        if (pd instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            Method readMethod = ipd.getIndexedReadMethod();
            Method publicReadMethod = ClassIntrospector.getMatchingAccessibleMethod(readMethod, accessibleMethods);
            if (publicReadMethod != null && this.isAllowedToExpose(publicReadMethod)) {
                try {
                    if (readMethod != publicReadMethod) {
                        ipd = new IndexedPropertyDescriptor(ipd.getName(), ipd.getReadMethod(), null, publicReadMethod, null);
                    }
                    introspData.put(ipd.getName(), ipd);
                    ClassIntrospector.getArgTypes(introspData).put(publicReadMethod, publicReadMethod.getParameterTypes());
                }
                catch (IntrospectionException e) {
                    LOG.warn("Failed creating a publicly-accessible property descriptor for " + clazz.getName() + " indexed property " + pd.getName() + ", read method " + publicReadMethod, e);
                }
            }
        } else {
            Method readMethod = pd.getReadMethod();
            Method publicReadMethod = ClassIntrospector.getMatchingAccessibleMethod(readMethod, accessibleMethods);
            if (publicReadMethod != null && this.isAllowedToExpose(publicReadMethod)) {
                try {
                    if (readMethod != publicReadMethod) {
                        pd = new PropertyDescriptor(pd.getName(), publicReadMethod, null);
                        pd.setReadMethod(publicReadMethod);
                    }
                    introspData.put(pd.getName(), pd);
                }
                catch (IntrospectionException e) {
                    LOG.warn("Failed creating a publicly-accessible property descriptor for " + clazz.getName() + " property " + pd.getName() + ", read method " + publicReadMethod, e);
                }
            }
        }
    }

    private void addGenericGetToClassIntrospectionData(Map introspData, Map accessibleMethods) {
        Method genericGet = ClassIntrospector.getFirstAccessibleMethod(MethodSignature.GET_STRING_SIGNATURE, accessibleMethods);
        if (genericGet == null) {
            genericGet = ClassIntrospector.getFirstAccessibleMethod(MethodSignature.GET_OBJECT_SIGNATURE, accessibleMethods);
        }
        if (genericGet != null) {
            introspData.put(GENERIC_GET_KEY, genericGet);
        }
    }

    private void addConstructorsToClassIntrospectionData(Map introspData, Class clazz) {
        try {
            Constructor<?>[] ctors = clazz.getConstructors();
            if (ctors.length == 1) {
                Constructor<?> ctor = ctors[0];
                introspData.put(CONSTRUCTORS_KEY, new SimpleMethod(ctor, ctor.getParameterTypes()));
            } else if (ctors.length > 1) {
                OverloadedMethods ctorMap = new OverloadedMethods(this.bugfixed);
                for (int i = 0; i < ctors.length; ++i) {
                    ctorMap.addConstructor(ctors[i]);
                }
                introspData.put(CONSTRUCTORS_KEY, ctorMap);
            }
        }
        catch (SecurityException e) {
            LOG.warn("Can't discover constructors for class " + clazz.getName(), e);
        }
    }

    private static Map discoverAccessibleMethods(Class clazz) {
        HashMap accessibles = new HashMap();
        ClassIntrospector.discoverAccessibleMethods(clazz, accessibles);
        return accessibles;
    }

    private static void discoverAccessibleMethods(Class clazz, Map accessibles) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                Method[] methods = clazz.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    MethodSignature sig = new MethodSignature(method);
                    LinkedList<Method> methodList = (LinkedList<Method>)accessibles.get(sig);
                    if (methodList == null) {
                        methodList = new LinkedList<Method>();
                        accessibles.put(sig, methodList);
                    }
                    methodList.add(method);
                }
                return;
            }
            catch (SecurityException e) {
                LOG.warn("Could not discover accessible methods of class " + clazz.getName() + ", attemping superclasses/interfaces.", e);
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ClassIntrospector.discoverAccessibleMethods(interfaces[i], accessibles);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            ClassIntrospector.discoverAccessibleMethods(superclass, accessibles);
        }
    }

    private static Method getMatchingAccessibleMethod(Method m, Map accessibles) {
        if (m == null) {
            return null;
        }
        MethodSignature sig = new MethodSignature(m);
        List l = (List)accessibles.get(sig);
        if (l == null) {
            return null;
        }
        for (Method am : l) {
            if (am.getReturnType() != m.getReturnType()) continue;
            return am;
        }
        return null;
    }

    private static Method getFirstAccessibleMethod(MethodSignature sig, Map accessibles) {
        List l = (List)accessibles.get(sig);
        if (l == null || l.isEmpty()) {
            return null;
        }
        return (Method)l.iterator().next();
    }

    private MethodDescriptor[] sortMethodDescriptors(MethodDescriptor[] methodDescriptors) {
        return this.methodSorter != null ? this.methodSorter.sortMethodDescriptors(methodDescriptors) : methodDescriptors;
    }

    boolean isAllowedToExpose(Method method) {
        return this.exposureLevel < 1 || !UnsafeMethods.isUnsafeMethod(method);
    }

    private static Map getArgTypes(Map classMap) {
        HashMap argTypes = (HashMap)classMap.get(ARGTYPES_KEY);
        if (argTypes == null) {
            argTypes = new HashMap();
            classMap.put(ARGTYPES_KEY, argTypes);
        }
        return argTypes;
    }

    void clearCache() {
        if (this.getHasSharedInstanceRestrictons()) {
            throw new IllegalStateException("It's not allowed to clear the whole cache in a read-only " + this.getClass().getName() + "instance. Use removeFromClassIntrospectionCache(String prefix) instead.");
        }
        this.forcedClearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcedClearCache() {
        Object object = this.sharedLock;
        synchronized (object) {
            this.cache.clear();
            this.cacheClassNames.clear();
            ++this.clearingCounter;
            Iterator it = this.modelFactories.iterator();
            while (it.hasNext()) {
                Object regedMf = ((WeakReference)it.next()).get();
                if (regedMf == null) continue;
                if (regedMf instanceof ClassBasedModelFactory) {
                    ((ClassBasedModelFactory)regedMf).clearCache();
                    continue;
                }
                if (regedMf instanceof ModelCache) {
                    ((ModelCache)regedMf).clearCache();
                    continue;
                }
                throw new BugException();
            }
            this.removeClearedModelFactoryReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Class clazz) {
        Object object = this.sharedLock;
        synchronized (object) {
            this.cache.remove(clazz);
            this.cacheClassNames.remove(clazz.getName());
            ++this.clearingCounter;
            Iterator it = this.modelFactories.iterator();
            while (it.hasNext()) {
                Object regedMf = ((WeakReference)it.next()).get();
                if (regedMf == null) continue;
                if (regedMf instanceof ClassBasedModelFactory) {
                    ((ClassBasedModelFactory)regedMf).removeFromCache(clazz);
                    continue;
                }
                if (regedMf instanceof ModelCache) {
                    ((ModelCache)regedMf).clearCache();
                    continue;
                }
                throw new BugException();
            }
            this.removeClearedModelFactoryReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getClearingCounter() {
        Object object = this.sharedLock;
        synchronized (object) {
            return this.clearingCounter;
        }
    }

    private void onSameNameClassesDetected(String className) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Detected multiple classes with the same name, \"" + className + "\". Assuming it was a class-reloading. Clearing class introspection " + "caches to release old data.");
        }
        this.forcedClearCache();
    }

    void registerModelFactory(ClassBasedModelFactory mf) {
        this.registerModelFactory((Object)mf);
    }

    void registerModelFactory(ModelCache mf) {
        this.registerModelFactory((Object)mf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerModelFactory(Object mf) {
        Object object = this.sharedLock;
        synchronized (object) {
            this.modelFactories.add(new WeakReference<Object>(mf, this.modelFactoriesRefQueue));
            this.removeClearedModelFactoryReferences();
        }
    }

    void unregisterModelFactory(ClassBasedModelFactory mf) {
        this.unregisterModelFactory((Object)mf);
    }

    void unregisterModelFactory(ModelCache mf) {
        this.unregisterModelFactory((Object)mf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterModelFactory(Object mf) {
        Object object = this.sharedLock;
        synchronized (object) {
            Iterator it = this.modelFactories.iterator();
            while (it.hasNext()) {
                Object regedMf = ((Reference)it.next()).get();
                if (regedMf != mf) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClearedModelFactoryReferences() {
        Reference cleardRef;
        while ((cleardRef = this.modelFactoriesRefQueue.poll()) != null) {
            Object object = this.sharedLock;
            synchronized (object) {
                Iterator it = this.modelFactories.iterator();
                while (it.hasNext()) {
                    if (it.next() != cleardRef) continue;
                    it.remove();
                    break;
                }
            }
        }
    }

    static Class[] getArgTypes(Map classMap, AccessibleObject methodOrCtor) {
        return (Class[])((Map)classMap.get(ARGTYPES_KEY)).get(methodOrCtor);
    }

    int keyCount(Class clazz) {
        Map map = this.get(clazz);
        int count = map.size();
        if (map.containsKey(CONSTRUCTORS_KEY)) {
            --count;
        }
        if (map.containsKey(GENERIC_GET_KEY)) {
            --count;
        }
        if (map.containsKey(ARGTYPES_KEY)) {
            --count;
        }
        return count;
    }

    Set keySet(Class clazz) {
        HashSet set = new HashSet(this.get(clazz).keySet());
        set.remove(CONSTRUCTORS_KEY);
        set.remove(GENERIC_GET_KEY);
        set.remove(ARGTYPES_KEY);
        return set;
    }

    int getExposureLevel() {
        return this.exposureLevel;
    }

    boolean getExposeFields() {
        return this.exposeFields;
    }

    MethodAppearanceFineTuner getMethodAppearanceFineTuner() {
        return this.methodAppearanceFineTuner;
    }

    MethodSorter getMethodSorter() {
        return this.methodSorter;
    }

    boolean getHasSharedInstanceRestrictons() {
        return this.hasSharedInstanceRestrictons;
    }

    boolean isShared() {
        return this.shared;
    }

    Object getSharedLock() {
        return this.sharedLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getRegisteredModelFactoriesSnapshot() {
        Object object = this.sharedLock;
        synchronized (object) {
            return this.modelFactories.toArray();
        }
    }

    static {
        ClassChangeNotifier classChangeNotifier;
        boolean jRebelAvailable;
        LOG = Logger.getLogger("freemarker.beans");
        DEVELOPMENT_MODE = "true".equals(SecurityUtilities.getSystemProperty("freemarker.development", "false"));
        try {
            Class.forName(JREBEL_SDK_CLASS_NAME);
            jRebelAvailable = true;
        }
        catch (Throwable e) {
            jRebelAvailable = false;
            try {
                if (!(e instanceof ClassNotFoundException)) {
                    LOG.error(JREBEL_INTEGRATION_ERROR_MSG, e);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (jRebelAvailable) {
            try {
                classChangeNotifier = (ClassChangeNotifier)Class.forName("freemarker.ext.beans.JRebelClassChangeNotifier").newInstance();
            }
            catch (Throwable e) {
                classChangeNotifier = null;
                try {
                    LOG.error(JREBEL_INTEGRATION_ERROR_MSG, e);
                }
                catch (Throwable throwable) {}
            }
        } else {
            classChangeNotifier = null;
        }
        CLASS_CHANGE_NOTIFIER = classChangeNotifier;
        ARGTYPES_KEY = new Object();
        CONSTRUCTORS_KEY = new Object();
        GENERIC_GET_KEY = new Object();
    }

    private static final class MethodSignature {
        private static final MethodSignature GET_STRING_SIGNATURE = new MethodSignature("get", new Class[]{String.class});
        private static final MethodSignature GET_OBJECT_SIGNATURE = new MethodSignature("get", new Class[]{Object.class});
        private final String name;
        private final Class[] args;

        private MethodSignature(String name, Class[] args) {
            this.name = name;
            this.args = args;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

