/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.debezium.db2.DebeziumDb2Component;

/**
 * Capture changes from a DB2 database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface DebeziumDb2ComponentBuilderFactory {

    /**
     * Debezium DB2 Connector (camel-debezium-db2)
     * Capture changes from a DB2 database.
     * 
     * Category: database
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-debezium-db2
     * 
     * @return the dsl builder
     */
    static DebeziumDb2ComponentBuilder debeziumDb2() {
        return new DebeziumDb2ComponentBuilderImpl();
    }

    /**
     * Builder for the Debezium DB2 Connector component.
     */
    interface DebeziumDb2ComponentBuilder extends ComponentBuilder<DebeziumDb2Component> {
    
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;additionalProperties.schema.registry.url=http://localhost:8811/avro. This is a multi-value option with prefix: additionalProperties.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param additionalProperties the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder additionalProperties(java.util.Map<java.lang.String, java.lang.Object> additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        /**
         * Allow pre-configured Configurations to be set.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.debezium.db2.configuration.Db2ConnectorEmbeddedDebeziumConfiguration&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder configuration(org.apache.camel.component.debezium.db2.configuration.Db2ConnectorEmbeddedDebeziumConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalKeyConverter the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder internalKeyConverter(java.lang.String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
    
        
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalValueConverter the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder internalValueConverter(java.lang.String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
    
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetCommitPolicy the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder offsetCommitPolicy(java.lang.String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
    
        
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder offsetCommitTimeoutMs(long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
    
        
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder offsetFlushIntervalMs(long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
    
        
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         * 
         * @param offsetStorage the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder offsetStorage(java.lang.String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
    
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageFileName the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder offsetStorageFileName(java.lang.String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
    
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder offsetStoragePartitions(int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
    
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder offsetStorageReplicationFactor(int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
    
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageTopic the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder offsetStorageTopic(java.lang.String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        
        /**
         * The name of the schema where CDC change tables are located; defaults
         * to 'ASNCDC'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ASNCDC
         * Group: db2
         * 
         * @param cdcChangeTablesSchema the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder cdcChangeTablesSchema(java.lang.String cdcChangeTablesSchema) {
            doSetProperty("cdcChangeTablesSchema", cdcChangeTablesSchema);
            return this;
        }
    
        
        /**
         * The name of the schema where CDC control structures are located;
         * defaults to 'ASNCDC'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ASNCDC
         * Group: db2
         * 
         * @param cdcControlSchema the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder cdcControlSchema(java.lang.String cdcControlSchema) {
            doSetProperty("cdcControlSchema", cdcControlSchema);
            return this;
        }
    
        /**
         * Regular expressions matching columns to exclude from change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param columnExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder columnExcludeList(java.lang.String columnExcludeList) {
            doSetProperty("columnExcludeList", columnExcludeList);
            return this;
        }
    
        /**
         * Regular expressions matching columns to include in change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param columnIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder columnIncludeList(java.lang.String columnIncludeList) {
            doSetProperty("columnIncludeList", columnIncludeList);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions matching
         * fully-qualified names of columns that adds the columns original type
         * and original length as parameters to the corresponding field schemas
         * in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param columnPropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder columnPropagateSourceType(java.lang.String columnPropagateSourceType) {
            doSetProperty("columnPropagateSourceType", columnPropagateSourceType);
            return this;
        }
    
        
        /**
         * The maximum time in milliseconds to wait for connection validation to
         * complete. Defaults to 60 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1m
         * Group: db2
         * 
         * @param connectionValidationTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder connectionValidationTimeoutMs(long connectionValidationTimeoutMs) {
            doSetProperty("connectionValidationTimeoutMs", connectionValidationTimeoutMs);
            return this;
        }
    
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param converters the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder converters(java.lang.String converters) {
            doSetProperty("converters", converters);
            return this;
        }
    
        /**
         * The custom metric tags will accept key-value pairs to customize the
         * MBean object name which should be appended the end of regular name,
         * each key would represent a tag for the MBean object name, and the
         * corresponding value would be the value of that tag the key is. For
         * example: k1=v1,k2=v2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param customMetricTags the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder customMetricTags(java.lang.String customMetricTags) {
            doSetProperty("customMetricTags", customMetricTags);
            return this;
        }
    
        /**
         * The name of the database from which the connector should capture
         * changes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databaseDbname the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder databaseDbname(java.lang.String databaseDbname) {
            doSetProperty("databaseDbname", databaseDbname);
            return this;
        }
    
        /**
         * Resolvable hostname or IP address of the database server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databaseHostname the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder databaseHostname(java.lang.String databaseHostname) {
            doSetProperty("databaseHostname", databaseHostname);
            return this;
        }
    
        /**
         * Password of the database user to be used when connecting to the
         * database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databasePassword the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder databasePassword(java.lang.String databasePassword) {
            doSetProperty("databasePassword", databasePassword);
            return this;
        }
    
        
        /**
         * Port of the database server.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50000
         * Group: db2
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder databasePort(int databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
    
        /**
         * Name of the database user to be used when connecting to the database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databaseUser the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder databaseUser(java.lang.String databaseUser) {
            doSetProperty("databaseUser", databaseUser);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions matching the
         * database-specific data type names that adds the data type's original
         * type and original length as parameters to the corresponding field
         * schemas in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param datatypePropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder datatypePropagateSourceType(java.lang.String datatypePropagateSourceType) {
            doSetProperty("datatypePropagateSourceType", datatypePropagateSourceType);
            return this;
        }
    
        
        /**
         * Informs connector which Db2 implementation platform it is connected
         * to. The default is 'LUW', which means Windows, UNIX, Linux. Using a
         * value of 'Z' ensures that the Db2 for z/OS specific SQL statements
         * are used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: LUW
         * Group: db2
         * 
         * @param db2Platform the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder db2Platform(java.lang.String db2Platform) {
            doSetProperty("db2Platform", db2Platform);
            return this;
        }
    
        
        /**
         * Specify how DECIMAL and NUMERIC columns should be represented in
         * change events, including: 'precise' (the default) uses
         * java.math.BigDecimal to represent values, which are encoded in the
         * change events using a binary representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
         * represent values; 'double' represents values using Java's 'double',
         * which may not offer the precision but will be far easier to use in
         * consumers.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: precise
         * Group: db2
         * 
         * @param decimalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder decimalHandlingMode(java.lang.String decimalHandlingMode) {
            doSetProperty("decimalHandlingMode", decimalHandlingMode);
            return this;
        }
    
        
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: db2
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder errorsMaxRetries(int errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
    
        
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including: 'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped; 'ignore' the problematic event will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: fail
         * Group: db2
         * 
         * @param eventProcessingFailureHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder eventProcessingFailureHandlingMode(java.lang.String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
    
        
        /**
         * The maximum time in milliseconds to wait for task executor to shut
         * down.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 4s
         * Group: db2
         * 
         * @param executorShutdownTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder executorShutdownTimeoutMs(long executorShutdownTimeoutMs) {
            doSetProperty("executorShutdownTimeoutMs", executorShutdownTimeoutMs);
            return this;
        }
    
        
        /**
         * Enable/Disable Debezium context headers that provides essential
         * metadata for tracking and identifying the source of CDC events in
         * downstream processing systems.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: db2
         * 
         * @param extendedHeadersEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder extendedHeadersEnabled(boolean extendedHeadersEnabled) {
            doSetProperty("extendedHeadersEnabled", extendedHeadersEnabled);
            return this;
        }
    
        
        /**
         * Specify the action to take when a guardrail collections limit is
         * exceeded: 'warn' (the default) logs a warning message and continues
         * processing; 'fail' stops the connector with an error.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: warn
         * Group: db2
         * 
         * @param guardrailCollectionsLimitAction the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder guardrailCollectionsLimitAction(java.lang.String guardrailCollectionsLimitAction) {
            doSetProperty("guardrailCollectionsLimitAction", guardrailCollectionsLimitAction);
            return this;
        }
    
        /**
         * The maximum number of collections or tables that can be captured by
         * the connector. When this limit is exceeded, the action specified by
         * 'guardrail.collections.limit.action' will be taken. Set to 0 to
         * disable this guardrail.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param guardrailCollectionsMax the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder guardrailCollectionsMax(int guardrailCollectionsMax) {
            doSetProperty("guardrailCollectionsMax", guardrailCollectionsMax);
            return this;
        }
    
        
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: db2
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder heartbeatIntervalMs(int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
    
        
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: __debezium-heartbeat
         * Group: db2
         * 
         * @param heartbeatTopicsPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder heartbeatTopicsPrefix(java.lang.String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
    
        
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s). The default is 'true'. This is
         * independent of how the connector internally records database schema
         * history.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: db2
         * 
         * @param includeSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder includeSchemaChanges(boolean includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
    
        
        /**
         * The maximum size of chunk (number of documents/rows) for incremental
         * snapshotting.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: db2
         * 
         * @param incrementalSnapshotChunkSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder incrementalSnapshotChunkSize(int incrementalSnapshotChunkSize) {
            doSetProperty("incrementalSnapshotChunkSize", incrementalSnapshotChunkSize);
            return this;
        }
    
        
        /**
         * Specify the strategy used for watermarking during an incremental
         * snapshot: 'insert_insert' both open and close signal is written into
         * signal data collection (default); 'insert_delete' only open signal is
         * written on signal data collection, the close will delete the relative
         * open signal;.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: INSERT_INSERT
         * Group: db2
         * 
         * @param incrementalSnapshotWatermarkingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder incrementalSnapshotWatermarkingStrategy(java.lang.String incrementalSnapshotWatermarkingStrategy) {
            doSetProperty("incrementalSnapshotWatermarkingStrategy", incrementalSnapshotWatermarkingStrategy);
            return this;
        }
    
        
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2048
         * Group: db2
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
    
        
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: db2
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
    
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder maxQueueSizeInBytes(long maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
    
        /**
         * A semicolon-separated list of expressions that match fully-qualified
         * tables and column(s) to be used as message key. Each expression must
         * match the pattern ':', where the table names could be defined as
         * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
         * specific connector, and the key columns are a comma-separated list of
         * columns representing the custom key. For any table without an
         * explicit key configuration the table's primary key column(s) will be
         * used as message key. Example:
         * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param messageKeyColumns the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder messageKeyColumns(java.lang.String messageKeyColumns) {
            doSetProperty("messageKeyColumns", messageKeyColumns);
            return this;
        }
    
        /**
         * List of notification channels names that are enabled.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param notificationEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder notificationEnabledChannels(java.lang.String notificationEnabledChannels) {
            doSetProperty("notificationEnabledChannels", notificationEnabledChannels);
            return this;
        }
    
        /**
         * The name of the topic for the notifications. This is required in case
         * 'sink' is in the list of enabled channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param notificationSinkTopicName the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder notificationSinkTopicName(java.lang.String notificationSinkTopicName) {
            doSetProperty("notificationSinkTopicName", notificationSinkTopicName);
            return this;
        }
    
        
        /**
         * Path to OpenLineage file configuration. See
         * https://openlineage.io/docs/client/java/configuration.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ./openlineage.yml
         * Group: db2
         * 
         * @param openlineageIntegrationConfigFilePath the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder openlineageIntegrationConfigFilePath(java.lang.String openlineageIntegrationConfigFilePath) {
            doSetProperty("openlineageIntegrationConfigFilePath", openlineageIntegrationConfigFilePath);
            return this;
        }
    
        /**
         * The Kafka bootstrap server address used as input/output namespace/.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param openlineageIntegrationDatasetKafkaBootstrapServers the value
         * to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder openlineageIntegrationDatasetKafkaBootstrapServers(java.lang.String openlineageIntegrationDatasetKafkaBootstrapServers) {
            doSetProperty("openlineageIntegrationDatasetKafkaBootstrapServers", openlineageIntegrationDatasetKafkaBootstrapServers);
            return this;
        }
    
        
        /**
         * Enable Debezium to emit data lineage metadata through OpenLineage
         * API.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param openlineageIntegrationEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder openlineageIntegrationEnabled(boolean openlineageIntegrationEnabled) {
            doSetProperty("openlineageIntegrationEnabled", openlineageIntegrationEnabled);
            return this;
        }
    
        
        /**
         * The job's description emitted by Debezium.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Debezium change data capture job
         * Group: db2
         * 
         * @param openlineageIntegrationJobDescription the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder openlineageIntegrationJobDescription(java.lang.String openlineageIntegrationJobDescription) {
            doSetProperty("openlineageIntegrationJobDescription", openlineageIntegrationJobDescription);
            return this;
        }
    
        /**
         * The job's namespace emitted by Debezium.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param openlineageIntegrationJobNamespace the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder openlineageIntegrationJobNamespace(java.lang.String openlineageIntegrationJobNamespace) {
            doSetProperty("openlineageIntegrationJobNamespace", openlineageIntegrationJobNamespace);
            return this;
        }
    
        /**
         * The job's owners emitted by Debezium. A comma-separated list of
         * key-value pairs.For example: k1=v1,k2=v2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param openlineageIntegrationJobOwners the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder openlineageIntegrationJobOwners(java.lang.String openlineageIntegrationJobOwners) {
            doSetProperty("openlineageIntegrationJobOwners", openlineageIntegrationJobOwners);
            return this;
        }
    
        /**
         * The job's tags emitted by Debezium. A comma-separated list of
         * key-value pairs.For example: k1=v1,k2=v2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param openlineageIntegrationJobTags the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder openlineageIntegrationJobTags(java.lang.String openlineageIntegrationJobTags) {
            doSetProperty("openlineageIntegrationJobTags", openlineageIntegrationJobTags);
            return this;
        }
    
        
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500ms
         * Group: db2
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder pollIntervalMs(long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
    
        /**
         * Optional list of post processors. The processors are defined using
         * '.type' config option and configured using options ''.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param postProcessors the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder postProcessors(java.lang.String postProcessors) {
            doSetProperty("postProcessors", postProcessors);
            return this;
        }
    
        
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder provideTransactionMetadata(boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
    
        
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of '0' uses the default JDBC fetch size. The
         * default value is '10000'.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: db2
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder queryFetchSize(int queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
    
        
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: db2
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder retriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
    
        
        /**
         * The name of the SchemaHistory class that should be used to store and
         * recover database schema changes. The configuration properties for the
         * history are prefixed with the 'schema.history.internal.' string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.storage.kafka.history.KafkaSchemaHistory
         * Group: db2
         * 
         * @param schemaHistoryInternal the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder schemaHistoryInternal(java.lang.String schemaHistoryInternal) {
            doSetProperty("schemaHistoryInternal", schemaHistoryInternal);
            return this;
        }
    
        /**
         * The path to the file that will be used to record the database schema
         * history.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param schemaHistoryInternalFileFilename the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder schemaHistoryInternalFileFilename(java.lang.String schemaHistoryInternalFileFilename) {
            doSetProperty("schemaHistoryInternalFileFilename", schemaHistoryInternalFileFilename);
            return this;
        }
    
        
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param schemaHistoryInternalSkipUnparseableDdl the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder schemaHistoryInternalSkipUnparseableDdl(boolean schemaHistoryInternalSkipUnparseableDdl) {
            doSetProperty("schemaHistoryInternalSkipUnparseableDdl", schemaHistoryInternalSkipUnparseableDdl);
            return this;
        }
    
        
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a table from captured
         * schema/database will be stored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedDatabasesDdl the value
         * to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder schemaHistoryInternalStoreOnlyCapturedDatabasesDdl(boolean schemaHistoryInternalStoreOnlyCapturedDatabasesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedDatabasesDdl", schemaHistoryInternalStoreOnlyCapturedDatabasesDdl);
            return this;
        }
    
        
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a captured table will be
         * stored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedTablesDdl the value to
         * set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder schemaHistoryInternalStoreOnlyCapturedTablesDdl(boolean schemaHistoryInternalStoreOnlyCapturedTablesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedTablesDdl", schemaHistoryInternalStoreOnlyCapturedTablesDdl);
            return this;
        }
    
        
        /**
         * Specify how schema names should be adjusted for compatibility with
         * the message converter used by the connector, including: 'avro'
         * replaces the characters that cannot be used in the Avro type name
         * with underscore; 'avro_unicode' replaces the underscore or characters
         * that cannot be used in the Avro type name with corresponding unicode
         * like _uxxxx. Note: _ is an escape sequence like backslash in
         * Java;'none' does not apply any adjustment (default).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: db2
         * 
         * @param schemaNameAdjustmentMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder schemaNameAdjustmentMode(java.lang.String schemaNameAdjustmentMode) {
            doSetProperty("schemaNameAdjustmentMode", schemaNameAdjustmentMode);
            return this;
        }
    
        /**
         * The name of the data collection that is used to send signals/commands
         * to Debezium. Signaling is disabled when not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param signalDataCollection the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder signalDataCollection(java.lang.String signalDataCollection) {
            doSetProperty("signalDataCollection", signalDataCollection);
            return this;
        }
    
        
        /**
         * List of channels names that are enabled. Source channel is enabled by
         * default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: source
         * Group: db2
         * 
         * @param signalEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder signalEnabledChannels(java.lang.String signalEnabledChannels) {
            doSetProperty("signalEnabledChannels", signalEnabledChannels);
            return this;
        }
    
        
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5s
         * Group: db2
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder signalPollIntervalMs(long signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
    
        
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes,
         * 't' for truncates, and 'none' to indicate nothing skipped. By
         * default, only truncate operations will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: t
         * Group: db2
         * 
         * @param skippedOperations the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder skippedOperations(java.lang.String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
    
        
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: db2
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotDelayMs(long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
    
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotFetchSize(int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
    
        /**
         * This setting must be set to specify a list of tables/collections
         * whose snapshot must be taken on creating or restarting the connector.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param snapshotIncludeCollectionList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotIncludeCollectionList(java.lang.String snapshotIncludeCollectionList) {
            doSetProperty("snapshotIncludeCollectionList", snapshotIncludeCollectionList);
            return this;
        }
    
        
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: db2
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
    
        
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Options include: 'initial' (the default) to specify the connector
         * should run a snapshot only when no offsets are available for the
         * logical server name; 'schema_only' to specify the connector should
         * run a snapshot of the schema when no offsets are available for the
         * logical server name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: initial
         * Group: db2
         * 
         * @param snapshotMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotMode(java.lang.String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param snapshotModeConfigurationBasedSnapshotData the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotData", snapshotModeConfigurationBasedSnapshotData);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not in
         * case of error.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnDataError the value to
         * set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnDataError", snapshotModeConfigurationBasedSnapshotOnDataError);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not
         * in case of error.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnSchemaError the value
         * to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnSchemaError", snapshotModeConfigurationBasedSnapshotOnSchemaError);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param snapshotModeConfigurationBasedSnapshotSchema the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotSchema", snapshotModeConfigurationBasedSnapshotSchema);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the stream should start or not after
         * snapshot.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param snapshotModeConfigurationBasedStartStream the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
            doSetProperty("snapshotModeConfigurationBasedStartStream", snapshotModeConfigurationBasedStartStream);
            return this;
        }
    
        /**
         * When 'snapshot.mode' is set as custom, this setting must be set to
         * specify a the name of the custom implementation provided in the
         * 'name()' method. The implementations must implement the 'Snapshotter'
         * interface and is called on each app boot to determine whether to do a
         * snapshot.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param snapshotModeCustomName the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotModeCustomName(java.lang.String snapshotModeCustomName) {
            doSetProperty("snapshotModeCustomName", snapshotModeCustomName);
            return this;
        }
    
        /**
         * This property contains a comma-separated list of fully-qualified
         * tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
         * the specific connectors. Select statements for the individual tables
         * are specified in further configuration properties, one for each
         * table, identified by the id
         * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
         * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
         * respectively. The value of those properties is the select statement
         * to use when retrieving data from the specific table during
         * snapshotting. A possible use case for large append-only tables is
         * setting a specific point where to start (resume) snapshotting, in
         * case a previous snapshotting was interrupted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param snapshotSelectStatementOverrides the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotSelectStatementOverrides(java.lang.String snapshotSelectStatementOverrides) {
            doSetProperty("snapshotSelectStatementOverrides", snapshotSelectStatementOverrides);
            return this;
        }
    
        
        /**
         * Controls the order in which tables are processed in the initial
         * snapshot. A descending value will order the tables by row count
         * descending. A ascending value will order the tables by row count
         * ascending. A value of disabled (the default) will disable ordering by
         * row count.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: disabled
         * Group: db2
         * 
         * @param snapshotTablesOrderByRowCount the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder snapshotTablesOrderByRowCount(java.lang.String snapshotTablesOrderByRowCount) {
            doSetProperty("snapshotTablesOrderByRowCount", snapshotTablesOrderByRowCount);
            return this;
        }
    
        
        /**
         * The name of the SourceInfoStructMaker class that returns SourceInfo
         * schema and struct.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.connector.db2.Db2SourceInfoStructMaker
         * Group: db2
         * 
         * @param sourceinfoStructMaker the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder sourceinfoStructMaker(java.lang.String sourceinfoStructMaker) {
            doSetProperty("sourceinfoStructMaker", sourceinfoStructMaker);
            return this;
        }
    
        
        /**
         * A delay period after the snapshot is completed and the streaming
         * begins, given in milliseconds. Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: db2
         * 
         * @param streamingDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder streamingDelayMs(long streamingDelayMs) {
            doSetProperty("streamingDelayMs", streamingDelayMs);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions that match the
         * fully-qualified names of tables to be excluded from monitoring.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param tableExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder tableExcludeList(java.lang.String tableExcludeList) {
            doSetProperty("tableExcludeList", tableExcludeList);
            return this;
        }
    
        
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: db2
         * 
         * @param tableIgnoreBuiltin the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder tableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
    
        /**
         * The tables for which changes are to be captured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param tableIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder tableIncludeList(java.lang.String tableIncludeList) {
            doSetProperty("tableIncludeList", tableIncludeList);
            return this;
        }
    
        
        /**
         * Time, date, and timestamps can be represented with different kinds of
         * precisions, including: 'adaptive' (the default) bases the precision
         * of time, date, and timestamp values on the database column's
         * precision; 'adaptive_time_microseconds' like 'adaptive' mode, but
         * TIME fields always use microseconds precision; 'connect' always
         * represents time, date, and timestamp values using Kafka Connect's
         * built-in representations for Time, Date, and Timestamp, which uses
         * millisecond precision regardless of the database columns' precision.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: adaptive
         * Group: db2
         * 
         * @param timePrecisionMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder timePrecisionMode(java.lang.String timePrecisionMode) {
            doSetProperty("timePrecisionMode", timePrecisionMode);
            return this;
        }
    
        
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder tombstonesOnDelete(boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
    
        
        /**
         * The name of the TopicNamingStrategy class that should be used to
         * determine the topic name for data change, schema change, transaction,
         * heartbeat event etc.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.schema.SchemaTopicNamingStrategy
         * Group: db2
         * 
         * @param topicNamingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder topicNamingStrategy(java.lang.String topicNamingStrategy) {
            doSetProperty("topicNamingStrategy", topicNamingStrategy);
            return this;
        }
    
        /**
         * Topic prefix that identifies and provides a namespace for the
         * particular database server/cluster is capturing changes. The topic
         * prefix should be unique across all other connectors, since it is used
         * as a prefix for all Kafka topic names that receive events emitted by
         * this connector. Only alphanumeric characters, hyphens, dots and
         * underscores must be accepted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param topicPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder topicPrefix(java.lang.String topicPrefix) {
            doSetProperty("topicPrefix", topicPrefix);
            return this;
        }
    
        
        /**
         * Class to make transaction context &amp; transaction struct/schemas.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default:
         * io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory
         * Group: db2
         * 
         * @param transactionMetadataFactory the value to set
         * @return the dsl builder
         */
        default DebeziumDb2ComponentBuilder transactionMetadataFactory(java.lang.String transactionMetadataFactory) {
            doSetProperty("transactionMetadataFactory", transactionMetadataFactory);
            return this;
        }
    }

    class DebeziumDb2ComponentBuilderImpl
            extends AbstractComponentBuilder<DebeziumDb2Component>
            implements DebeziumDb2ComponentBuilder {
        @Override
        protected DebeziumDb2Component buildConcreteComponent() {
            return new DebeziumDb2Component();
        }
        private org.apache.camel.component.debezium.db2.configuration.Db2ConnectorEmbeddedDebeziumConfiguration getOrCreateConfiguration(DebeziumDb2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.debezium.db2.configuration.Db2ConnectorEmbeddedDebeziumConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "additionalProperties": getOrCreateConfiguration((DebeziumDb2Component) component).setAdditionalProperties((java.util.Map) value); return true;
            case "bridgeErrorHandler": ((DebeziumDb2Component) component).setBridgeErrorHandler((boolean) value); return true;
            case "configuration": ((DebeziumDb2Component) component).setConfiguration((org.apache.camel.component.debezium.db2.configuration.Db2ConnectorEmbeddedDebeziumConfiguration) value); return true;
            case "internalKeyConverter": getOrCreateConfiguration((DebeziumDb2Component) component).setInternalKeyConverter((java.lang.String) value); return true;
            case "internalValueConverter": getOrCreateConfiguration((DebeziumDb2Component) component).setInternalValueConverter((java.lang.String) value); return true;
            case "offsetCommitPolicy": getOrCreateConfiguration((DebeziumDb2Component) component).setOffsetCommitPolicy((java.lang.String) value); return true;
            case "offsetCommitTimeoutMs": getOrCreateConfiguration((DebeziumDb2Component) component).setOffsetCommitTimeoutMs((long) value); return true;
            case "offsetFlushIntervalMs": getOrCreateConfiguration((DebeziumDb2Component) component).setOffsetFlushIntervalMs((long) value); return true;
            case "offsetStorage": getOrCreateConfiguration((DebeziumDb2Component) component).setOffsetStorage((java.lang.String) value); return true;
            case "offsetStorageFileName": getOrCreateConfiguration((DebeziumDb2Component) component).setOffsetStorageFileName((java.lang.String) value); return true;
            case "offsetStoragePartitions": getOrCreateConfiguration((DebeziumDb2Component) component).setOffsetStoragePartitions((int) value); return true;
            case "offsetStorageReplicationFactor": getOrCreateConfiguration((DebeziumDb2Component) component).setOffsetStorageReplicationFactor((int) value); return true;
            case "offsetStorageTopic": getOrCreateConfiguration((DebeziumDb2Component) component).setOffsetStorageTopic((java.lang.String) value); return true;
            case "autowiredEnabled": ((DebeziumDb2Component) component).setAutowiredEnabled((boolean) value); return true;
            case "cdcChangeTablesSchema": getOrCreateConfiguration((DebeziumDb2Component) component).setCdcChangeTablesSchema((java.lang.String) value); return true;
            case "cdcControlSchema": getOrCreateConfiguration((DebeziumDb2Component) component).setCdcControlSchema((java.lang.String) value); return true;
            case "columnExcludeList": getOrCreateConfiguration((DebeziumDb2Component) component).setColumnExcludeList((java.lang.String) value); return true;
            case "columnIncludeList": getOrCreateConfiguration((DebeziumDb2Component) component).setColumnIncludeList((java.lang.String) value); return true;
            case "columnPropagateSourceType": getOrCreateConfiguration((DebeziumDb2Component) component).setColumnPropagateSourceType((java.lang.String) value); return true;
            case "connectionValidationTimeoutMs": getOrCreateConfiguration((DebeziumDb2Component) component).setConnectionValidationTimeoutMs((long) value); return true;
            case "converters": getOrCreateConfiguration((DebeziumDb2Component) component).setConverters((java.lang.String) value); return true;
            case "customMetricTags": getOrCreateConfiguration((DebeziumDb2Component) component).setCustomMetricTags((java.lang.String) value); return true;
            case "databaseDbname": getOrCreateConfiguration((DebeziumDb2Component) component).setDatabaseDbname((java.lang.String) value); return true;
            case "databaseHostname": getOrCreateConfiguration((DebeziumDb2Component) component).setDatabaseHostname((java.lang.String) value); return true;
            case "databasePassword": getOrCreateConfiguration((DebeziumDb2Component) component).setDatabasePassword((java.lang.String) value); return true;
            case "databasePort": getOrCreateConfiguration((DebeziumDb2Component) component).setDatabasePort((int) value); return true;
            case "databaseUser": getOrCreateConfiguration((DebeziumDb2Component) component).setDatabaseUser((java.lang.String) value); return true;
            case "datatypePropagateSourceType": getOrCreateConfiguration((DebeziumDb2Component) component).setDatatypePropagateSourceType((java.lang.String) value); return true;
            case "db2Platform": getOrCreateConfiguration((DebeziumDb2Component) component).setDb2Platform((java.lang.String) value); return true;
            case "decimalHandlingMode": getOrCreateConfiguration((DebeziumDb2Component) component).setDecimalHandlingMode((java.lang.String) value); return true;
            case "errorsMaxRetries": getOrCreateConfiguration((DebeziumDb2Component) component).setErrorsMaxRetries((int) value); return true;
            case "eventProcessingFailureHandlingMode": getOrCreateConfiguration((DebeziumDb2Component) component).setEventProcessingFailureHandlingMode((java.lang.String) value); return true;
            case "executorShutdownTimeoutMs": getOrCreateConfiguration((DebeziumDb2Component) component).setExecutorShutdownTimeoutMs((long) value); return true;
            case "extendedHeadersEnabled": getOrCreateConfiguration((DebeziumDb2Component) component).setExtendedHeadersEnabled((boolean) value); return true;
            case "guardrailCollectionsLimitAction": getOrCreateConfiguration((DebeziumDb2Component) component).setGuardrailCollectionsLimitAction((java.lang.String) value); return true;
            case "guardrailCollectionsMax": getOrCreateConfiguration((DebeziumDb2Component) component).setGuardrailCollectionsMax((int) value); return true;
            case "heartbeatIntervalMs": getOrCreateConfiguration((DebeziumDb2Component) component).setHeartbeatIntervalMs((int) value); return true;
            case "heartbeatTopicsPrefix": getOrCreateConfiguration((DebeziumDb2Component) component).setHeartbeatTopicsPrefix((java.lang.String) value); return true;
            case "includeSchemaChanges": getOrCreateConfiguration((DebeziumDb2Component) component).setIncludeSchemaChanges((boolean) value); return true;
            case "incrementalSnapshotChunkSize": getOrCreateConfiguration((DebeziumDb2Component) component).setIncrementalSnapshotChunkSize((int) value); return true;
            case "incrementalSnapshotWatermarkingStrategy": getOrCreateConfiguration((DebeziumDb2Component) component).setIncrementalSnapshotWatermarkingStrategy((java.lang.String) value); return true;
            case "maxBatchSize": getOrCreateConfiguration((DebeziumDb2Component) component).setMaxBatchSize((int) value); return true;
            case "maxQueueSize": getOrCreateConfiguration((DebeziumDb2Component) component).setMaxQueueSize((int) value); return true;
            case "maxQueueSizeInBytes": getOrCreateConfiguration((DebeziumDb2Component) component).setMaxQueueSizeInBytes((long) value); return true;
            case "messageKeyColumns": getOrCreateConfiguration((DebeziumDb2Component) component).setMessageKeyColumns((java.lang.String) value); return true;
            case "notificationEnabledChannels": getOrCreateConfiguration((DebeziumDb2Component) component).setNotificationEnabledChannels((java.lang.String) value); return true;
            case "notificationSinkTopicName": getOrCreateConfiguration((DebeziumDb2Component) component).setNotificationSinkTopicName((java.lang.String) value); return true;
            case "openlineageIntegrationConfigFilePath": getOrCreateConfiguration((DebeziumDb2Component) component).setOpenlineageIntegrationConfigFilePath((java.lang.String) value); return true;
            case "openlineageIntegrationDatasetKafkaBootstrapServers": getOrCreateConfiguration((DebeziumDb2Component) component).setOpenlineageIntegrationDatasetKafkaBootstrapServers((java.lang.String) value); return true;
            case "openlineageIntegrationEnabled": getOrCreateConfiguration((DebeziumDb2Component) component).setOpenlineageIntegrationEnabled((boolean) value); return true;
            case "openlineageIntegrationJobDescription": getOrCreateConfiguration((DebeziumDb2Component) component).setOpenlineageIntegrationJobDescription((java.lang.String) value); return true;
            case "openlineageIntegrationJobNamespace": getOrCreateConfiguration((DebeziumDb2Component) component).setOpenlineageIntegrationJobNamespace((java.lang.String) value); return true;
            case "openlineageIntegrationJobOwners": getOrCreateConfiguration((DebeziumDb2Component) component).setOpenlineageIntegrationJobOwners((java.lang.String) value); return true;
            case "openlineageIntegrationJobTags": getOrCreateConfiguration((DebeziumDb2Component) component).setOpenlineageIntegrationJobTags((java.lang.String) value); return true;
            case "pollIntervalMs": getOrCreateConfiguration((DebeziumDb2Component) component).setPollIntervalMs((long) value); return true;
            case "postProcessors": getOrCreateConfiguration((DebeziumDb2Component) component).setPostProcessors((java.lang.String) value); return true;
            case "provideTransactionMetadata": getOrCreateConfiguration((DebeziumDb2Component) component).setProvideTransactionMetadata((boolean) value); return true;
            case "queryFetchSize": getOrCreateConfiguration((DebeziumDb2Component) component).setQueryFetchSize((int) value); return true;
            case "retriableRestartConnectorWaitMs": getOrCreateConfiguration((DebeziumDb2Component) component).setRetriableRestartConnectorWaitMs((long) value); return true;
            case "schemaHistoryInternal": getOrCreateConfiguration((DebeziumDb2Component) component).setSchemaHistoryInternal((java.lang.String) value); return true;
            case "schemaHistoryInternalFileFilename": getOrCreateConfiguration((DebeziumDb2Component) component).setSchemaHistoryInternalFileFilename((java.lang.String) value); return true;
            case "schemaHistoryInternalSkipUnparseableDdl": getOrCreateConfiguration((DebeziumDb2Component) component).setSchemaHistoryInternalSkipUnparseableDdl((boolean) value); return true;
            case "schemaHistoryInternalStoreOnlyCapturedDatabasesDdl": getOrCreateConfiguration((DebeziumDb2Component) component).setSchemaHistoryInternalStoreOnlyCapturedDatabasesDdl((boolean) value); return true;
            case "schemaHistoryInternalStoreOnlyCapturedTablesDdl": getOrCreateConfiguration((DebeziumDb2Component) component).setSchemaHistoryInternalStoreOnlyCapturedTablesDdl((boolean) value); return true;
            case "schemaNameAdjustmentMode": getOrCreateConfiguration((DebeziumDb2Component) component).setSchemaNameAdjustmentMode((java.lang.String) value); return true;
            case "signalDataCollection": getOrCreateConfiguration((DebeziumDb2Component) component).setSignalDataCollection((java.lang.String) value); return true;
            case "signalEnabledChannels": getOrCreateConfiguration((DebeziumDb2Component) component).setSignalEnabledChannels((java.lang.String) value); return true;
            case "signalPollIntervalMs": getOrCreateConfiguration((DebeziumDb2Component) component).setSignalPollIntervalMs((long) value); return true;
            case "skippedOperations": getOrCreateConfiguration((DebeziumDb2Component) component).setSkippedOperations((java.lang.String) value); return true;
            case "snapshotDelayMs": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotDelayMs((long) value); return true;
            case "snapshotFetchSize": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotFetchSize((int) value); return true;
            case "snapshotIncludeCollectionList": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotIncludeCollectionList((java.lang.String) value); return true;
            case "snapshotLockTimeoutMs": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotLockTimeoutMs((long) value); return true;
            case "snapshotMode": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotMode((java.lang.String) value); return true;
            case "snapshotModeConfigurationBasedSnapshotData": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotModeConfigurationBasedSnapshotData((boolean) value); return true;
            case "snapshotModeConfigurationBasedSnapshotOnDataError": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotModeConfigurationBasedSnapshotOnDataError((boolean) value); return true;
            case "snapshotModeConfigurationBasedSnapshotOnSchemaError": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotModeConfigurationBasedSnapshotOnSchemaError((boolean) value); return true;
            case "snapshotModeConfigurationBasedSnapshotSchema": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotModeConfigurationBasedSnapshotSchema((boolean) value); return true;
            case "snapshotModeConfigurationBasedStartStream": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotModeConfigurationBasedStartStream((boolean) value); return true;
            case "snapshotModeCustomName": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotModeCustomName((java.lang.String) value); return true;
            case "snapshotSelectStatementOverrides": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotSelectStatementOverrides((java.lang.String) value); return true;
            case "snapshotTablesOrderByRowCount": getOrCreateConfiguration((DebeziumDb2Component) component).setSnapshotTablesOrderByRowCount((java.lang.String) value); return true;
            case "sourceinfoStructMaker": getOrCreateConfiguration((DebeziumDb2Component) component).setSourceinfoStructMaker((java.lang.String) value); return true;
            case "streamingDelayMs": getOrCreateConfiguration((DebeziumDb2Component) component).setStreamingDelayMs((long) value); return true;
            case "tableExcludeList": getOrCreateConfiguration((DebeziumDb2Component) component).setTableExcludeList((java.lang.String) value); return true;
            case "tableIgnoreBuiltin": getOrCreateConfiguration((DebeziumDb2Component) component).setTableIgnoreBuiltin((boolean) value); return true;
            case "tableIncludeList": getOrCreateConfiguration((DebeziumDb2Component) component).setTableIncludeList((java.lang.String) value); return true;
            case "timePrecisionMode": getOrCreateConfiguration((DebeziumDb2Component) component).setTimePrecisionMode((java.lang.String) value); return true;
            case "tombstonesOnDelete": getOrCreateConfiguration((DebeziumDb2Component) component).setTombstonesOnDelete((boolean) value); return true;
            case "topicNamingStrategy": getOrCreateConfiguration((DebeziumDb2Component) component).setTopicNamingStrategy((java.lang.String) value); return true;
            case "topicPrefix": getOrCreateConfiguration((DebeziumDb2Component) component).setTopicPrefix((java.lang.String) value); return true;
            case "transactionMetadataFactory": getOrCreateConfiguration((DebeziumDb2Component) component).setTransactionMetadataFactory((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}