/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport.tree;

import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.dbimport.SchemaContainer;
import org.apache.cayenne.modeler.editor.dbimport.tree.CatalogNode;
import org.apache.cayenne.modeler.editor.dbimport.tree.Node;
import org.apache.cayenne.modeler.editor.dbimport.tree.Status;

class SchemaNode
extends Node<CatalogNode> {
    SchemaNode(String name, CatalogNode parent) {
        super(name, parent);
    }

    @Override
    public Status getStatus(ReverseEngineering config) {
        if (this.getParent() != null) {
            Status parentStatus = ((CatalogNode)this.getParent()).getStatus(config);
            if (parentStatus != Status.INCLUDE) {
                return parentStatus;
            }
            Catalog parentCatalog = ((CatalogNode)this.getParent()).getCatalog(config);
            if (parentCatalog != null && this.includesSchema(parentCatalog) == Status.INCLUDE) {
                return Status.INCLUDE;
            }
        }
        return this.includesSchema(config);
    }

    Status includesSchema(SchemaContainer container) {
        if (container.getSchemas().isEmpty()) {
            return Status.INCLUDE;
        }
        if (this.getSchema(container) != null) {
            return Status.INCLUDE;
        }
        return Status.EXCLUDE_IMPLICIT;
    }

    Schema getSchema(SchemaContainer container) {
        for (Schema schema : container.getSchemas()) {
            if (!schema.getName().equals(this.getName())) continue;
            return schema;
        }
        return null;
    }
}

