/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.awt.Dimension;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.converters.DimensionConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DimensionConverterTest {
    private DimensionConverter converter;

    @BeforeEach
    public void before() {
        this.converter = new DimensionConverter();
    }

    @Test
    public void testConvertingDimension() {
        Dimension expected = new Dimension(1920, 1080);
        Dimension actual = (Dimension)this.converter.convert(Dimension.class, (Object)"1920x1080");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingSquare() {
        Dimension expected = new Dimension(512, 512);
        Dimension actual = (Dimension)this.converter.convert(Dimension.class, (Object)"512");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testInvalidDimensions() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Dimension.class, (Object)"512n512"));
    }

    @Test
    public void testInvalidNumberFormatException() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Dimension.class, (Object)"3000000000x100"));
    }

    @Test
    public void testNegativeDimension() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Dimension.class, (Object)"-512x512"));
    }
}

