/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.TestFieldProblemAbstract;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFieldProblem3<T extends RealFieldElement<T>>
extends TestFieldProblemAbstract<T> {
    T e;

    public TestFieldProblem3(Field<T> field, T e) {
        super(field);
        this.e = e;
        RealFieldElement[] y0 = (RealFieldElement[])MathArrays.buildArray(field, (int)4);
        y0[0] = (RealFieldElement)((RealFieldElement)e.subtract(1.0)).negate();
        y0[1] = (RealFieldElement)field.getZero();
        y0[2] = (RealFieldElement)field.getZero();
        y0[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.add(1.0)).divide((Object)y0[0])).sqrt();
        this.setInitialConditions((RealFieldElement)this.convert(0.0), y0);
        this.setFinalConditions(this.convert(20.0));
        this.setErrorScale(this.convert(new double[]{1.0, 1.0, 1.0, 1.0}));
    }

    public TestFieldProblem3(Field<T> field) {
        this(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.1));
    }

    @Override
    public T[] doComputeDerivatives(T t, T[] y) {
        RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getDimension());
        RealFieldElement r2 = (RealFieldElement)((RealFieldElement)y[0].multiply(y[0])).add(y[1].multiply(y[1]));
        RealFieldElement invR3 = (RealFieldElement)((RealFieldElement)r2.multiply(r2.sqrt())).reciprocal();
        yDot[0] = y[2];
        yDot[1] = y[3];
        yDot[2] = (RealFieldElement)((RealFieldElement)invR3.negate()).multiply(y[0]);
        yDot[3] = (RealFieldElement)((RealFieldElement)invR3.negate()).multiply(y[1]);
        return yDot;
    }

    @Override
    public T[] computeTheoreticalState(T t) {
        RealFieldElement[] y = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getDimension());
        Object E = t;
        Object d = this.convert(0.0);
        Object corr = this.convert(999.0);
        for (int i = 0; i < 50 && ((RealFieldElement)corr.abs()).getReal() > 1.0E-12; ++i) {
            RealFieldElement f2 = (RealFieldElement)this.e.multiply(E.sin());
            RealFieldElement f0 = (RealFieldElement)d.subtract((Object)f2);
            RealFieldElement f1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply(E.cos())).subtract(1.0)).negate();
            RealFieldElement f12 = (RealFieldElement)f1.add((Object)f1);
            corr = (RealFieldElement)((RealFieldElement)f0.multiply((Object)f12)).divide(((RealFieldElement)f1.multiply((Object)f12)).subtract(f0.multiply((Object)f2)));
            d = (RealFieldElement)d.subtract(corr);
            E = (RealFieldElement)t.add(d);
        }
        RealFieldElement cosE = (RealFieldElement)E.cos();
        RealFieldElement sinE = (RealFieldElement)E.sin();
        y[0] = (RealFieldElement)cosE.subtract(this.e);
        y[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).subtract(1.0)).negate()).sqrt()).multiply((Object)sinE);
        y[2] = (RealFieldElement)sinE.divide(((RealFieldElement)this.e.multiply((Object)cosE)).subtract(1.0));
        y[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).subtract(1.0)).negate()).sqrt()).multiply((Object)cosE)).divide(((RealFieldElement)((RealFieldElement)this.e.multiply((Object)cosE)).subtract(1.0)).negate());
        return y;
    }
}

