/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.util.DefaultTransformer;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.NumberTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListUnivariateImpl
extends DescriptiveStatistics
implements Serializable {
    private static final long serialVersionUID = -8837442489133392138L;
    protected List<Object> list;
    protected NumberTransformer transformer;

    public ListUnivariateImpl() {
        this(new ArrayList<Object>());
    }

    public ListUnivariateImpl(List<Object> list) {
        this(list, (NumberTransformer)new DefaultTransformer());
    }

    public ListUnivariateImpl(List<Object> list, NumberTransformer transformer) {
        this.list = list;
        this.transformer = transformer;
    }

    public double[] getValues() {
        int length = this.list.size();
        int wSize = this.getWindowSize();
        if (wSize != -1 && wSize < this.list.size()) {
            length = this.list.size() - FastMath.max((int)0, (int)(this.list.size() - wSize));
        }
        double[] copiedArray = new double[length];
        for (int i = 0; i < copiedArray.length; ++i) {
            copiedArray[i] = this.getElement(i);
        }
        return copiedArray;
    }

    public double getElement(int index) {
        double value = Double.NaN;
        int calcIndex = index;
        int wSize = this.getWindowSize();
        if (wSize != -1 && wSize < this.list.size()) {
            calcIndex = this.list.size() - wSize + index;
        }
        try {
            value = this.transformer.transform(this.list.get(calcIndex));
        }
        catch (MathIllegalArgumentException e) {
            e.printStackTrace();
        }
        return value;
    }

    public long getN() {
        int n = 0;
        int wSize = this.getWindowSize();
        n = wSize != -1 ? (this.list.size() > wSize ? wSize : this.list.size()) : this.list.size();
        return n;
    }

    public void addValue(double v) {
        this.list.add(v);
    }

    public void addObject(Object o) {
        this.list.add(o);
    }

    public void clear() {
        this.list.clear();
    }

    public double apply(UnivariateStatistic stat) {
        double[] v = this.getValues();
        if (v != null) {
            return stat.evaluate(v, 0, v.length);
        }
        return Double.NaN;
    }

    public NumberTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(NumberTransformer transformer) {
        this.transformer = transformer;
    }

    public void setWindowSize(int windowSize) {
        super.setWindowSize(windowSize);
        int extra = this.list.size() - windowSize;
        for (int i = 0; i < extra; ++i) {
            this.list.remove(0);
        }
    }
}

