/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.NoSuchElementException;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.MultidimensionalCounter;
import org.junit.Assert;
import org.junit.Test;

public class MultidimensionalCounterTest {
    @Test
    public void testPreconditions() {
        MultidimensionalCounter c;
        try {
            c = new MultidimensionalCounter(new int[]{0, 1});
            Assert.fail((String)"NotStrictlyPositiveException expected");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        try {
            c = new MultidimensionalCounter(new int[]{2, 0});
            Assert.fail((String)"NotStrictlyPositiveException expected");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        try {
            c = new MultidimensionalCounter(new int[]{-1, 1});
            Assert.fail((String)"NotStrictlyPositiveException expected");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        c = new MultidimensionalCounter(new int[]{2, 3});
        try {
            c.getCount(new int[]{1, 1, 1});
            Assert.fail((String)"DimensionMismatchException expected");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            c.getCount(new int[]{3, 1});
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            c.getCount(new int[]{0, -1});
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            c.getCounts(-1);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            c.getCounts(6);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testIteratorPreconditions() {
        MultidimensionalCounter.Iterator iter = new MultidimensionalCounter(new int[]{2, 3}).iterator();
        try {
            iter.getCount(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iter.getCount(2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testIterator() {
        int dim1 = 3;
        int dim2 = 4;
        MultidimensionalCounter.Iterator iter = new MultidimensionalCounter(new int[]{3, 4}).iterator();
        int max = 12;
        for (int i = 0; i < 12; ++i) {
            Assert.assertTrue((boolean)iter.hasNext());
            iter.next();
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void testIteratorNoMoreElements() {
        MultidimensionalCounter.Iterator iter = new MultidimensionalCounter(new int[]{4, 2}).iterator();
        while (iter.hasNext()) {
            iter.next();
        }
        iter.next();
    }

    @Test
    public void testMulti2UniConversion() {
        MultidimensionalCounter c = new MultidimensionalCounter(new int[]{2, 4, 5});
        Assert.assertEquals((long)c.getCount(new int[]{1, 2, 3}), (long)33L);
    }

    @Test
    public void testAccessors() {
        int[] originalSize = new int[]{2, 6, 5};
        MultidimensionalCounter c = new MultidimensionalCounter(originalSize);
        int nDim = c.getDimension();
        Assert.assertEquals((long)nDim, (long)originalSize.length);
        int[] size = c.getSizes();
        for (int i = 0; i < nDim; ++i) {
            Assert.assertEquals((long)originalSize[i], (long)size[i]);
        }
    }

    @Test
    public void testIterationConsistency() {
        MultidimensionalCounter c = new MultidimensionalCounter(new int[]{2, 3, 4});
        int[][] expected = new int[][]{{0, 0, 0}, {0, 0, 1}, {0, 0, 2}, {0, 0, 3}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {0, 2, 0}, {0, 2, 1}, {0, 2, 2}, {0, 2, 3}, {1, 0, 0}, {1, 0, 1}, {1, 0, 2}, {1, 0, 3}, {1, 1, 0}, {1, 1, 1}, {1, 1, 2}, {1, 1, 3}, {1, 2, 0}, {1, 2, 1}, {1, 2, 2}, {1, 2, 3}};
        int totalSize = c.getSize();
        Assert.assertEquals((long)expected.length, (long)totalSize);
        int nDim = c.getDimension();
        MultidimensionalCounter.Iterator iter = c.iterator();
        for (int i = 0; i < totalSize; ++i) {
            if (!iter.hasNext()) {
                Assert.fail((String)"Too short");
            }
            int uniDimIndex = iter.next();
            Assert.assertEquals((String)("Wrong iteration at " + i), (long)i, (long)uniDimIndex);
            for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
                Assert.assertEquals((String)("Wrong multidimensional index for [" + i + "][" + dimIndex + "]"), (long)expected[i][dimIndex], (long)iter.getCount(dimIndex));
            }
            Assert.assertEquals((String)("Wrong unidimensional index for [" + i + "]"), (long)c.getCount(expected[i]), (long)uniDimIndex);
            int[] indices = c.getCounts(uniDimIndex);
            for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
                Assert.assertEquals((String)("Wrong multidimensional index for [" + i + "][" + dimIndex + "]"), (long)expected[i][dimIndex], (long)indices[dimIndex]);
            }
        }
        if (iter.hasNext()) {
            Assert.fail((String)"Too long");
        }
    }
}

