/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.io.Util;

public class PrintCommandListener
implements ProtocolCommandListener {
    private static final String DIRECTION_MARKER_RECEIVE = "< ";
    private static final String DIRECTION_MARKER_SEND = "> ";
    private static final String HIDDEN_MARKER = " *******";
    private static final String CMD_LOGIN = "LOGIN";
    private static final String CMD_USER = "USER";
    private static final String CMD_PASS = "PASS";
    private final PrintWriter writer;
    private final boolean noLogin;
    private final char eolMarker;
    private final boolean showDirection;

    public PrintCommandListener(PrintStream printStream) {
        this(Util.newPrintWriter(printStream));
    }

    public PrintCommandListener(PrintStream printStream, boolean suppressLogin) {
        this(Util.newPrintWriter(printStream), suppressLogin);
    }

    public PrintCommandListener(PrintStream printStream, boolean suppressLogin, char eolMarker) {
        this(Util.newPrintWriter(printStream), suppressLogin, eolMarker);
    }

    public PrintCommandListener(PrintStream printStream, boolean suppressLogin, char eolMarker, boolean showDirection) {
        this(Util.newPrintWriter(printStream), suppressLogin, eolMarker, showDirection);
    }

    public PrintCommandListener(PrintWriter writer) {
        this(writer, false);
    }

    public PrintCommandListener(PrintWriter writer, boolean suppressLogin) {
        this(writer, suppressLogin, '\u0000');
    }

    public PrintCommandListener(PrintWriter writer, boolean suppressLogin, char eolMarker) {
        this(writer, suppressLogin, eolMarker, false);
    }

    public PrintCommandListener(PrintWriter writer, boolean suppressLogin, char eolMarker, boolean showDirection) {
        this.writer = Objects.requireNonNull(writer, "writer");
        this.noLogin = suppressLogin;
        this.eolMarker = eolMarker;
        this.showDirection = showDirection;
    }

    private String getCommand(ProtocolCommandEvent event) {
        return Objects.toString(event.getCommand()).toUpperCase(Locale.ROOT);
    }

    private String getMessage(ProtocolCommandEvent event) {
        return Objects.toString(event.getMessage());
    }

    private String getPrintableString(String msg) {
        if (this.eolMarker == '\u0000') {
            return msg;
        }
        int pos = msg.indexOf("\r\n");
        if (pos > 0) {
            StringBuilder sb = new StringBuilder(msg + 1);
            sb.append(msg.substring(0, pos));
            sb.append(this.eolMarker);
            sb.append(msg.substring(pos));
            return sb.toString();
        }
        return msg;
    }

    @Override
    public void protocolCommandSent(ProtocolCommandEvent event) {
        if (this.showDirection) {
            this.writer.print(DIRECTION_MARKER_SEND);
        }
        if (this.noLogin) {
            String cmd = this.getCommand(event);
            if (CMD_PASS.equals(cmd) || CMD_USER.equals(cmd)) {
                this.writer.print(cmd);
                this.writer.println(HIDDEN_MARKER);
            } else if (CMD_LOGIN.equals(cmd)) {
                String msg = this.getMessage(event);
                msg = msg.substring(0, msg.indexOf(CMD_LOGIN) + CMD_LOGIN.length());
                this.writer.print(msg);
                this.writer.println(HIDDEN_MARKER);
            } else {
                this.writer.print(this.getPrintableString(this.getMessage(event)));
            }
        } else {
            this.writer.print(this.getPrintableString(this.getMessage(event)));
        }
        this.writer.flush();
    }

    @Override
    public void protocolReplyReceived(ProtocolCommandEvent event) {
        if (this.showDirection) {
            this.writer.print(DIRECTION_MARKER_RECEIVE);
        }
        String message = this.getMessage(event);
        char last = message.charAt(message.length() - 1);
        this.writer.print(message);
        if (last != '\r' && last != '\n') {
            this.writer.println();
        }
        this.writer.flush();
    }
}

