/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.ftp;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.tftp.TFTPClient;
import org.apache.commons.net.tftp.TFTPPacket;

public final class TFTPExample {
    static final String USAGE = "Usage: TFTPExample [options] hostname localfile remotefile\n\nhostname   - The name of the remote host [:port]\nlocalfile  - The name of the local file to send or the name to use for\n\tthe received file\nremotefile - The name of the remote file to receive or the name for\n\tthe remote server to use to name the local file being sent.\n\noptions: (The default is to assume -r -b)\n\t-t timeout in seconds (default 60s)\n\t-s Send a local file\n\t-r Receive a remote file\n\t-a Use ASCII transfer mode\n\t-b Use binary transfer mode\n\t-v Verbose (trace packets)\n";

    private static boolean close(TFTPClient tftp, Closeable output) {
        boolean closed;
        tftp.close();
        try {
            IOUtils.close((Closeable)output);
            closed = true;
        }
        catch (IOException e) {
            closed = false;
            System.err.println("Error: error closing file.");
            System.err.println(e.getMessage());
        }
        return closed;
    }

    public static void main(String[] args) throws IOException {
        String arg;
        int argc;
        boolean receiveFile = true;
        int transferMode = 1;
        int timeout = 60000;
        boolean verbose = false;
        block16: for (argc = 0; argc < args.length && (arg = args[argc]).startsWith("-"); ++argc) {
            switch (arg) {
                case "-r": {
                    receiveFile = true;
                    continue block16;
                }
                case "-s": {
                    receiveFile = false;
                    continue block16;
                }
                case "-a": {
                    transferMode = 0;
                    continue block16;
                }
                case "-b": {
                    transferMode = 1;
                    continue block16;
                }
                case "-t": {
                    timeout = 1000 * Integer.parseInt(args[++argc]);
                    continue block16;
                }
                case "-v": {
                    verbose = true;
                    continue block16;
                }
                default: {
                    System.err.println("\u0007Error: unrecognized option.");
                    System.err.print(USAGE);
                    System.exit(1);
                }
            }
        }
        if (args.length - argc != 3) {
            System.err.println("\u0007Error: invalid number of arguments.");
            System.err.print(USAGE);
            System.exit(1);
        }
        String hostname = args[argc];
        String localFilename = args[argc + 1];
        String remoteFilename = args[argc + 2];
        TFTPClient tftp = verbose ? new TFTPClient(){

            @Override
            protected void trace(String direction, TFTPPacket packet) {
                System.out.println(direction + " " + packet);
            }
        } : new TFTPClient();
        tftp.setDefaultTimeout(Duration.ofSeconds(timeout));
        boolean closed = false;
        closed = receiveFile ? TFTPExample.receive(transferMode, hostname, localFilename, remoteFilename, tftp) : TFTPExample.send(transferMode, hostname, localFilename, remoteFilename, tftp);
        System.out.println("Recd: " + tftp.getTotalBytesReceived() + " Sent: " + tftp.getTotalBytesSent());
        if (!closed) {
            System.out.println("Failed");
            System.exit(1);
        }
        System.out.println("OK");
    }

    private static void open(TFTPClient tftp) throws IOException {
        try {
            tftp.open();
        }
        catch (SocketException e) {
            throw new IOException("Error: could not open local UDP socket.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean receive(int transferMode, String hostname, String localFilename, String remoteFilename, TFTPClient tftp) throws IOException {
        boolean closed;
        FileOutputStream output;
        File file = new File(localFilename);
        if (file.exists()) {
            System.err.println("Error: " + localFilename + " already exists.");
            return false;
        }
        try {
            output = new FileOutputStream(file);
        }
        catch (IOException e) {
            tftp.close();
            throw new IOException("Error: could not open local file for writing.", e);
        }
        TFTPExample.open(tftp);
        try {
            String[] parts = hostname.split(":");
            if (parts.length == 2) {
                tftp.receiveFile(remoteFilename, transferMode, (OutputStream)output, parts[0], Integer.parseInt(parts[1]));
            } else {
                tftp.receiveFile(remoteFilename, transferMode, (OutputStream)output, hostname);
            }
        }
        catch (UnknownHostException e) {
            System.err.println("Error: could not resolve hostname.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Error: I/O exception occurred while receiving file.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        finally {
            closed = TFTPExample.close(tftp, output);
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean send(int transferMode, String hostname, String localFilename, String remoteFilename, TFTPClient tftp) throws IOException {
        boolean closed;
        FileInputStream input;
        try {
            input = new FileInputStream(localFilename);
        }
        catch (IOException e) {
            tftp.close();
            throw new IOException("Error: could not open local file for reading.", e);
        }
        TFTPExample.open(tftp);
        try {
            String[] parts = hostname.split(":");
            if (parts.length == 2) {
                tftp.sendFile(remoteFilename, transferMode, (InputStream)input, parts[0], Integer.parseInt(parts[1]));
            } else {
                tftp.sendFile(remoteFilename, transferMode, (InputStream)input, hostname);
            }
        }
        catch (UnknownHostException e) {
            System.err.println("Error: could not resolve hostname.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Error: I/O exception occurred while sending file.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        finally {
            closed = TFTPExample.close(tftp, input);
        }
        return closed;
    }
}

