/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.ref.SoftReference;
import org.apache.commons.pool2.impl.PooledSoftReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPooledSoftReference {
    PooledSoftReference<String> ref;
    private static final String REFERENT = "test";
    private static final String REFERENT2 = "test2";

    @Before
    public void setUp() {
        SoftReference<String> softRef = new SoftReference<String>(REFERENT);
        this.ref = new PooledSoftReference(softRef);
    }

    @Test
    public void testPooledSoftReference() {
        Assert.assertEquals((Object)REFERENT, (Object)this.ref.getObject());
        SoftReference softRef = this.ref.getReference();
        Assert.assertEquals((Object)REFERENT, softRef.get());
        softRef.clear();
        softRef = new SoftReference(REFERENT2);
        this.ref.setReference(softRef);
        Assert.assertEquals((Object)REFERENT2, (Object)this.ref.getObject());
        softRef = this.ref.getReference();
        Assert.assertEquals((Object)REFERENT2, softRef.get());
        softRef.clear();
    }

    @Test
    public void testToString() {
        String expected = "Referenced Object: test, State: IDLE";
        Assert.assertEquals((Object)"Referenced Object: test, State: IDLE", (Object)this.ref.toString());
    }
}

