/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import java.util.stream.IntStream;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.statistics.distribution.DistributionException;

public interface DiscreteDistribution {
    public double probability(int var1);

    default public double probability(int x0, int x1) {
        if (x0 > x1) {
            throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
        }
        if ((long)x0 + 1L >= (long)x1) {
            return x0 == x1 ? 0.0 : this.probability(x1);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    default public double logProbability(int x) {
        return Math.log(this.probability(x));
    }

    public double cumulativeProbability(int var1);

    default public double survivalProbability(int x) {
        return 1.0 - this.cumulativeProbability(x);
    }

    public int inverseCumulativeProbability(double var1);

    default public int inverseSurvivalProbability(double p) {
        return this.inverseCumulativeProbability(1.0 - p);
    }

    public double getMean();

    public double getVariance();

    public int getSupportLowerBound();

    public int getSupportUpperBound();

    public Sampler createSampler(UniformRandomProvider var1);

    @FunctionalInterface
    public static interface Sampler {
        public int sample();

        default public IntStream samples() {
            return IntStream.generate(this::sample).sequential();
        }

        default public IntStream samples(long streamSize) {
            return this.samples().limit(streamSize);
        }
    }
}

