/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.DeprecationReporter;
import org.apache.rat.commandline.Arg;
import org.apache.rat.utils.CasedString;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class BaseAntTask
extends Task {
    private static final Map<String, String> xlateName = new HashMap<String, String>();
    private static final List<String> unsupportedArgs = new ArrayList<String>();
    private static final Map<String, String> deprecatedArgs = new HashMap<String, String>();
    protected final Map<String, List<String>> args = new HashMap<String, List<String>>();

    public static String createName(String longOpt) {
        String name = StringUtils.defaultIfEmpty(xlateName.get(longOpt), longOpt).toLowerCase(Locale.ROOT);
        return new CasedString(CasedString.StringCase.KEBAB, name).toCase(CasedString.StringCase.CAMEL);
    }

    public static List<String> unsupportedArgs() {
        return Collections.unmodifiableList(unsupportedArgs);
    }

    private static void setDeprecationReporter() {
        DeprecationReporter.setLogReporter(opt -> {
            String msg = deprecatedArgs.get(BaseAntTask.argsKey(opt));
            if (msg == null) {
                DeprecationReporter.getDefault().accept((Option)opt);
            } else {
                DefaultLog.getInstance().warn(msg);
            }
        });
    }

    private static String argsKey(Option opt) {
        return StringUtils.defaultIfEmpty(opt.getLongOpt(), opt.getKey());
    }

    protected List<String> args() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this.args.entrySet()) {
            result.add("--" + entry.getKey());
            result.addAll(entry.getValue().stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return result;
    }

    private boolean validateSet(String key) {
        Arg arg = Arg.findArg(key);
        if (arg != null) {
            Option opt = arg.find(key);
            Option main = arg.option();
            if (opt.isDeprecated()) {
                this.args.remove(BaseAntTask.argsKey(main));
                return true;
            }
            for (Option o : arg.group().getOptions()) {
                if (o.equals(main) || !this.args.containsKey(BaseAntTask.argsKey(o))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setArg(String key, String value) {
        if ((value == null || StringUtils.isNotBlank(value)) && this.validateSet(key)) {
            ArrayList<String> values = new ArrayList<String>();
            if (DefaultLog.getInstance().isEnabled(Log.Level.DEBUG)) {
                DefaultLog.getInstance().debug(String.format("Setting %s to '%s'", key, value));
            }
            values.add(value);
            this.args.put(key, values);
        }
    }

    public List<String> getArg(String key) {
        return this.args.get(key);
    }

    protected void addArg(String key, String[] value) {
        List newValues = Arrays.stream(value).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (!newValues.isEmpty() && this.validateSet(key)) {
            if (DefaultLog.getInstance().isEnabled(Log.Level.DEBUG)) {
                DefaultLog.getInstance().debug(String.format("Adding [%s] to %s", String.join((CharSequence)", ", Arrays.asList(value)), key));
            }
            List values = this.args.computeIfAbsent(key, k -> new ArrayList());
            values.addAll(newValues);
        }
    }

    protected void addArg(String key, String value) {
        if (StringUtils.isNotBlank(value) && this.validateSet(key)) {
            List<String> values = this.args.get(key);
            if (DefaultLog.getInstance().isEnabled(Log.Level.DEBUG)) {
                DefaultLog.getInstance().debug(String.format("Adding [%s] to %s", String.join((CharSequence)", ", Arrays.asList(value)), key));
            }
            if (values == null) {
                values = new ArrayList<String>();
                this.args.put(key, values);
            }
            values.add(value);
        }
    }

    protected void removeArg(String key) {
        this.args.remove(key);
    }

    protected BaseAntTask() {
        BaseAntTask.setDeprecationReporter();
    }

    public void setCopyright(String copyright) {
        this.setArg("copyright", copyright);
    }

    public void setEditCopyright(String editCopyright) {
        this.setArg("edit-copyright", editCopyright);
    }

    public void setForce(boolean force) {
        if (force) {
            this.setArg("force", null);
        } else {
            this.removeArg("force");
        }
    }

    public void setEditOverwrite(boolean editOverwrite) {
        if (editOverwrite) {
            this.setArg("edit-overwrite", null);
        } else {
            this.removeArg("edit-overwrite");
        }
    }

    public void setAddLicense(boolean addLicense) {
        if (addLicense) {
            this.setArg("addLicense", null);
        } else {
            this.removeArg("addLicense");
        }
    }

    public void setEditLicense(boolean editLicense) {
        if (editLicense) {
            this.setArg("edit-license", null);
        } else {
            this.removeArg("edit-license");
        }
    }

    public void setConfigurationNoDefaults(boolean configurationNoDefaults) {
        if (configurationNoDefaults) {
            this.setArg("configuration-no-defaults", null);
        } else {
            this.removeArg("configuration-no-defaults");
        }
    }

    public void setNoDefaultLicenses(boolean noDefaultLicenses) {
        if (noDefaultLicenses) {
            this.setArg("no-default-licenses", null);
        } else {
            this.removeArg("no-default-licenses");
        }
    }

    public void setExcludeFile(String excludeFile) {
        this.setArg("exclude-file", excludeFile);
    }

    public void setInputExcludeSize(String inputExcludeSize) {
        this.setArg("input-exclude-size", inputExcludeSize);
    }

    public void setIncludesFile(String includesFile) {
        this.setArg("includes-file", includesFile);
    }

    public void setScanHiddenDirectories(boolean scanHiddenDirectories) {
        if (scanHiddenDirectories) {
            this.setArg("scan-hidden-directories", null);
        } else {
            this.removeArg("scan-hidden-directories");
        }
    }

    public void setOutputStyle(String outputStyle) {
        this.setArg("output-style", outputStyle);
    }

    public void setStylesheet(String stylesheet) {
        this.setArg("stylesheet", stylesheet);
    }

    public void setXml(boolean xml) {
        if (xml) {
            this.setArg("xml", null);
        } else {
            this.removeArg("xml");
        }
    }

    public void setOutputLicenses(String outputLicenses) {
        this.setArg("output-licenses", outputLicenses);
    }

    public void setListLicenses(String listLicenses) {
        this.setArg("list-licenses", listLicenses);
    }

    public void setOutputFamilies(String outputFamilies) {
        this.setArg("output-families", outputFamilies);
    }

    public void setListFamilies(String listFamilies) {
        this.setArg("list-families", listFamilies);
    }

    public void setDryRun(boolean dryRun) {
        if (dryRun) {
            this.setArg("dry-run", null);
        } else {
            this.removeArg("dry-run");
        }
    }

    public void setOut(String out) {
        this.setArg("out", out);
    }

    public void setOutputFile(String outputFile) {
        this.setArg("output-file", outputFile);
    }

    public void setOutputArchive(String outputArchive) {
        this.setArg("output-archive", outputArchive);
    }

    public void setOutputStandard(String outputStandard) {
        this.setArg("output-standard", outputStandard);
    }

    public void setHelpLicenses(boolean helpLicenses) {
        if (helpLicenses) {
            this.setArg("help-licenses", null);
        } else {
            this.removeArg("help-licenses");
        }
    }

    public Config createConfig() {
        return new Config();
    }

    public Licenses createLicenses() {
        return new Licenses();
    }

    public LicensesApproved createLicensesApproved() {
        return new LicensesApproved();
    }

    public LicenseFamiliesApproved createLicenseFamiliesApproved() {
        return new LicenseFamiliesApproved();
    }

    public LicensesDenied createLicensesDenied() {
        return new LicensesDenied();
    }

    public LicenseFamiliesDenied createLicenseFamiliesDenied() {
        return new LicenseFamiliesDenied();
    }

    public CounterMax createCounterMax() {
        return new CounterMax();
    }

    public CounterMin createCounterMin() {
        return new CounterMin();
    }

    public Exclude createExclude() {
        return new Exclude();
    }

    public InputExclude createInputExclude() {
        return new InputExclude();
    }

    public InputInclude createInputInclude() {
        return new InputInclude();
    }

    public Include createInclude() {
        return new Include();
    }

    public InputExcludeParsedScm createInputExcludeParsedScm() {
        return new InputExcludeParsedScm();
    }

    static {
        xlateName.put("addLicense", "add-license");
        unsupportedArgs.add("a");
        unsupportedArgs.add("input-include-file");
        unsupportedArgs.add("input-source");
        unsupportedArgs.add("input-exclude-file");
        unsupportedArgs.add("log-level");
        unsupportedArgs.add("license-families-approved-file");
        unsupportedArgs.add("input-exclude-std");
        unsupportedArgs.add("help");
        unsupportedArgs.add("dir");
        unsupportedArgs.add("license-families-denied-file");
        unsupportedArgs.add("licenses-denied-file");
        unsupportedArgs.add("licenses-approved-file");
        unsupportedArgs.add("input-include-std");
        deprecatedArgs.put("copyright", "Use of deprecated option 'copyright'. Deprecated for removal since 0.17: Use editCopyright attribute instead.");
        deprecatedArgs.put("force", "Use of deprecated option 'force'. Deprecated for removal since 0.17: Use editOverwrite attribute instead.");
        deprecatedArgs.put("addLicense", "Use of deprecated option 'addLicense'. Deprecated for removal since 0.17: Use editLicense attribute instead.");
        deprecatedArgs.put("licenses", "Use of deprecated option 'licenses'. Deprecated for removal since 0.17: Use <config> instead.");
        deprecatedArgs.put("no-default-licenses", "Use of deprecated option 'noDefaultLicenses'. Deprecated for removal since 0.17: Use configurationNoDefaults attribute instead.");
        deprecatedArgs.put("exclude", "Use of deprecated option 'exclude'. Deprecated for removal since 0.17: Use <inputExclude> instead.");
        deprecatedArgs.put("exclude-file", "Use of deprecated option 'excludeFile'. Deprecated for removal since 0.17: Use inputExcludeFile attribute instead.");
        deprecatedArgs.put("include", "Use of deprecated option 'include'. Deprecated for removal since 0.17: Use <inputInclude> instead.");
        deprecatedArgs.put("includes-file", "Use of deprecated option 'includesFile'. Deprecated for removal since 0.17: Use inputIncludeFile attribute instead.");
        deprecatedArgs.put("scan-hidden-directories", "Use of deprecated option 'scanHiddenDirectories'. Deprecated for removal since 0.17: Use <inputIncludeStd> with 'HIDDEN_DIR' argument instead.");
        deprecatedArgs.put("stylesheet", "Use of deprecated option 'stylesheet'. Deprecated for removal since 0.17: Use outputStyle attribute instead.");
        deprecatedArgs.put("xml", "Use of deprecated option 'xml'. Deprecated for removal since 0.17: Use outputStyle attribute with the 'xml' argument instead.");
        deprecatedArgs.put("list-licenses", "Use of deprecated option 'listLicenses'. Deprecated for removal since 0.17: Use outputLicenses attribute instead.");
        deprecatedArgs.put("list-families", "Use of deprecated option 'listFamilies'. Deprecated for removal since 0.17: Use outputFamilies attribute instead.");
        deprecatedArgs.put("out", "Use of deprecated option 'out'. Deprecated for removal since 0.17: Use outputFile attribute instead.");
    }

    public class Config {
        Config() {
        }

        public void addConfiguredFileset(FileSet fileSet) {
            for (Resource resource : fileSet) {
                if (!resource.isFilesystemOnly()) continue;
                BaseAntTask.this.addArg("config", ((FileResource)resource).getFile().getAbsolutePath());
            }
        }
    }

    public class Licenses {
        Licenses() {
        }

        public void addConfiguredFileset(FileSet fileSet) {
            for (Resource resource : fileSet) {
                if (!resource.isFilesystemOnly()) continue;
                BaseAntTask.this.addArg("licenses", ((FileResource)resource).getFile().getAbsolutePath());
            }
        }
    }

    public class LicensesApproved {
        LicensesApproved() {
        }

        public void addConfiguredLst(Lst licenseID) {
            BaseAntTask.this.addArg("licenses-approved", licenseID.value);
        }

        public void addConfiguredFileset(FileSet fileSet) {
            for (Resource resource : fileSet) {
                if (!resource.isFilesystemOnly()) continue;
                BaseAntTask.this.addArg("licenses-approved-file", ((FileResource)resource).getFile().getAbsolutePath());
            }
        }
    }

    public class LicenseFamiliesApproved {
        LicenseFamiliesApproved() {
        }

        public void addConfiguredFileset(FileSet fileSet) {
            for (Resource resource : fileSet) {
                if (!resource.isFilesystemOnly()) continue;
                BaseAntTask.this.addArg("license-families-approved-file", ((FileResource)resource).getFile().getAbsolutePath());
            }
        }

        public void addConfiguredLst(Lst familyID) {
            BaseAntTask.this.addArg("license-families-approved", familyID.value);
        }
    }

    public class LicensesDenied {
        LicensesDenied() {
        }

        public void addConfiguredFileset(FileSet fileSet) {
            for (Resource resource : fileSet) {
                if (!resource.isFilesystemOnly()) continue;
                BaseAntTask.this.addArg("licenses-denied-file", ((FileResource)resource).getFile().getAbsolutePath());
            }
        }

        public void addConfiguredLst(Lst licenseID) {
            BaseAntTask.this.addArg("licenses-denied", licenseID.value);
        }
    }

    public class LicenseFamiliesDenied {
        LicenseFamiliesDenied() {
        }

        public void addConfiguredLst(Lst familyID) {
            BaseAntTask.this.addArg("license-families-denied", familyID.value);
        }

        public void addConfiguredFileset(FileSet fileSet) {
            for (Resource resource : fileSet) {
                if (!resource.isFilesystemOnly()) continue;
                BaseAntTask.this.addArg("license-families-denied-file", ((FileResource)resource).getFile().getAbsolutePath());
            }
        }
    }

    public class CounterMax {
        CounterMax() {
        }

        public void addConfiguredCntr(Cntr counterPattern) {
            BaseAntTask.this.addArg("counter-max", counterPattern.value);
        }
    }

    public class CounterMin {
        CounterMin() {
        }

        public void addConfiguredCntr(Cntr counterPattern) {
            BaseAntTask.this.addArg("counter-min", counterPattern.value);
        }
    }

    public class Exclude {
        Exclude() {
        }

        public void addConfiguredExpr(Expr expression) {
            BaseAntTask.this.addArg("exclude", expression.value);
        }
    }

    public class InputExclude {
        InputExclude() {
        }

        public void addConfiguredStd(Std standardCollection) {
            BaseAntTask.this.addArg("input-exclude-std", standardCollection.value);
        }

        public void addConfiguredExpr(Expr expression) {
            BaseAntTask.this.addArg("input-exclude", expression.value);
        }

        public void addConfiguredFileset(FileSet fileSet) {
            for (Resource resource : fileSet) {
                if (!resource.isFilesystemOnly()) continue;
                BaseAntTask.this.addArg("input-exclude-file", ((FileResource)resource).getFile().getAbsolutePath());
            }
        }
    }

    public class InputInclude {
        InputInclude() {
        }

        public void addConfiguredFileset(FileSet fileSet) {
            for (Resource resource : fileSet) {
                if (!resource.isFilesystemOnly()) continue;
                BaseAntTask.this.addArg("input-include-file", ((FileResource)resource).getFile().getAbsolutePath());
            }
        }

        public void addConfiguredExpr(Expr expression) {
            BaseAntTask.this.addArg("input-include", expression.value);
        }

        public void addConfiguredStd(Std standardCollection) {
            BaseAntTask.this.addArg("input-include-std", standardCollection.value);
        }
    }

    public class Include {
        Include() {
        }

        public void addConfiguredExpr(Expr expression) {
            BaseAntTask.this.addArg("include", expression.value);
        }
    }

    public class InputExcludeParsedScm {
        InputExcludeParsedScm() {
        }

        public void addConfiguredStd(Std standardCollection) {
            BaseAntTask.this.addArg("input-exclude-parsed-scm", standardCollection.value);
        }
    }

    public static class Lst
    extends TxtValue {
    }

    public static class Filename
    extends TxtValue {
    }

    public static class Cntr
    extends TxtValue {
    }

    public static class Expr
    extends TxtValue {
    }

    public static class Std
    extends TxtValue {
    }

    protected static class TxtValue {
        public String value;

        protected TxtValue() {
        }

        public void addText(String text) {
            this.value = text.trim();
        }
    }
}

