/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.IOException;
import java.sql.Date;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.sso.state.SPStateManager;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;

public class AbstractSSOSpHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSSOSpHandler.class);
    private SPStateManager stateProvider;
    private long stateTimeToLive = 120000L;
    private Crypto signatureCrypto;
    private String signaturePropertiesFile;
    private CallbackHandler callbackHandler;
    private String callbackHandlerClass;
    private String signatureUsername;
    private String idpServiceAddress;
    private String issuerId;
    private boolean supportUnsolicited;

    @PreDestroy
    public void close() {
        if (this.stateProvider != null) {
            try {
                this.stateProvider.close();
            }
            catch (IOException ex) {
                LOG.warning("State provider can not be closed: " + ex.getMessage());
            }
            this.stateProvider = null;
        }
    }

    public void setSignatureCrypto(Crypto crypto) {
        this.signatureCrypto = crypto;
    }

    public void setSignaturePropertiesFile(String signaturePropertiesFile) {
        this.signaturePropertiesFile = signaturePropertiesFile;
        LOG.fine("Setting signature properties: " + signaturePropertiesFile);
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        LOG.fine("Setting callbackHandler: " + String.valueOf(callbackHandler));
    }

    public void setCallbackHandlerClass(String callbackHandlerClass) {
        this.callbackHandlerClass = callbackHandlerClass;
        LOG.fine("Setting callbackHandlerClass: " + callbackHandlerClass);
    }

    protected String createCookie(String name, String value, String path, String domain) {
        String contextCookie = name + "=" + value;
        if (path != null) {
            contextCookie = contextCookie + ";Path=" + path;
        }
        if (domain != null) {
            contextCookie = contextCookie + ";Domain=" + domain;
        }
        if (this.stateTimeToLive > 0L) {
            Instant expires = Instant.ofEpochMilli(System.currentTimeMillis() + this.stateTimeToLive);
            String cookieExpires = HttpUtils.getHttpDateFormat().format(Date.from(expires.atZone(ZoneOffset.UTC).toInstant()));
            contextCookie = contextCookie + ";Expires=" + cookieExpires;
        }
        return contextCookie;
    }

    public void setStateProvider(SPStateManager stateProvider) {
        this.stateProvider = stateProvider;
    }

    public SPStateManager getStateProvider() {
        return this.stateProvider;
    }

    public void setStateTimeToLive(long stateTimeToLive) {
        this.stateTimeToLive = stateTimeToLive;
    }

    public long getStateTimeToLive() {
        return this.stateTimeToLive;
    }

    protected Crypto getSignatureCrypto() {
        if (this.signatureCrypto == null && this.signaturePropertiesFile != null) {
            Properties sigProperties = SecurityUtils.loadProperties((Object)this.signaturePropertiesFile);
            if (sigProperties == null) {
                LOG.warning("Cannot load signature properties using: " + this.signaturePropertiesFile);
                return null;
            }
            try {
                this.signatureCrypto = CryptoFactory.getInstance((Properties)sigProperties);
            }
            catch (WSSecurityException ex) {
                LOG.warning("Error in loading the signature Crypto object: " + ex.getMessage());
                return null;
            }
        }
        return this.signatureCrypto;
    }

    protected CallbackHandler getCallbackHandler() {
        if (this.callbackHandler == null && this.callbackHandlerClass != null) {
            try {
                this.callbackHandler = SecurityUtils.getCallbackHandler((Object)this.callbackHandlerClass);
                if (this.callbackHandler == null) {
                    LOG.warning("Cannot load CallbackHandler using: " + this.callbackHandlerClass);
                    return null;
                }
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Error in loading callback handler", ex);
                return null;
            }
        }
        return this.callbackHandler;
    }

    public void setSignatureUsername(String signatureUsername) {
        this.signatureUsername = signatureUsername;
        LOG.fine("Setting signatureUsername: " + signatureUsername);
    }

    public String getSignatureUsername() {
        return this.signatureUsername;
    }

    public void setIdpServiceAddress(String idpServiceAddress) {
        this.idpServiceAddress = idpServiceAddress;
    }

    public String getIdpServiceAddress() {
        return this.idpServiceAddress;
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }

    protected String getIssuerId(Message m) {
        if (this.issuerId == null) {
            return new UriInfoImpl(m).getBaseUri().toString();
        }
        return this.issuerId;
    }

    public boolean isSupportUnsolicited() {
        return this.supportUnsolicited;
    }

    public void setSupportUnsolicited(boolean supportUnsolicited) {
        this.supportUnsolicited = supportUnsolicited;
    }

    static {
        OpenSAMLUtil.initSamlEngine();
    }
}

