/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefnImplBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

public class IdlField
extends IdlDefnImplBase {
    protected static final Logger LOG = LogUtils.getL7dLogger(IdlField.class);
    private IdlType type;

    protected IdlField(IdlScopeBase parent, String name, IdlType idlType) {
        super(parent, name);
        this.type = idlType;
    }

    public static IdlField create(IdlScopeBase parent, String name, IdlType type) {
        return new IdlField(parent, name, type);
    }

    IdlType type() {
        return this.type;
    }

    @Override
    public void write(PrintWriter pw) {
        if (!this.type.isEmptyDef()) {
            pw.print(IdlField.indent() + this.type.fullName(this.definedIn().scopeName()) + " ");
            pw.print(this.localName());
            pw.println(";");
        } else {
            LOG.log(Level.WARNING, "Ignoring Field " + this.localName() + " with Empty Type.");
        }
    }

    @Override
    public boolean isEmptyDef() {
        return this.type.isEmptyDef();
    }

    @Override
    public IdlScopeBase getCircularScope(IdlScopeBase startScope, List<Object> doneDefn) {
        return this.type.getCircularScope(startScope, doneDefn);
    }
}

