/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.impl.cache.CacheRevalidatorBase;
import org.apache.hc.client5.http.schedule.SchedulingStrategy;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCacheRevalidator
extends CacheRevalidatorBase {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCacheRevalidator.class);

    public DefaultCacheRevalidator(CacheRevalidatorBase.ScheduledExecutor scheduledExecutor, SchedulingStrategy schedulingStrategy) {
        super(scheduledExecutor, schedulingStrategy);
    }

    public DefaultCacheRevalidator(ScheduledExecutorService scheduledThreadPoolExecutor, SchedulingStrategy schedulingStrategy) {
        this(DefaultCacheRevalidator.wrap(scheduledThreadPoolExecutor), schedulingStrategy);
    }

    public void revalidateCacheEntry(String cacheKey, RevalidationCall call) {
        this.scheduleRevalidation(cacheKey, () -> {
            try (ClassicHttpResponse httpResponse = call.execute();){
                if (httpResponse.getCode() < 500 && !this.isStale((HttpResponse)httpResponse)) {
                    this.jobSuccessful(cacheKey);
                } else {
                    this.jobFailed(cacheKey);
                }
            }
            catch (IOException ex) {
                this.jobFailed(cacheKey);
                LOG.debug("Asynchronous revalidation failed due to I/O error", (Throwable)ex);
            }
            catch (HttpException ex) {
                this.jobFailed(cacheKey);
                LOG.error("HTTP protocol exception during asynchronous revalidation", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                this.jobFailed(cacheKey);
                LOG.error("Unexpected runtime exception thrown during asynchronous revalidation", (Throwable)ex);
            }
        });
    }

    static interface RevalidationCall {
        public ClassicHttpResponse execute() throws IOException, HttpException;
    }
}

