/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import java.io.Serializable;
import org.apache.daffodil.io.processors.charset.BitsCharset;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetEncoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetNonByteSizeDecoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetNonByteSizeEncoder;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.MaybeInt;
import org.apache.daffodil.lib.util.MaybeInt$;
import scala.Char$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface BitsCharsetNonByteSize
extends BitsCharset {
    public static void $init$(BitsCharsetNonByteSize $this) {
        if ($this.decodeString().length() != 1 << $this.bitWidthOfACodeUnit()) {
            throw Assert$.MODULE$.usageError("BitsCharsetNonByteSize.this.decodeString.length().==(1.<<(BitsCharsetNonByteSize.this.bitWidthOfACodeUnit))");
        }
        if ($this.bitWidthOfACodeUnit() > 8 || $this.bitWidthOfACodeUnit() < 1) {
            throw Assert$.MODULE$.usageError("BitsCharsetNonByteSize.this.bitWidthOfACodeUnit.<=(8).&&(BitsCharsetNonByteSize.this.bitWidthOfACodeUnit.>=(1))");
        }
    }

    public String decodeString();

    public int replacementCharCode();

    public static float averageCharsPerByte$(BitsCharsetNonByteSize $this) {
        return $this.averageCharsPerByte();
    }

    default public float averageCharsPerByte() {
        return this.averageCharsPerBit() * 8.0f;
    }

    public static float averageCharsPerBit$(BitsCharsetNonByteSize $this) {
        return $this.averageCharsPerBit();
    }

    default public float averageCharsPerBit() {
        return 1.0f / (float)this.bitWidthOfACodeUnit();
    }

    public static float maxCharsPerByte$(BitsCharsetNonByteSize $this) {
        return $this.maxCharsPerByte();
    }

    default public float maxCharsPerByte() {
        return this.maxCharsPerBit() * 8.0f;
    }

    public static float maxCharsPerBit$(BitsCharsetNonByteSize $this) {
        return $this.maxCharsPerBit();
    }

    default public float maxCharsPerBit() {
        return 1.0f / (float)this.bitWidthOfACodeUnit();
    }

    public static float averageBytesPerChar$(BitsCharsetNonByteSize $this) {
        return $this.averageBytesPerChar();
    }

    default public float averageBytesPerChar() {
        return 1.0f / this.averageCharsPerByte();
    }

    public static float averageBitsPerChar$(BitsCharsetNonByteSize $this) {
        return $this.averageBitsPerChar();
    }

    default public float averageBitsPerChar() {
        return 1.0f / this.averageCharsPerBit();
    }

    public static float maxBytesPerChar$(BitsCharsetNonByteSize $this) {
        return $this.maxBytesPerChar();
    }

    default public float maxBytesPerChar() {
        return 1.0f / this.maxCharsPerByte();
    }

    public static float maxBitsPerChar$(BitsCharsetNonByteSize $this) {
        return $this.maxBitsPerChar();
    }

    default public float maxBitsPerChar() {
        return 1.0f / this.maxCharsPerBit();
    }

    public static BitsCharsetDecoder newDecoder$(BitsCharsetNonByteSize $this) {
        return $this.newDecoder();
    }

    @Override
    default public BitsCharsetDecoder newDecoder() {
        return new BitsCharsetNonByteSizeDecoder(this);
    }

    public static BitsCharsetEncoder newEncoder$(BitsCharsetNonByteSize $this) {
        return $this.newEncoder();
    }

    @Override
    default public BitsCharsetEncoder newEncoder() {
        return new BitsCharsetNonByteSizeEncoder(this, this.replacementCharCode());
    }

    public static int mandatoryBitAlignment$(BitsCharsetNonByteSize $this) {
        return $this.mandatoryBitAlignment();
    }

    @Override
    default public int mandatoryBitAlignment() {
        return 1;
    }

    public static long maybeFixedWidth$(BitsCharsetNonByteSize $this) {
        return $this.maybeFixedWidth();
    }

    @Override
    default public long maybeFixedWidth() {
        return MaybeInt$.MODULE$.apply(this.bitWidthOfACodeUnit());
    }

    public static MaybeInt[] org$apache$daffodil$io$processors$charset$BitsCharsetNonByteSize$$encodeArray$(BitsCharsetNonByteSize $this) {
        return $this.org$apache$daffodil$io$processors$charset$BitsCharsetNonByteSize$$encodeArray();
    }

    default public long[] org$apache$daffodil$io$processors$charset$BitsCharsetNonByteSize$$encodeArray() {
        int len = this.decodeString().length();
        MaybeInt[] arr = new MaybeInt[256];
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 255).foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            arr$1[index] = new MaybeInt(MaybeInt$.MODULE$.Nope());
        });
        IndexedSeq imap = (IndexedSeq)Predef$.MODULE$.wrapString(this.decodeString()).zip((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), len - 1));
        imap.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                char c = tuple2._1$mcC$sp();
                int index = tuple2._2$mcI$sp();
                if (c < '\u0100') {
                    arr$2[Char$.MODULE$.char2int((char)c)] = new MaybeInt(MaybeInt$.MODULE$.apply(index));
                    return;
                }
                if (c == '\ufffd') {
                    return;
                }
                throw Assert$.MODULE$.invariantFailed(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Char with code %n found. Character codes must be < 256."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
            }
            throw new MatchError((Object)tuple2);
        });
        return arr;
    }

    public static char codeToChar$(BitsCharsetNonByteSize $this, int code) {
        return $this.codeToChar(code);
    }

    default public char codeToChar(int code) {
        return this.decodeString().charAt(code);
    }

    public static long charToCode$(BitsCharsetNonByteSize $this, char c) {
        return $this.charToCode(c);
    }

    default public long charToCode(char c) {
        if (c < '\u0100') {
            return this.org$apache$daffodil$io$processors$charset$BitsCharsetNonByteSize$$encodeArray()[Char$.MODULE$.char2int(c)].__v();
        }
        return MaybeInt$.MODULE$.Nope();
    }
}

