/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantilescommon.DoublesSketchSortedView;
import org.apache.datasketches.quantilescommon.LinearRanksAndQuantiles;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CustomQuantilesTest {
    private static final boolean enablePrinting = false;

    @Test
    public void checkQuantilesV400() {
        double trimNatRank;
        double rawNatRank;
        double qTrue;
        double qEst;
        double normRankIn;
        CustomQuantilesTest.println("org.apache.datasketches.quantiles.CustomQuantilesTest:");
        CustomQuantilesTest.println("Classic DoubleSketch, Version 4.0.0, k=4, N=12");
        CustomQuantilesTest.println("");
        int k = 4;
        UpdateDoublesSketch sk = DoublesSketch.builder().setK(k).build();
        for (int i = 1; i <= 3; ++i) {
            for (int q = 10; q <= k * 10; q += 10) {
                sk.update((double)q);
            }
        }
        long N = sk.getN();
        DoublesSketchSortedView sv = sk.getSortedView();
        double[] quantilesArr = sv.getQuantiles();
        long[] cumWtsArr = sv.getCumulativeWeights();
        int lenQ = quantilesArr.length;
        CustomQuantilesTest.println("Sorted View:");
        CustomQuantilesTest.printf("%13s %13s %13s\n", "QuantilesArr", "CumWtsArr", "NormRanks");
        for (int i = 0; i < lenQ; ++i) {
            double normRank = (double)cumWtsArr[i] / (double)N;
            CustomQuantilesTest.printf("%12.1f%12d%12.4f\n", quantilesArr[i], cumWtsArr[i], normRank);
        }
        CustomQuantilesTest.println("");
        CustomQuantilesTest.println("GetRanks, EXCLUSIVE:");
        CustomQuantilesTest.println("  R of the largest Q at the highest index that is < q. If q <= smallest Q => 0");
        CustomQuantilesTest.printf("%12s %12s\n", "Quantiles", "NormRanks");
        for (int q = 0; q <= k * 10 + 5; q += 5) {
            double normRankEst = sk.getRank((double)q, QuantileSearchCriteria.EXCLUSIVE);
            double normRankTrue = LinearRanksAndQuantiles.getTrueDoubleRank(cumWtsArr, quantilesArr, q, QuantileSearchCriteria.EXCLUSIVE);
            Assert.assertEquals((double)normRankEst, (double)normRankTrue);
            CustomQuantilesTest.printf("%12.1f %12.3f", q, normRankEst);
            if (normRankEst != normRankTrue) {
                CustomQuantilesTest.println("  " + normRankEst + " != " + normRankTrue);
                continue;
            }
            CustomQuantilesTest.println("");
        }
        CustomQuantilesTest.println("");
        CustomQuantilesTest.println("GetQuantiles, EXCLUSIVE (round down)");
        CustomQuantilesTest.println("  Q of the smallest rank > r. If r = 1.0 => null or NaN");
        CustomQuantilesTest.printf("%22s %22s %22s %13s\n", "NormRanksIn", "RawNaturalRank", "TrimmedNatRank", "QuantilesEst");
        long limit = 4L * N;
        double inc = 1.0 / (double)limit;
        for (long j = 0L; j <= limit; ++j) {
            normRankIn = (double)j * inc;
            qEst = sk.getQuantile(normRankIn, QuantileSearchCriteria.EXCLUSIVE);
            qTrue = LinearRanksAndQuantiles.getTrueDoubleQuantile(cumWtsArr, quantilesArr, normRankIn, QuantileSearchCriteria.EXCLUSIVE);
            Assert.assertEquals((double)qEst, (double)qTrue);
            rawNatRank = normRankIn * (double)N;
            trimNatRank = QuantilesUtil.getNaturalRank((double)normRankIn, (long)N, (QuantileSearchCriteria)QuantileSearchCriteria.EXCLUSIVE);
            CustomQuantilesTest.printf("%22.18f %22.18f %22.18f %13.1f", normRankIn, rawNatRank, trimNatRank, qEst);
            if (qEst != qTrue) {
                CustomQuantilesTest.println("  " + qEst + " != " + qTrue);
                continue;
            }
            CustomQuantilesTest.println("");
        }
        CustomQuantilesTest.println("");
        CustomQuantilesTest.println("GetRanks, INCLUSIVE:");
        CustomQuantilesTest.println("  R of the largest Q at the highest index that is <= q. If q < smallest Q => 0");
        CustomQuantilesTest.printf("%12s %12s\n", "Quantiles", "NormRanks");
        for (int q = 0; q <= k * 10 + 5; q += 5) {
            double nr = sk.getRank((double)q, QuantileSearchCriteria.INCLUSIVE);
            double nrTrue = LinearRanksAndQuantiles.getTrueDoubleRank(cumWtsArr, quantilesArr, q, QuantileSearchCriteria.INCLUSIVE);
            Assert.assertEquals((double)nr, (double)nrTrue);
            CustomQuantilesTest.printf("%12.1f %12.3f", q, nr);
            if (nr != nrTrue) {
                CustomQuantilesTest.println("  " + nr + " != " + nrTrue);
                continue;
            }
            CustomQuantilesTest.println("");
        }
        CustomQuantilesTest.println("");
        CustomQuantilesTest.println("GetQuantiles, INCLUSIVE (round up)");
        CustomQuantilesTest.println("  Q of the smallest rank >= r.");
        CustomQuantilesTest.printf("%22s %22s %22s %13s\n", "NormRanksIn", "RawNaturalRank", "TrimmedNatRank", "QuantilesEst");
        inc = 1.0 / (double)limit;
        for (long j = 0L; j <= limit; ++j) {
            normRankIn = (double)j * inc;
            qEst = sk.getQuantile(normRankIn, QuantileSearchCriteria.INCLUSIVE);
            qTrue = LinearRanksAndQuantiles.getTrueDoubleQuantile(cumWtsArr, quantilesArr, normRankIn, QuantileSearchCriteria.INCLUSIVE);
            Assert.assertEquals((double)qEst, (double)qTrue);
            rawNatRank = normRankIn * (double)N;
            trimNatRank = QuantilesUtil.getNaturalRank((double)normRankIn, (long)N, (QuantileSearchCriteria)QuantileSearchCriteria.INCLUSIVE);
            CustomQuantilesTest.printf("%22.18f %22.18f %22.18f %13.1f", normRankIn, rawNatRank, trimNatRank, qEst);
            if (qEst != qTrue) {
                CustomQuantilesTest.println("  " + qEst + " != " + qTrue);
                continue;
            }
            CustomQuantilesTest.println("");
        }
        CustomQuantilesTest.println("");
    }

    static final void print(Object o) {
    }

    static final void println(Object o) {
    }

    static final void printf(String format, Object ... args) {
    }
}

