/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AlterColumnTest
extends BaseJDBCTestCase {
    public AlterColumnTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(AlterColumnTest.class);
    }

    public void testAlterDefault() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t(i int default 0)");
        PreparedStatement pd = this.prepareStatement("delete from t");
        PreparedStatement pi = this.prepareStatement("insert into t values default");
        PreparedStatement ps = this.prepareStatement("select * from t order by i");
        pi.executeUpdate();
        JDBC.assertFullResultSet(ps.executeQuery(), new String[][]{{"0"}});
        s.execute("alter table t alter COLUMN i DEFAULT 1");
        AlterColumnTest.tryAndExpect(pd, pi, ps, "1");
        s.execute("alter table t alter COLUMN i WITH DEFAULT 2");
        AlterColumnTest.tryAndExpect(pd, pi, ps, "2");
        s.execute("alter table t alter COLUMN i SET DEFAULT 3");
        AlterColumnTest.tryAndExpect(pd, pi, ps, "3");
        s.execute("alter table t alter i DEFAULT 4");
        AlterColumnTest.tryAndExpect(pd, pi, ps, "4");
        s.execute("alter table t alter i WITH DEFAULT 5");
        AlterColumnTest.tryAndExpect(pd, pi, ps, "5");
        s.execute("alter table t alter i SET DEFAULT 6");
        AlterColumnTest.tryAndExpect(pd, pi, ps, "6");
        s.execute("alter table t alter i SET DEFAULT null");
        AlterColumnTest.tryAndExpect(pd, pi, ps, null);
        s.execute("alter table t alter i SET DEFAULT 1");
        AlterColumnTest.tryAndExpect(pd, pi, ps, "1");
        s.execute("alter table t alter i DROP DEFAULT");
        AlterColumnTest.tryAndExpect(pd, pi, ps, null);
        s.close();
        pd.close();
        pi.close();
        ps.close();
    }

    private static void tryAndExpect(PreparedStatement d, PreparedStatement i, PreparedStatement s, String e) throws SQLException {
        d.executeUpdate();
        i.executeUpdate();
        JDBC.assertSingleValueResultSet(s.executeQuery(), e);
    }
}

