/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class GeneratedColumnsPermsTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String JANET = "JANET";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "JANET"};

    public GeneratedColumnsPermsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(GeneratedColumnsPermsTest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        Test test = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanDatabaseTestSetup, LEGAL_USERS, "generatedColumnsPermissions");
        Test test2 = TestConfiguration.sqlAuthorizationDecorator(test);
        return test2;
    }

    public void test_001_basicPermissions() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(JANET);
        this.goodStatement(connection, "create table t_bp_1( a int, b int generated always as ( -a ) )");
        this.goodStatement(connection, "insert into t_bp_1( a ) values ( 1 )");
        this.goodStatement(connection, "grant select ( a ) on t_bp_1 to public");
        this.goodStatement(connection, "grant update ( a ) on t_bp_1 to public");
        this.expectExecutionError(connection2, "42500", "insert into test_dbo.t_bp_1( a ) values ( 100 )");
        this.goodStatement(connection2, "update test_dbo.t_bp_1 set a = a+ 1");
        this.expectExecutionError(connection2, "42500", "delete from test_dbo.t_bp_1 where a = 2");
        this.expectExecutionError(connection2, "42502", "select * from test_dbo.t_bp_1 order by a");
        this.assertResults(connection2, "select a from test_dbo.t_bp_1 order by a", new String[][]{{"2"}}, false);
        this.goodStatement(connection, "grant select ( b ) on t_bp_1 to public");
        this.expectExecutionError(connection2, "42500", "insert into test_dbo.t_bp_1( a ) values ( 100 )");
        this.goodStatement(connection2, "update test_dbo.t_bp_1 set a = a+ 1");
        this.expectExecutionError(connection2, "42500", "delete from test_dbo.t_bp_1 where a = 2");
        this.assertResults(connection2, "select * from test_dbo.t_bp_1 order by a", new String[][]{{"3", "-3"}}, false);
        this.goodStatement(connection, "grant update ( b ) on t_bp_1 to public");
        this.expectExecutionError(connection2, "42500", "insert into test_dbo.t_bp_1( a ) values ( 100 )");
        this.goodStatement(connection2, "update test_dbo.t_bp_1 set a = a+ 1");
        this.expectExecutionError(connection2, "42500", "delete from test_dbo.t_bp_1 where a = 2");
        this.assertResults(connection2, "select * from test_dbo.t_bp_1 order by a", new String[][]{{"4", "-4"}}, false);
        this.goodStatement(connection, "grant insert on t_bp_1 to public");
        this.goodStatement(connection2, "insert into test_dbo.t_bp_1( a ) values ( 100 )");
        this.expectExecutionError(connection2, "42500", "delete from test_dbo.t_bp_1 where a = 2");
        this.assertResults(connection2, "select * from test_dbo.t_bp_1 order by a", new String[][]{{"4", "-4"}, {"100", "-100"}}, false);
        this.goodStatement(connection, "grant delete on t_bp_1 to public");
        this.goodStatement(connection2, "delete from test_dbo.t_bp_1 where a = 4");
        this.assertResults(connection2, "select * from test_dbo.t_bp_1 order by a", new String[][]{{"100", "-100"}}, false);
    }

    public void test_002_functionPermissions() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(JANET);
        this.goodStatement(connection, "create function f_fp_minus\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(connection, "create table t_fp_1( a int, b int generated always as ( test_dbo.f_fp_minus( a ) ) )");
        this.goodStatement(connection, "grant update on t_fp_1 to public");
        this.goodStatement(connection, "grant insert on t_fp_1 to public");
        this.goodStatement(connection, "grant select on t_fp_1 to public");
        this.goodStatement(connection, "insert into test_dbo.t_fp_1( a ) values ( 100 )");
        this.goodStatement(connection2, "create function f_fp_minus\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(connection2, "update test_dbo.t_fp_1 set a = a + 1");
        this.goodStatement(connection2, "insert into test_dbo.t_fp_1( a ) values ( 200 )");
        this.assertResults(connection2, "select * from test_dbo.t_fp_1 order by a", new String[][]{{"101", "-101"}, {"200", "-200"}}, false);
        this.goodStatement(connection, "grant execute on function f_fp_minus to public");
        this.goodStatement(connection2, "update test_dbo.t_fp_1 set a = a + 1");
        this.goodStatement(connection2, "insert into test_dbo.t_fp_1( a ) values ( 200 )");
        this.assertResults(connection2, "select * from test_dbo.t_fp_1 order by a", new String[][]{{"102", "-102"}, {"200", "-200"}, {"201", "-201"}}, false);
    }

    public void test_003_ddl() throws Exception {
        Connection connection = this.getConnection();
        this.expectCompilationError("42XA2", "create table t_ddl_1( a int, b varchar( 128 ) generated always as ( current_role ) )");
    }

    public void test_004_functionSchema() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(JANET);
        this.goodStatement(connection, "create function f_fsch_1\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(connection, "create table t_fsch_1( a int, b generated always as ( f_fsch_1( a ) ) )");
        this.goodStatement(connection, "create table t_fsch_2( a int )");
        this.goodStatement(connection, "alter table t_fsch_2 add column b generated always as ( f_fsch_1( a ) )");
        this.goodStatement(connection, "grant execute on function f_fsch_1 to public");
        this.goodStatement(connection, "grant select on t_fsch_1 to public");
        this.goodStatement(connection, "grant insert on t_fsch_1 to public");
        this.goodStatement(connection, "grant update on t_fsch_1 to public");
        this.goodStatement(connection, "grant select on t_fsch_2 to public");
        this.goodStatement(connection, "grant insert on t_fsch_2 to public");
        this.goodStatement(connection, "grant update on t_fsch_2 to public");
        this.goodStatement(connection2, "create function f_fsch_1\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(connection, "insert into test_dbo.t_fsch_1( a ) values ( 1 )");
        this.goodStatement(connection, "insert into test_dbo.t_fsch_2( a ) values ( 2 )");
        this.goodStatement(connection2, "insert into test_dbo.t_fsch_1( a ) values ( 1 )");
        this.assertResults(connection2, "select * from test_dbo.t_fsch_1 order by a", new String[][]{{"1", "-1"}, {"1", "-1"}}, false);
        this.goodStatement(connection2, "insert into test_dbo.t_fsch_2( a ) values ( 2 )");
        this.assertResults(connection2, "select * from test_dbo.t_fsch_2 order by a", new String[][]{{"2", "-2"}, {"2", "-2"}}, false);
        this.goodStatement(connection2, "update test_dbo.t_fsch_1 set a = 100 + a");
        this.assertResults(connection2, "select * from test_dbo.t_fsch_1 order by a", new String[][]{{"101", "-101"}, {"101", "-101"}}, false);
        this.goodStatement(connection2, "update test_dbo.t_fsch_2 set a = 100 + a");
        this.assertResults(connection2, "select * from test_dbo.t_fsch_2 order by a", new String[][]{{"102", "-102"}, {"102", "-102"}}, false);
    }

    public void test_005_functionSchema() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(JANET);
        this.goodStatement(connection, "create function f_3944\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(connection, "create table t_3944( a int, constraint t_3944_check check ( f_3944( a ) < 0 ) )");
        this.goodStatement(connection, "grant insert on t_3944 to public");
        this.goodStatement(connection, "grant execute on function f_3944 to public");
        this.expectExecutionError(connection2, "23513", "insert into test_dbo.t_3944( a ) values ( -100 )");
        this.goodStatement(connection2, "insert into test_dbo.t_3944( a ) values ( 200 )");
        this.assertResults(connection, "select * from t_3944 order by a", new String[][]{{"200"}}, false);
    }

    public void test_006_functionSchema() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(JANET);
        this.goodStatement(connection, "create function f_3953\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(connection, "create view v_3953( a, b ) as values ( f_3953( 1 ), f_3953( 2 ) )");
        this.goodStatement(connection, "grant select on v_3953 to public");
        this.goodStatement(connection, "grant execute on function f_3953 to public");
        this.goodStatement(connection2, "create function f_3953\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.assertResults(connection2, "values ( f_3953( 1 ), f_3953( 2 ) )", new String[][]{{"1", "2"}}, false);
        this.assertResults(connection2, "select * from test_dbo.v_3953", new String[][]{{"-1", "-2"}}, false);
    }
}

