/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.request;

import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.util.Strings;

public class AttributeValueAssertion {
    private String attributeDesc;
    private Value<?> assertionValue;

    public static String dumpObject(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof byte[]) {
                return Strings.dumpBytes((byte[])object);
            }
            if (object instanceof StringValue) {
                return ((StringValue)object).getValue();
            }
            if (object instanceof BinaryValue) {
                return Strings.dumpBytes(((BinaryValue)object).getValue());
            }
            return "<unknown type>";
        }
        return "";
    }

    public Value<?> getAssertionValue() {
        return this.assertionValue;
    }

    public void setAssertionValue(Value<?> assertionValue) {
        this.assertionValue = assertionValue;
    }

    public String getAttributeDesc() {
        return this.attributeDesc;
    }

    public void setAttributeDesc(String attributeDesc) {
        this.attributeDesc = attributeDesc;
    }

    public String toString(String tabs) {
        StringBuffer sb = new StringBuffer();
        sb.append(tabs).append("AttributeValueAssertion\n");
        sb.append(tabs).append("    Assertion description : '");
        sb.append(this.attributeDesc != null ? this.attributeDesc : "null");
        sb.append("'\n");
        sb.append(tabs).append("    Assertion value : '").append(AttributeValueAssertion.dumpObject(this.assertionValue)).append("'\n");
        return sb.toString();
    }

    public String toStringRFC2254(int filterType) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.attributeDesc);
        switch (filterType) {
            case 0: {
                sb.append('=');
                break;
            }
            case 2: {
                sb.append("<=");
                break;
            }
            case 1: {
                sb.append(">=");
                break;
            }
            case 3: {
                sb.append("~=");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected filter type " + filterType);
            }
        }
        sb.append(AttributeValueAssertion.dumpObject(this.assertionValue));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

