/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.Comparator;
import org.apache.flink.streaming.util.typeutils.FieldAccessor;
import org.apache.flink.streaming.util.typeutils.FieldAccessorFactory;

@Internal
public class ComparableAggregator<T>
extends AggregationFunction<T> {
    private static final long serialVersionUID = 1L;
    private Comparator comparator;
    private boolean byAggregate;
    private boolean first;
    private final FieldAccessor<T, Object> fieldAccessor;

    private ComparableAggregator(AggregationFunction.AggregationType aggregationType, FieldAccessor<T, Object> fieldAccessor, boolean first) {
        this.comparator = Comparator.getForAggregation(aggregationType);
        this.byAggregate = aggregationType == AggregationFunction.AggregationType.MAXBY || aggregationType == AggregationFunction.AggregationType.MINBY;
        this.first = first;
        this.fieldAccessor = fieldAccessor;
    }

    public ComparableAggregator(int positionToAggregate, TypeInformation<T> typeInfo, AggregationFunction.AggregationType aggregationType, ExecutionConfig config) {
        this(positionToAggregate, typeInfo, aggregationType, false, config);
    }

    public ComparableAggregator(int positionToAggregate, TypeInformation<T> typeInfo, AggregationFunction.AggregationType aggregationType, boolean first, ExecutionConfig config) {
        this(aggregationType, FieldAccessorFactory.getAccessor(typeInfo, positionToAggregate, config), first);
    }

    public ComparableAggregator(String field, TypeInformation<T> typeInfo, AggregationFunction.AggregationType aggregationType, boolean first, ExecutionConfig config) {
        this(aggregationType, FieldAccessorFactory.getAccessor(typeInfo, field, config), first);
    }

    @Override
    public T reduce(T value1, T value2) throws Exception {
        Comparable o1 = (Comparable)this.fieldAccessor.get(value1);
        Object o2 = this.fieldAccessor.get(value2);
        int c = this.comparator.isExtremal(o1, o2);
        if (this.byAggregate) {
            if (c == 0) {
                return this.first ? value1 : value2;
            }
            return c == 1 ? value1 : value2;
        }
        if (c == 0) {
            value1 = this.fieldAccessor.set(value1, o2);
        }
        return value1;
    }
}

