/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.defragmentation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.defragmentation.DefragmentationCommand;
import org.apache.ignite.internal.management.defragmentation.DefragmentationScheduleCommandArg;
import org.apache.ignite.internal.management.defragmentation.DefragmentationTask;
import org.apache.ignite.internal.management.defragmentation.DefragmentationTaskResult;
import org.apache.ignite.internal.util.typedef.F;

public class DefragmentationScheduleCommand
implements ComputeCommand<DefragmentationCommand.DefragmentationStatusCommandArg, DefragmentationTaskResult> {
    @Override
    public String description() {
        return "Schedule PDS defragmentation";
    }

    @Override
    public Class<DefragmentationScheduleCommandArg> argClass() {
        return DefragmentationScheduleCommandArg.class;
    }

    @Override
    public Class<DefragmentationTask> taskClass() {
        return DefragmentationTask.class;
    }

    @Override
    public void printResult(DefragmentationCommand.DefragmentationStatusCommandArg arg, DefragmentationTaskResult res, Consumer<String> printer) {
        printer.accept(res.getMessage());
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, DefragmentationCommand.DefragmentationStatusCommandArg arg0) {
        DefragmentationScheduleCommandArg arg = (DefragmentationScheduleCommandArg)arg0;
        if (F.isEmpty(arg.nodes())) {
            return null;
        }
        HashSet<String> nodesArg = new HashSet<String>(Arrays.asList(arg.nodes()));
        return nodes.stream().filter(n -> nodesArg.contains(Objects.toString(n.consistentId()))).collect(Collectors.toList());
    }
}

