/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheDataRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;

public class ClientCacheKeysRequest
extends ClientCacheDataRequest
implements ClientTxAwareRequest {
    private final Set<Object> keys;

    ClientCacheKeysRequest(BinaryRawReaderEx reader) {
        super(reader);
        this.keys = ClientCacheKeysRequest.readSet(reader);
    }

    public Set<Object> keys() {
        return this.keys;
    }

    private static Set<Object> readSet(BinaryRawReaderEx reader) {
        int cnt = reader.readInt();
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>(cnt);
        for (int i = 0; i < cnt; ++i) {
            keys.add(reader.readObjectDetached());
        }
        return keys;
    }

    @Override
    public boolean isAsync(ClientConnectionContext ctx) {
        return this.cacheDescriptor(ctx).cacheConfiguration().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL;
    }
}

