/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.network.serialization.BuiltInType;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.marshal.BuiltInMarshalling;
import org.apache.ignite.internal.network.serialization.marshal.MarshalException;
import org.apache.ignite.internal.network.serialization.marshal.MarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshalException;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.ValueReader;
import org.apache.ignite.internal.network.serialization.marshal.ValueWriter;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

class BuiltInNonContainerMarshallers {
    private final Int2ObjectMap<BuiltInMarshaller<?>> builtInMarshallers = BuiltInNonContainerMarshallers.createBuiltInMarshallers();

    BuiltInNonContainerMarshallers() {
    }

    private static Int2ObjectMap<BuiltInMarshaller<?>> createBuiltInMarshallers() {
        HashMap map = new HashMap();
        BuiltInNonContainerMarshallers.addPrimitiveAndWrapper(map, BuiltInType.BYTE, BuiltInType.BYTE_BOXED, (obj, dos) -> dos.writeByte((int)obj.byteValue()), DataInput::readByte);
        BuiltInNonContainerMarshallers.addPrimitiveAndWrapper(map, BuiltInType.SHORT, BuiltInType.SHORT_BOXED, (obj, dos) -> dos.writeShort((int)obj.shortValue()), DataInput::readShort);
        BuiltInNonContainerMarshallers.addPrimitiveAndWrapper(map, BuiltInType.INT, BuiltInType.INT_BOXED, (obj, dos) -> dos.writeInt(obj.intValue()), DataInput::readInt);
        BuiltInNonContainerMarshallers.addPrimitiveAndWrapper(map, BuiltInType.FLOAT, BuiltInType.FLOAT_BOXED, (obj, dos) -> dos.writeFloat(obj.floatValue()), DataInput::readFloat);
        BuiltInNonContainerMarshallers.addPrimitiveAndWrapper(map, BuiltInType.LONG, BuiltInType.LONG_BOXED, (obj, dos) -> dos.writeLong(obj.longValue()), DataInput::readLong);
        BuiltInNonContainerMarshallers.addPrimitiveAndWrapper(map, BuiltInType.DOUBLE, BuiltInType.DOUBLE_BOXED, (obj, dos) -> dos.writeDouble(obj.doubleValue()), DataInput::readDouble);
        BuiltInNonContainerMarshallers.addPrimitiveAndWrapper(map, BuiltInType.BOOLEAN, BuiltInType.BOOLEAN_BOXED, (obj, dos) -> dos.writeBoolean(obj.booleanValue()), DataInput::readBoolean);
        BuiltInNonContainerMarshallers.addPrimitiveAndWrapper(map, BuiltInType.CHAR, BuiltInType.CHAR_BOXED, (obj, dos) -> dos.writeChar((int)obj.charValue()), DataInput::readChar);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.BARE_OBJECT, (T obj, IgniteDataOutput dos) -> {}, BuiltInMarshalling::readBareObject);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.STRING, BuiltInMarshalling::writeString, BuiltInMarshalling::readString);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.UUID, BuiltInMarshalling::writeUuid, BuiltInMarshalling::readUuid);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.IGNITE_UUID, BuiltInMarshalling::writeIgniteUuid, BuiltInMarshalling::readIgniteUuid);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.DATE, BuiltInMarshalling::writeDate, BuiltInMarshalling::readDate);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.BYTE_ARRAY, BuiltInMarshalling::writeByteArray, BuiltInMarshalling::readByteArray);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.SHORT_ARRAY, BuiltInMarshalling::writeShortArray, BuiltInMarshalling::readShortArray);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.INT_ARRAY, BuiltInMarshalling::writeIntArray, BuiltInMarshalling::readIntArray);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.FLOAT_ARRAY, BuiltInMarshalling::writeFloatArray, BuiltInMarshalling::readFloatArray);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.LONG_ARRAY, BuiltInMarshalling::writeLongArray, BuiltInMarshalling::readLongArray);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.DOUBLE_ARRAY, BuiltInMarshalling::writeDoubleArray, BuiltInMarshalling::readDoubleArray);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.BOOLEAN_ARRAY, BuiltInMarshalling::writeBooleanArray, BuiltInMarshalling::readBooleanArray);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.CHAR_ARRAY, BuiltInMarshalling::writeCharArray, BuiltInMarshalling::readCharArray);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.DECIMAL, BuiltInMarshalling::writeBigDecimal, BuiltInMarshalling::readBigDecimal);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.BIT_SET, BuiltInMarshalling::writeBitSet, BuiltInMarshalling::readBitSet);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.NULL, (T obj, IgniteDataOutput output) -> {}, (IgniteDataInput input) -> null);
        BuiltInNonContainerMarshallers.addSingle(map, BuiltInType.CLASS, (T obj, IgniteDataOutput out, MarshallingContext ctx) -> BuiltInMarshalling.writeClass(obj, (DataOutput)out), BuiltInMarshalling::readClass);
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)new Int2ObjectOpenHashMap(map));
    }

    private static <T> void addSingle(Map<Integer, BuiltInMarshaller<?>> map, BuiltInType type, ValueWriter<T> writer, ValueReader<T> reader) {
        BuiltInMarshaller<T> builtInMarshaller = BuiltInNonContainerMarshallers.builtInMarshaller(writer, reader);
        map.put(type.descriptorId(), builtInMarshaller);
    }

    private static <T> void addSingle(Map<Integer, BuiltInMarshaller<?>> map, BuiltInType type, ContextlessValueWriter<T> writer, ContextlessValueReader<T> reader) {
        BuiltInNonContainerMarshallers.addSingle(map, type, BuiltInNonContainerMarshallers.contextless(writer), BuiltInNonContainerMarshallers.contextless(reader));
    }

    private static <T> void addPrimitiveAndWrapper(Map<Integer, BuiltInMarshaller<?>> map, BuiltInType primitiveType, BuiltInType wrapperType, ContextlessValueWriter<T> writer, ContextlessValueReader<T> reader) {
        BuiltInMarshaller<T> builtInMarshaller = BuiltInNonContainerMarshallers.builtInMarshaller(BuiltInNonContainerMarshallers.contextless(writer), BuiltInNonContainerMarshallers.contextless(reader));
        map.put(primitiveType.descriptorId(), builtInMarshaller);
        map.put(wrapperType.descriptorId(), builtInMarshaller);
    }

    private static <T> ValueWriter<T> contextless(ContextlessValueWriter<T> writer) {
        return (obj, out, ctx) -> writer.write(obj, out);
    }

    private static <T> ValueReader<T> contextless(ContextlessValueReader<T> reader) {
        return (in, ctx) -> reader.read(in);
    }

    private static <T> BuiltInMarshaller<T> builtInMarshaller(ValueWriter<T> writer, ValueReader<T> reader) {
        return new BuiltInMarshaller<T>(writer, reader);
    }

    boolean supports(ClassDescriptor descriptor) {
        return descriptor.isRuntimeEnum() || descriptor.isLatin1String() || this.builtInMarshallers.containsKey(descriptor.descriptorId());
    }

    void writeBuiltIn(Object object, ClassDescriptor descriptor, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        this.actuallyWrite(object, descriptor, output, context);
        context.addUsedDescriptor(descriptor);
    }

    private void actuallyWrite(Object object, ClassDescriptor descriptor, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        if (descriptor.isLatin1String()) {
            BuiltInMarshalling.writeLatin1String((String)object, output);
            return;
        }
        if (descriptor.isRuntimeEnum()) {
            BuiltInMarshalling.writeEnum((Enum)object, (DataOutput)output);
            return;
        }
        this.writeWithBuiltInMarshaller(object, descriptor, output, context);
    }

    private void writeWithBuiltInMarshaller(Object object, ClassDescriptor descriptor, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        BuiltInMarshaller<?> builtInMarshaller = this.findBuiltInMarshaller(descriptor);
        builtInMarshaller.marshal(object, output, context);
    }

    Object readBuiltIn(ClassDescriptor descriptor, IgniteDataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
        if (descriptor.isLatin1String()) {
            return BuiltInMarshalling.readLatin1String(input);
        }
        if (descriptor.isRuntimeEnum()) {
            return this.readEnum(descriptor, (DataInput)input);
        }
        BuiltInMarshaller<?> builtinMarshaller = this.findBuiltInMarshaller(descriptor);
        return builtinMarshaller.unmarshal(input, context);
    }

    private Object readEnum(ClassDescriptor descriptor, DataInput input) throws IOException {
        return BuiltInMarshalling.readEnum(input, descriptor.localClass());
    }

    private BuiltInMarshaller<?> findBuiltInMarshaller(ClassDescriptor descriptor) {
        BuiltInMarshaller builtinMarshaller = (BuiltInMarshaller)this.builtInMarshallers.get(descriptor.descriptorId());
        if (builtinMarshaller == null) {
            throw new IllegalStateException("No support for (un)marshalling " + descriptor.className() + ", but it's marked as built-in");
        }
        return builtinMarshaller;
    }

    static interface ContextlessValueWriter<T> {
        public void write(T var1, IgniteDataOutput var2) throws IOException, MarshalException;
    }

    private static interface ContextlessValueReader<T> {
        public T read(IgniteDataInput var1) throws IOException, UnmarshalException;
    }

    private static class BuiltInMarshaller<T> {
        private final ValueWriter<T> writer;
        private final ValueReader<T> reader;

        private BuiltInMarshaller(ValueWriter<T> writer, ValueReader<T> reader) {
            this.writer = writer;
            this.reader = reader;
        }

        private void marshal(Object object, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
            this.writer.write(object, output, context);
        }

        private Object unmarshal(IgniteDataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
            return this.reader.read(input, context);
        }
    }
}

