/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.jetbrains.annotations.Nullable;

public class CatalogTableDescriptor
extends CatalogObjectDescriptor {
    public static final CatalogObjectSerializer<CatalogTableDescriptor> SERIALIZER = new TableDescriptorSerializer();
    public static final int INITIAL_TABLE_VERSION = 1;
    private final int zoneId;
    private final int schemaId;
    private final int pkIndexId;
    @IgniteToStringExclude
    private final CatalogTableSchemaVersions schemaVersions;
    @IgniteToStringInclude
    private final List<CatalogTableColumnDescriptor> columns;
    @IgniteToStringInclude
    private final List<String> primaryKeyColumns;
    @IgniteToStringInclude
    private final List<String> colocationColumns;
    @IgniteToStringExclude
    private final Map<String, Int2ObjectMap.Entry<CatalogTableColumnDescriptor>> columnsMap;
    private final String storageProfile;

    public CatalogTableDescriptor(int id, int schemaId, int pkIndexId, String name, int zoneId, List<CatalogTableColumnDescriptor> columns, List<String> pkCols, @Nullable List<String> colocationCols, String storageProfile) {
        this(id, schemaId, pkIndexId, name, zoneId, columns, pkCols, colocationCols, new CatalogTableSchemaVersions(new CatalogTableSchemaVersions.TableVersion(columns)), storageProfile, 0L);
    }

    private CatalogTableDescriptor(int id, int schemaId, int pkIndexId, String name, int zoneId, List<CatalogTableColumnDescriptor> columns, List<String> pkCols, @Nullable List<String> colocationCols, CatalogTableSchemaVersions schemaVersions, String storageProfile, long causalityToken) {
        super(id, CatalogObjectDescriptor.Type.TABLE, name, causalityToken);
        this.schemaId = schemaId;
        this.pkIndexId = pkIndexId;
        this.zoneId = zoneId;
        this.columns = Objects.requireNonNull(columns, "No columns defined.");
        this.primaryKeyColumns = Objects.requireNonNull(pkCols, "No primary key columns.");
        HashMap columnMap = IgniteUtils.newHashMap((int)columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            CatalogTableColumnDescriptor column = columns.get(i);
            columnMap.put(column.name(), new AbstractInt2ObjectMap.BasicEntry(i, (Object)column));
        }
        this.columnsMap = columnMap;
        this.colocationColumns = Objects.requireNonNullElse(colocationCols, pkCols);
        this.schemaVersions = Objects.requireNonNull(schemaVersions, "No catalog schema versions.");
        this.storageProfile = Objects.requireNonNull(storageProfile, "No storage profile.");
    }

    public CatalogTableDescriptor newDescriptor(String name, int tableVersion, List<CatalogTableColumnDescriptor> columns, long causalityToken, String storageProfile) {
        CatalogTableSchemaVersions newSchemaVersions = tableVersion == this.schemaVersions.latestVersion() ? this.schemaVersions : this.schemaVersions.append(new CatalogTableSchemaVersions.TableVersion(columns), tableVersion);
        return new CatalogTableDescriptor(this.id(), this.schemaId, this.pkIndexId, name, this.zoneId, columns, this.primaryKeyColumns, this.colocationColumns, newSchemaVersions, storageProfile, causalityToken);
    }

    public int schemaId() {
        return this.schemaId;
    }

    public CatalogTableSchemaVersions schemaVersions() {
        return this.schemaVersions;
    }

    public int zoneId() {
        return this.zoneId;
    }

    public int primaryKeyIndexId() {
        return this.pkIndexId;
    }

    public int tableVersion() {
        return this.schemaVersions.latestVersion();
    }

    public List<String> primaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<String> colocationColumns() {
        return this.colocationColumns;
    }

    public List<CatalogTableColumnDescriptor> columns() {
        return this.columns;
    }

    @Nullable
    public CatalogTableColumnDescriptor column(String name) {
        Map.Entry column = (Map.Entry)this.columnsMap.get(name);
        if (column != null) {
            return (CatalogTableColumnDescriptor)column.getValue();
        }
        return null;
    }

    public int columnIndex(String name) {
        Map.Entry column = (Map.Entry)this.columnsMap.get(name);
        if (column != null) {
            return (Integer)column.getKey();
        }
        return -1;
    }

    public boolean isPrimaryKeyColumn(String name) {
        return this.primaryKeyColumns.contains(name);
    }

    public boolean isColocationColumn(String name) {
        return this.colocationColumns.contains(name);
    }

    @Override
    public String toString() {
        return S.toString(CatalogTableDescriptor.class, (Object)this, (String)super.toString());
    }

    public String storageProfile() {
        return this.storageProfile;
    }

    private static class TableDescriptorSerializer
    implements CatalogObjectSerializer<CatalogTableDescriptor> {
        private TableDescriptorSerializer() {
        }

        @Override
        public CatalogTableDescriptor readFrom(IgniteDataInput input) throws IOException {
            ArrayList<String> colocationColumns;
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateToken = input.readVarInt();
            CatalogTableSchemaVersions schemaVersions = CatalogTableSchemaVersions.SERIALIZER.readFrom(input);
            List<CatalogTableColumnDescriptor> columns = CatalogSerializationUtils.readList(CatalogTableColumnDescriptor.SERIALIZER, input);
            String storageProfile = input.readUTF();
            int schemaId = input.readVarIntAsInt();
            int pkIndexId = input.readVarIntAsInt();
            int zoneId = input.readVarIntAsInt();
            int pkKeysLen = input.readVarIntAsInt();
            int[] pkColumnIndexes = input.readIntArray(pkKeysLen);
            ArrayList<String> primaryKeyColumns = new ArrayList<String>(pkColumnIndexes.length);
            for (int idx : pkColumnIndexes) {
                primaryKeyColumns.add(columns.get(idx).name());
            }
            int colocationColumnsLen = input.readVarIntAsInt();
            if (colocationColumnsLen == -1) {
                colocationColumns = primaryKeyColumns;
            } else {
                int[] colocationColumnIdxs;
                colocationColumns = new ArrayList(colocationColumnsLen);
                for (int idx : colocationColumnIdxs = input.readIntArray(colocationColumnsLen)) {
                    colocationColumns.add(columns.get(idx).name());
                }
            }
            return new CatalogTableDescriptor(id, schemaId, pkIndexId, name, zoneId, columns, primaryKeyColumns, colocationColumns, schemaVersions, storageProfile, updateToken);
        }

        @Override
        public void writeTo(CatalogTableDescriptor descriptor, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateToken());
            CatalogTableSchemaVersions.SERIALIZER.writeTo(descriptor.schemaVersions(), output);
            CatalogSerializationUtils.writeList(descriptor.columns(), CatalogTableColumnDescriptor.SERIALIZER, output);
            output.writeUTF(descriptor.storageProfile());
            output.writeVarInt((long)descriptor.schemaId());
            output.writeVarInt((long)descriptor.primaryKeyIndexId());
            output.writeVarInt((long)descriptor.zoneId());
            int[] pkIndexes = TableDescriptorSerializer.resolvePkColumnIndexes(descriptor);
            output.writeVarInt((long)pkIndexes.length);
            output.writeIntArray(pkIndexes);
            if (descriptor.colocationColumns() == descriptor.primaryKeyColumns()) {
                output.writeVarInt(-1L);
            } else {
                int[] colocationIndexes = TableDescriptorSerializer.resolveColocationColumnIndexes(pkIndexes, descriptor);
                output.writeVarInt((long)colocationIndexes.length);
                output.writeIntArray(colocationIndexes);
            }
        }

        private static int[] resolveColocationColumnIndexes(int[] pkColumnIndexes, CatalogTableDescriptor descriptor) {
            int[] colocationColumnIndexes = new int[descriptor.colocationColumns().size()];
            block0: for (int idx : pkColumnIndexes) {
                String columnName = descriptor.columns.get(idx).name();
                for (int j = 0; j < descriptor.colocationColumns().size(); ++j) {
                    if (!descriptor.colocationColumns().get(j).equals(columnName)) continue;
                    colocationColumnIndexes[j] = idx;
                    continue block0;
                }
            }
            return colocationColumnIndexes;
        }

        private static int[] resolvePkColumnIndexes(CatalogTableDescriptor descriptor) {
            List<CatalogTableColumnDescriptor> columns = descriptor.columns();
            List<String> pkColumns = descriptor.primaryKeyColumns();
            assert (columns.size() >= pkColumns.size());
            int[] pkColumnIndexes = new int[pkColumns.size()];
            int foundCount = 0;
            block0: for (int i = 0; i < columns.size() && foundCount < pkColumnIndexes.length; ++i) {
                for (int j = 0; j < pkColumns.size(); ++j) {
                    String pkColumn = pkColumns.get(j);
                    if (!pkColumn.equals(columns.get(i).name())) continue;
                    pkColumnIndexes[j] = i;
                    ++foundCount;
                    continue block0;
                }
            }
            assert (foundCount == pkColumnIndexes.length);
            return pkColumnIndexes;
        }
    }
}

