/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.DataContexts;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.HintPredicates;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.type.SqlTypeCoercionRule;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.sql.engine.QueryProperty;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite.internal.sql.engine.exec.exp.RexExecutorImpl;
import org.apache.ignite.internal.sql.engine.hint.IgniteHint;
import org.apache.ignite.internal.sql.engine.metadata.IgniteMetadata;
import org.apache.ignite.internal.sql.engine.metadata.RelMetadataQueryEx;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.prepare.IgniteConvertletTable;
import org.apache.ignite.internal.sql.engine.prepare.IgniteTypeCoercion;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.property.SqlProperties;
import org.apache.ignite.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCommitTransaction;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlConformance;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlKill;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlParser;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlStartTransaction;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.trait.DistributionTraitDef;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeSystem;
import org.apache.ignite.internal.sql.engine.util.IgniteCustomAssignmentsRules;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.TemporalNativeType;
import org.apache.ignite.internal.type.VarlenNativeType;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class Commons {
    public static final String IMPLICIT_PK_COL_NAME = "__p_key";
    public static final String PART_COL_NAME = "__part";
    public static final int IN_BUFFER_SIZE = 512;
    public static final int IO_BATCH_SIZE = 256;
    public static final int IO_BATCH_COUNT = 4;
    public static final int SORTED_IDX_PART_PREFETCH_SIZE = 100;
    public static final List<RelTraitDef> DISTRIBUTED_TRAITS_SET = List.of(ConventionTraitDef.INSTANCE, DistributionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE);
    public static final FrameworkConfig FRAMEWORK_CONFIG = Frameworks.newConfigBuilder().executor((RexExecutor)new RexExecutorImpl(DataContexts.EMPTY)).sqlToRelConverterConfig(SqlToRelConverter.config().withTrimUnusedFields(true).withRemoveSortInSubQuery(false).withInSubQueryThreshold(Integer.MAX_VALUE).withDecorrelationEnabled(true).withExpand(false).withHintStrategyTable(HintStrategyTable.builder().hintStrategy(IgniteHint.ENFORCE_JOIN_ORDER.name(), HintPredicates.JOIN).hintStrategy(IgniteHint.DISABLE_RULE.name(), (hint, rel) -> true).hintStrategy(IgniteHint.EXPAND_DISTINCT_AGG.name(), HintPredicates.AGGREGATE).hintStrategy(IgniteHint.NO_INDEX.name(), (hint, rel) -> rel instanceof IgniteLogicalTableScan).hintStrategy(IgniteHint.FORCE_INDEX.name(), (hint, rel) -> rel instanceof IgniteLogicalTableScan).build())).convertletTable((SqlRexConvertletTable)IgniteConvertletTable.INSTANCE).parserConfig(IgniteSqlParser.PARSER_CONFIG).sqlValidatorConfig(SqlValidator.Config.DEFAULT.withIdentifierExpansion(true).withDefaultNullCollation(NullCollation.HIGH).withSqlConformance(IgniteSqlConformance.INSTANCE).withTypeCoercionRules(Commons.standardCompatibleCoercionRules()).withTypeCoercionFactory(IgniteTypeCoercion::new)).operatorTable((SqlOperatorTable)IgniteSqlOperatorTable.INSTANCE).context(Contexts.empty()).costFactory((RelOptCostFactory)new IgniteCostFactory()).typeSystem((RelDataTypeSystem)IgniteTypeSystem.INSTANCE).traitDefs(DISTRIBUTED_TRAITS_SET).build();
    @Nullable
    private static volatile Boolean fastOptimizationsEnabled = null;

    private Commons() {
    }

    private static SqlTypeCoercionRule standardCompatibleCoercionRules() {
        return SqlTypeCoercionRule.instance(IgniteCustomAssignmentsRules.instance().getTypeMapping());
    }

    @Nullable
    public static <RowT> Object getFieldFromBiRows(RowHandler<RowT> hnd, int offset, RowT row1, RowT row2) {
        return offset < hnd.columnCount(row1) ? hnd.get(offset, row1) : hnd.get(offset - hnd.columnCount(row1), row2);
    }

    public static <T> List<T> cast(List<?> src) {
        return src;
    }

    public static <T> CompletableFuture<T> cast(CompletableFuture<?> src) {
        return src;
    }

    public static <T> T cast(Object src) {
        return (T)src;
    }

    public static <T, R> List<R> transform(List<T> src, Function<T, R> mapFun) {
        if (CollectionUtils.nullOrEmpty(src)) {
            return Collections.emptyList();
        }
        ArrayList<R> list = new ArrayList<R>(src.size());
        for (T t : src) {
            list.add(mapFun.apply(t));
        }
        return list;
    }

    public static IgniteTypeFactory typeFactory(RelNode rel) {
        return Commons.typeFactory(rel.getCluster());
    }

    public static IgniteTypeFactory typeFactory(RelOptCluster cluster) {
        return (IgniteTypeFactory)cluster.getTypeFactory();
    }

    public static IgniteTypeFactory typeFactory() {
        return Commons.typeFactory(Commons.emptyCluster());
    }

    public static RexBuilder rexBuilder() {
        return Commons.emptyCluster().getRexBuilder();
    }

    public static PlanningContext context(RelNode rel) {
        return Commons.context(rel.getCluster());
    }

    public static PlanningContext context(RelOptCluster cluster) {
        return Objects.requireNonNull((PlanningContext)cluster.getPlanner().getContext().unwrap(PlanningContext.class));
    }

    public static Map<String, Object> parametersMap(@Nullable Object[] params) {
        if (ArrayUtils.nullOrEmpty((Object[])params)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        Commons.populateParameters(res, params);
        return res;
    }

    public static Int2ObjectMap<Object> arrayToMap(@Nullable Object[] params) {
        if (ArrayUtils.nullOrEmpty((Object[])params)) {
            return Int2ObjectMaps.emptyMap();
        }
        Int2ObjectArrayMap res = new Int2ObjectArrayMap(params.length);
        for (int i = 0; i < params.length; ++i) {
            res.put(i, params[i]);
        }
        return res;
    }

    private static void populateParameters(Map<String, Object> dst, Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            dst.put("?" + i, params[i]);
        }
    }

    public static <T> List<T> flat(List<List<T>> src) {
        return src.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <T> T compile(Class<T> interfaceType, String body) {
        boolean debug = (Boolean)CalciteSystemProperty.DEBUG.value();
        if (debug) {
            Util.debugCode((PrintStream)System.out, (String)body);
        }
        try {
            ICompilerFactory compilerFactory;
            try {
                compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory((ClassLoader)ExpressionFactoryImpl.class.getClassLoader());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to instantiate java compiler", e);
            }
            IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
            cbe.setImplementedInterfaces(new Class[]{interfaceType});
            if (debug) {
                cbe.setDebuggingInformation(true, true, true);
            }
            return (T)cbe.createInstance((Reader)new StringReader(body));
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Unable to compile expression", (Throwable)e);
        }
    }

    public static void checkRange(Object[] array, int idx) {
        if (idx < 0 || idx >= array.length) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
    }

    public static <T> T[] ensureCapacity(T[] array, int required) {
        if (required < 0) {
            throw new IllegalArgumentException("Capacity must not be negative");
        }
        return array.length <= required ? Arrays.copyOf(array, Commons.nextPowerOf2(required)) : array;
    }

    public static int nextPowerOf2(int v) {
        if (v < 0) {
            throw new IllegalArgumentException("v must not be negative");
        }
        if (v == 0) {
            return 1;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(v - 1);
    }

    public static Mapping trimmingMapping(int sourceSize, ImmutableBitSet requiredElements) {
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)sourceSize, (int)requiredElements.cardinality());
        for (Ord ord : Ord.zip((Iterable)requiredElements)) {
            mapping.set(((Integer)ord.e).intValue(), ord.i);
        }
        return mapping;
    }

    public static Mapping projectedMapping(int sourceSize, ImmutableIntList projection) {
        Mapping result = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)sourceSize, (int)projection.size());
        for (int i = 0; i < projection.size(); ++i) {
            result.set(projection.getInt(i), i);
        }
        return result;
    }

    @Nullable
    public static Object readValue(InternalTuple tuple, NativeType nativeType, int fieldIndex) {
        switch (nativeType.spec()) {
            case BOOLEAN: {
                return tuple.booleanValueBoxed(fieldIndex);
            }
            case INT8: {
                return tuple.byteValueBoxed(fieldIndex);
            }
            case INT16: {
                return tuple.shortValueBoxed(fieldIndex);
            }
            case INT32: {
                return tuple.intValueBoxed(fieldIndex);
            }
            case INT64: {
                return tuple.longValueBoxed(fieldIndex);
            }
            case FLOAT: {
                return tuple.floatValueBoxed(fieldIndex);
            }
            case DOUBLE: {
                return tuple.doubleValueBoxed(fieldIndex);
            }
            case DECIMAL: {
                return tuple.decimalValue(fieldIndex, ((DecimalNativeType)nativeType).scale());
            }
            case UUID: {
                return tuple.uuidValue(fieldIndex);
            }
            case STRING: {
                return tuple.stringValue(fieldIndex);
            }
            case BYTES: {
                return tuple.bytesValue(fieldIndex);
            }
            case DATE: {
                return tuple.dateValue(fieldIndex);
            }
            case TIME: {
                return tuple.timeValue(fieldIndex);
            }
            case DATETIME: {
                return tuple.dateTimeValue(fieldIndex);
            }
            case TIMESTAMP: {
                return tuple.timestampValue(fieldIndex);
            }
        }
        throw new InvalidTypeException("Unknown element type: " + String.valueOf(nativeType));
    }

    public static IntList maxPrefix(ImmutableIntList seq, Collection<Integer> elems) {
        int e;
        IntArrayList res = new IntArrayList();
        IntOpenHashSet elems0 = new IntOpenHashSet(elems);
        for (int i = 0; i < seq.size() && elems0.remove(e = seq.getInt(i)); ++i) {
            res.add(e);
        }
        return res;
    }

    public static void closeQuiet(@Nullable Object obj) {
        if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Class<?> nativeTypeToClass(NativeType type) {
        assert (type != null);
        switch (type.spec()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case INT8: {
                return Byte.class;
            }
            case INT16: {
                return Short.class;
            }
            case INT32: {
                return Integer.class;
            }
            case INT64: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case UUID: {
                return UUID.class;
            }
            case STRING: {
                return String.class;
            }
            case BYTES: {
                return byte[].class;
            }
            case DATE: {
                return LocalDate.class;
            }
            case TIME: {
                return LocalTime.class;
            }
            case DATETIME: {
                return LocalDateTime.class;
            }
            case TIMESTAMP: {
                return Instant.class;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(type.spec()));
    }

    public static int nativeTypePrecision(NativeType type) {
        assert (type != null);
        switch (type.spec()) {
            case INT8: {
                return 3;
            }
            case INT16: {
                return 5;
            }
            case INT32: {
                return 10;
            }
            case INT64: {
                return 19;
            }
            case FLOAT: 
            case DOUBLE: {
                return 15;
            }
            case DECIMAL: {
                return ((DecimalNativeType)type).precision();
            }
            case BOOLEAN: 
            case UUID: 
            case DATE: {
                return -1;
            }
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                return ((TemporalNativeType)type).precision();
            }
            case STRING: 
            case BYTES: {
                return ((VarlenNativeType)type).length();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(type.spec()));
    }

    public static int nativeTypeScale(NativeType type) {
        switch (type.spec()) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                return 0;
            }
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case UUID: 
            case STRING: 
            case BYTES: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                return Integer.MIN_VALUE;
            }
            case DECIMAL: {
                return ((DecimalNativeType)type).scale();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(type.spec()));
    }

    public static <T> Comparator<T> compoundComparator(Iterable<Comparator<T>> cmps) {
        return (r1, r2) -> {
            for (Comparator cmp : cmps) {
                int result = cmp.compare(r1, r2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        };
    }

    public static RelOptCluster emptyCluster() {
        return PlanningContext.CLUSTER;
    }

    public static RelOptCluster cluster() {
        RelOptCluster emptyCluster = Commons.emptyCluster();
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)emptyCluster.getPlanner(), (RexBuilder)emptyCluster.getRexBuilder());
        cluster.setMetadataProvider(IgniteMetadata.METADATA_PROVIDER);
        cluster.setMetadataQuerySupplier(RelMetadataQueryEx::create);
        return cluster;
    }

    public static boolean implicitPkEnabled() {
        return IgniteSystemProperties.getBoolean((String)"IMPLICIT_PK_ENABLED", (boolean)false);
    }

    public static boolean fastQueryOptimizationEnabled() {
        Boolean enabled = fastOptimizationsEnabled;
        if (enabled == null) {
            fastOptimizationsEnabled = enabled = Boolean.valueOf(IgniteSystemProperties.getBoolean((String)"FAST_QUERY_OPTIMIZATION_ENABLED", (boolean)true));
        }
        return enabled;
    }

    @TestOnly
    public static void resetFastQueryOptimizationFlag() {
        fastOptimizationsEnabled = null;
    }

    public static String shortRuleName(RelOptRule rule) {
        String ruleDescription = rule.toString();
        int pos = ruleDescription.indexOf(40);
        if (pos == -1) {
            return ruleDescription;
        }
        return ruleDescription.substring(0, pos);
    }

    @Nullable
    public static SqlQueryType getQueryType(SqlNode sqlNode) {
        SqlKind sqlKind = sqlNode.getKind();
        if (sqlNode instanceof IgniteSqlStartTransaction || sqlNode instanceof IgniteSqlCommitTransaction) {
            return SqlQueryType.TX_CONTROL;
        }
        if (SqlKind.DDL.contains(sqlKind)) {
            return SqlQueryType.DDL;
        }
        if (sqlNode instanceof IgniteSqlKill) {
            return SqlQueryType.KILL;
        }
        switch (sqlKind) {
            case SELECT: 
            case ORDER_BY: 
            case WITH: 
            case VALUES: 
            case UNION: 
            case EXCEPT: 
            case INTERSECT: {
                return SqlQueryType.QUERY;
            }
            case INSERT: 
            case DELETE: 
            case UPDATE: 
            case MERGE: {
                return SqlQueryType.DML;
            }
            case EXPLAIN: {
                return SqlQueryType.EXPLAIN;
            }
        }
        return null;
    }

    public static List<RelNode> castInputsToLeastRestrictiveTypeIfNeeded(List<RelNode> inputs, RelOptCluster cluster, RelTraitSet traits) {
        List inputRowTypes = inputs.stream().map(RelNode::getRowType).collect(Collectors.toList());
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        RelDataType resultType = typeFactory.leastRestrictive(inputRowTypes);
        if (resultType == null) {
            throw new IllegalArgumentException("Cannot compute compatible row type for arguments to set op: " + String.valueOf(inputRowTypes));
        }
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ArrayList<RelNode> actualInputs = new ArrayList<RelNode>(inputs.size());
        for (RelNode input : inputs) {
            RelDataType inputRowType = input.getRowType();
            if (SqlTypeUtil.equalAsStructSansNullability((RelDataTypeFactory)typeFactory, (RelDataType)resultType, (RelDataType)inputRowType, null)) {
                actualInputs.add(input);
                continue;
            }
            ArrayList<Object> exprs = new ArrayList<Object>(inputRowType.getFieldCount());
            for (int i = 0; i < resultType.getFieldCount(); ++i) {
                RelDataType fieldType = ((RelDataTypeField)inputRowType.getFieldList().get(i)).getType();
                RelDataType outFieldType = ((RelDataTypeField)resultType.getFieldList().get(i)).getType();
                RexInputRef ref = rexBuilder.makeInputRef(input, i);
                if (fieldType.equals((Object)outFieldType)) {
                    exprs.add(ref);
                    continue;
                }
                RexNode expr = rexBuilder.makeCast(outFieldType, (RexNode)ref, true, false);
                exprs.add(expr);
            }
            actualInputs.add((RelNode)new IgniteProject(cluster, traits, input, exprs, resultType));
        }
        return actualInputs;
    }

    public static boolean isMultiStatementQueryAllowed(SqlProperties properties) {
        Set<SqlQueryType> allowedTypes = properties.get(QueryProperty.ALLOWED_QUERY_TYPES);
        return allowedTypes.contains((Object)SqlQueryType.TX_CONTROL);
    }

    @Nullable
    public static Throwable deriveExceptionFromListOfFutures(List<CompletableFuture<?>> futures) {
        Throwable firstFoundError = null;
        for (CompletableFuture<?> fut : futures) {
            assert (fut.isDone());
            if (!fut.isCompletedExceptionally()) continue;
            Throwable fromFuture = ExceptionUtils.unwrapCause((Throwable)((Throwable)((CompletableFuture)fut.handle((ignored, ex) -> ex)).join()));
            if (firstFoundError == null) {
                firstFoundError = fromFuture;
                continue;
            }
            firstFoundError.addSuppressed(fromFuture);
        }
        return firstFoundError;
    }
}

