/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.configuration.schema.PersistentPageMemoryProfileConfiguration;
import org.apache.ignite.internal.pagememory.configuration.schema.PersistentPageMemoryProfileView;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.mem.DirectMemoryProvider;
import org.apache.ignite.internal.pagememory.mem.DirectMemoryRegion;
import org.apache.ignite.internal.pagememory.mem.IgniteOutOfMemoryException;
import org.apache.ignite.internal.pagememory.mem.unsafe.UnsafeMemoryProvider;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.persistence.CheckpointUrgency;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.LoadedPagesMap;
import org.apache.ignite.internal.pagememory.persistence.PageHeader;
import org.apache.ignite.internal.pagememory.persistence.PagePool;
import org.apache.ignite.internal.pagememory.persistence.PageReadWriteManager;
import org.apache.ignite.internal.pagememory.persistence.PageStoreWriter;
import org.apache.ignite.internal.pagememory.persistence.RobinHoodBackwardShiftHashMap;
import org.apache.ignite.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointPages;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.pagememory.persistence.replacement.ClockPageReplacementPolicyFactory;
import org.apache.ignite.internal.pagememory.persistence.replacement.DelayedDirtyPageWrite;
import org.apache.ignite.internal.pagememory.persistence.replacement.DelayedPageReplacementTracker;
import org.apache.ignite.internal.pagememory.persistence.replacement.PageReplacementPolicy;
import org.apache.ignite.internal.pagememory.persistence.replacement.PageReplacementPolicyFactory;
import org.apache.ignite.internal.pagememory.persistence.replacement.RandomLruPageReplacementPolicyFactory;
import org.apache.ignite.internal.pagememory.persistence.replacement.SegmentedLruPageReplacementPolicyFactory;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.OffheapReadWriteLock;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PersistentPageMemory
implements PageMemory {
    private static final IgniteLogger LOG = Loggers.forClass(PersistentPageMemory.class);
    public static final long RELATIVE_PTR_MASK = 0xFFFFFFFFFFFFFFL;
    public static final long INVALID_REL_PTR = 0xFFFFFFFFFFFFFFL;
    public static final long OUTDATED_REL_PTR = 0x100000000000000L;
    public static final int PAGE_LOCK_OFFSET = 32;
    public static final int PAGE_OVERHEAD = 48;
    public static final int TRY_AGAIN_TAG = -1;
    private static final float CP_BUF_FILL_THRESHOLD = 0.6666667f;
    private final PersistentPageMemoryProfileView storageProfileView;
    private final PageIoRegistry ioRegistry;
    private final PageReadWriteManager pageStoreManager;
    private final int sysPageSize;
    private final PageReplacementPolicyFactory pageReplacementPolicyFactory;
    private final DirectMemoryProvider directMemoryProvider;
    @Nullable
    private volatile Segment[] segments;
    private final Object segmentsLock = new Object();
    private final OffheapReadWriteLock rwLock;
    @Nullable
    private final PageChangeTracker changeTracker;
    private static final AtomicIntegerFieldUpdater<PersistentPageMemory> pageReplacementWarnedFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(PersistentPageMemory.class, "pageReplacementWarned");
    private volatile int pageReplacementWarned;
    private final long[] sizes;
    private volatile boolean started;
    private final AtomicReference<CheckpointUrgency> checkpointUrgency = new AtomicReference<CheckpointUrgency>(CheckpointUrgency.NOT_REQUIRED);
    @Nullable
    private volatile PagePool checkpointPool;
    private final DelayedPageReplacementTracker delayedPageReplacementTracker;
    private final CheckpointTimeoutLock checkpointTimeoutLock;

    public PersistentPageMemory(PersistentPageMemoryProfileConfiguration storageProfileConfiguration, PageIoRegistry ioRegistry, long[] segmentSizes, long checkpointBufferSize, PageReadWriteManager pageStoreManager, @Nullable PageChangeTracker changeTracker, WriteDirtyPage flushDirtyPageForReplacement, CheckpointTimeoutLock checkpointTimeoutLock, int pageSize, OffheapReadWriteLock rwLock) {
        String replacementMode;
        this.storageProfileView = (PersistentPageMemoryProfileView)storageProfileConfiguration.value();
        this.ioRegistry = ioRegistry;
        this.sizes = ArrayUtils.concat((long[])segmentSizes, (long[])new long[]{checkpointBufferSize});
        this.pageStoreManager = pageStoreManager;
        this.changeTracker = changeTracker;
        this.checkpointTimeoutLock = checkpointTimeoutLock;
        this.directMemoryProvider = new UnsafeMemoryProvider(null);
        this.sysPageSize = pageSize + 48;
        this.rwLock = rwLock;
        switch (replacementMode = this.storageProfileView.replacementMode()) {
            case "RANDOM_LRU": {
                this.pageReplacementPolicyFactory = new RandomLruPageReplacementPolicyFactory();
                break;
            }
            case "SEGMENTED_LRU": {
                this.pageReplacementPolicyFactory = new SegmentedLruPageReplacementPolicyFactory();
                break;
            }
            case "CLOCK": {
                this.pageReplacementPolicyFactory = new ClockPageReplacementPolicyFactory();
                break;
            }
            default: {
                throw new IgniteInternalException("Unexpected page replacement mode: " + replacementMode);
            }
        }
        this.delayedPageReplacementTracker = new DelayedPageReplacementTracker(pageSize, flushDirtyPageForReplacement, LOG, this.sizes.length - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IgniteInternalException {
        Object object = this.segmentsLock;
        synchronized (object) {
            DirectMemoryRegion reg;
            if (this.started) {
                return;
            }
            this.started = true;
            this.directMemoryProvider.initialize(this.sizes);
            ArrayList<DirectMemoryRegion> regions = new ArrayList<DirectMemoryRegion>(this.sizes.length);
            while ((reg = this.directMemoryProvider.nextRegion()) != null) {
                regions.add(reg);
            }
            int regs = regions.size();
            Segment[] segments = new Segment[regs - 1];
            DirectMemoryRegion checkpointRegion = (DirectMemoryRegion)regions.get(regs - 1);
            this.checkpointPool = new PagePool(regs - 1, checkpointRegion, this.sysPageSize, this.rwLock);
            long checkpointBufferSize = checkpointRegion.size();
            long totalAllocated = 0L;
            int pages = 0;
            long totalTblSize = 0L;
            long totalReplSize = 0L;
            for (int i = 0; i < regs - 1; ++i) {
                assert (i < segments.length);
                DirectMemoryRegion reg2 = (DirectMemoryRegion)regions.get(i);
                totalAllocated += reg2.size();
                segments[i] = new Segment(i, (DirectMemoryRegion)regions.get(i));
                pages += segments[i].pages();
                totalTblSize += segments[i].tableSize();
                totalReplSize += segments[i].replacementSize();
            }
            this.segments = segments;
            if (LOG.isInfoEnabled()) {
                LOG.info("Started page memory [profile='{}', memoryAllocated={}, pages={}, tableSize={}, replacementSize={}, checkpointBuffer={}]", new Object[]{this.storageProfileView.name(), IgniteUtils.readableSize((long)totalAllocated, (boolean)false), pages, IgniteUtils.readableSize((long)totalTblSize, (boolean)false), IgniteUtils.readableSize((long)totalReplSize, (boolean)false), IgniteUtils.readableSize((long)checkpointBufferSize, (boolean)false)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean deallocate) throws IgniteInternalException {
        Object object = this.segmentsLock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            LOG.debug("Stopping page memory", new Object[0]);
            if (this.segments != null) {
                for (Segment seg : this.segments) {
                    seg.close();
                }
            }
            this.started = false;
            this.directMemoryProvider.shutdown(deallocate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePage(int grpId, long pageId, long page) {
        assert (this.started);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            seg.releasePage(page);
        }
        finally {
            seg.readLock().unlock();
        }
    }

    @Override
    public long readLock(int grpId, long pageId, long page) {
        assert (this.started);
        return this.readLock(page, pageId, false);
    }

    public long readLock(long absPtr, long pageId, boolean force, boolean touch) {
        assert (this.started);
        int tag = force ? -1 : PageIdUtils.tag(pageId);
        boolean locked = this.rwLock.readLock(absPtr + 32L, tag);
        if (!locked) {
            return 0L;
        }
        if (touch) {
            PageHeader.writeTimestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
        }
        assert (PageIo.getCrc(absPtr + 48L) == 0);
        return absPtr + 48L;
    }

    private long readLock(long absPtr, long pageId, boolean force) {
        return this.readLock(absPtr, pageId, force, true);
    }

    @Override
    public void readUnlock(int grpId, long pageId, long page) {
        assert (this.started);
        this.readUnlockPage(page);
    }

    @Override
    public long writeLock(int grpId, long pageId, long page) {
        assert (this.started);
        return this.writeLock(grpId, pageId, page, false);
    }

    public long writeLock(int grpId, long pageId, long page, boolean restore) {
        assert (this.started);
        return this.writeLockPage(page, new FullPageId(pageId, grpId), !restore);
    }

    @Override
    public long tryWriteLock(int grpId, long pageId, long page) {
        assert (this.started);
        return this.tryWriteLockPage(page, new FullPageId(pageId, grpId), true);
    }

    @Override
    public void writeUnlock(int grpId, long pageId, long page, boolean dirtyFlag) {
        assert (this.started);
        this.writeUnlock(grpId, pageId, page, dirtyFlag, false);
    }

    public void writeUnlock(int grpId, long pageId, long page, boolean dirtyFlag, boolean restore) {
        assert (this.started);
        this.writeUnlockPage(page, new FullPageId(pageId, grpId), dirtyFlag, restore);
    }

    @Override
    public boolean isDirty(int grpId, long pageId, long page) {
        assert (this.started);
        return this.isDirty(page);
    }

    boolean isDirty(long absPtr) {
        return PageHeader.dirty(absPtr);
    }

    @Override
    public long allocatePageNoReuse(int grpId, int partId, byte flags) throws IgniteInternalCheckedException {
        assert (partId >= 0 && partId <= 65500) : partId;
        assert (this.started);
        assert (this.checkpointTimeoutLock.checkpointLockIsHeldByThread());
        long pageId = this.pageStoreManager.allocatePage(grpId, partId, flags);
        Segment seg = this.segment(grpId, pageId);
        seg.writeLock().lock();
        try {
            FullPageId fullId = new FullPageId(pageId, grpId);
            long relPtr = seg.loadedPages.get(grpId, PageIdUtils.effectivePageId(pageId), seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
            if (relPtr == 0x100000000000000L) {
                relPtr = seg.refreshOutdatedPage(grpId, pageId, false);
                seg.pageReplacementPolicy.onRemove(relPtr);
            }
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.borrowOrAllocateFreePage(pageId);
            }
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.removePageForReplacement();
            }
            long absPtr = seg.absolute(relPtr);
            GridUnsafe.zeroMemory((long)(absPtr + 48L), (long)this.pageSize());
            PageHeader.fullPageId(absPtr, fullId);
            PageHeader.writeTimestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
            this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
            assert (PageIo.getCrc(absPtr + 48L) == 0);
            assert (!PageHeader.isAcquired(absPtr)) : "Pin counter must be 0 for a new page [relPtr=" + StringUtils.hexLong((long)relPtr) + ", absPtr=" + StringUtils.hexLong((long)absPtr) + ", pinCntr=" + PageHeader.pinCount(absPtr) + "]";
            this.setDirty(fullId, absPtr, true, true);
            seg.pageReplacementPolicy.onMiss(relPtr);
            seg.loadedPages.put(grpId, PageIdUtils.effectivePageId(pageId), relPtr, seg.partGeneration(grpId, partId));
        }
        catch (IgniteOutOfMemoryException oom) {
            IgniteOutOfMemoryException e = new IgniteOutOfMemoryException("Out of memory in data region [name=" + this.storageProfileView.name() + ", size=" + IgniteUtils.readableSize((long)this.storageProfileView.size(), (boolean)false) + ", persistence=true] Try the following:" + System.lineSeparator() + "  ^-- Increase maximum off-heap memory size (PersistentPageMemoryProfileConfigurationSchema.size)" + System.lineSeparator() + "  ^-- Enable eviction or expiration policies");
            e.initCause((Throwable)((Object)oom));
            throw e;
        }
        finally {
            seg.writeLock().unlock();
            this.delayedPageReplacementTracker.delayedPageWrite().flushCopiedPageIfExists();
        }
        return pageId;
    }

    @Override
    public ByteBuffer pageBuffer(long pageAddr) {
        return GridUnsafe.wrapPointer((long)pageAddr, (int)this.pageSize());
    }

    @Override
    public boolean freePage(int grpId, long pageId) {
        assert (false) : "Free page should be never called directly when persistence is enabled.";
        return false;
    }

    @Override
    public long acquirePage(int grpId, long pageId) throws IgniteInternalCheckedException {
        return this.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, false);
    }

    @Override
    public long acquirePage(int grpId, long pageId, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        return this.acquirePage(grpId, pageId, statHolder, false);
    }

    public long acquirePage(int grpId, long pageId, AtomicBoolean pageAllocated) throws IgniteInternalCheckedException {
        return this.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, false, pageAllocated);
    }

    public long acquirePage(int grpId, long pageId, IoStatisticsHolder statHolder, boolean restore) throws IgniteInternalCheckedException {
        return this.acquirePage(grpId, pageId, statHolder, restore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long acquirePage(int grpId, long pageId, IoStatisticsHolder statHolder, boolean restore, @Nullable AtomicBoolean pageAllocated) throws IgniteInternalCheckedException {
        long l;
        assert (this.started);
        assert (PageIdUtils.pageIndex(pageId) != 0) : "Partition meta should should not be read through PageMemory so as not to occupy memory.";
        int partId = PageIdUtils.partitionId(pageId);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            long relPtr = seg.loadedPages.get(grpId, PageIdUtils.effectivePageId(pageId), seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL);
            if (relPtr != 0xFFFFFFFFFFFFFFL) {
                long absPtr = seg.absolute(relPtr);
                seg.acquirePage(absPtr);
                seg.pageReplacementPolicy.onHit(relPtr);
                statHolder.trackLogicalRead(absPtr + 48L);
                long l2 = absPtr;
                return l2;
            }
        }
        finally {
            seg.readLock().unlock();
        }
        FullPageId fullId = new FullPageId(pageId, grpId);
        seg.writeLock().lock();
        long lockedPageAbsPtr = -1L;
        boolean readPageFromStore = false;
        try {
            long pageAddr;
            long absPtr;
            long relPtr = seg.loadedPages.get(grpId, fullId.effectivePageId(), seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.borrowOrAllocateFreePage(pageId);
                if (pageAllocated != null) {
                    pageAllocated.set(true);
                }
                if (relPtr == 0xFFFFFFFFFFFFFFL) {
                    relPtr = seg.removePageForReplacement();
                }
                absPtr = seg.absolute(relPtr);
                PageHeader.fullPageId(absPtr, fullId);
                PageHeader.writeTimestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
                assert (!PageHeader.isAcquired(absPtr)) : "Pin counter must be 0 for a new page [relPtr=" + StringUtils.hexLong((long)relPtr) + ", absPtr=" + StringUtils.hexLong((long)absPtr) + "]";
                this.setDirty(fullId, absPtr, false, false);
                seg.pageReplacementPolicy.onMiss(relPtr);
                seg.loadedPages.put(grpId, fullId.effectivePageId(), relPtr, seg.partGeneration(grpId, partId));
                pageAddr = absPtr + 48L;
                if (!restore) {
                    this.delayedPageReplacementTracker.waitUnlock(fullId);
                    readPageFromStore = true;
                } else {
                    GridUnsafe.zeroMemory((long)(absPtr + 48L), (long)this.pageSize());
                    PageIo.setPageId(pageAddr, pageId);
                }
                this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
                if (readPageFromStore) {
                    boolean locked = this.rwLock.writeLock(absPtr + 32L, -1);
                    assert (locked) : "Page ID " + String.valueOf(fullId) + " expected to be locked";
                    lockedPageAbsPtr = absPtr;
                }
            } else if (relPtr == 0x100000000000000L) {
                assert (PageIdUtils.pageIndex(pageId) == 0) : fullId;
                relPtr = seg.refreshOutdatedPage(grpId, pageId, false);
                absPtr = seg.absolute(relPtr);
                pageAddr = absPtr + 48L;
                GridUnsafe.zeroMemory((long)pageAddr, (long)this.pageSize());
                PageHeader.fullPageId(absPtr, fullId);
                PageHeader.writeTimestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
                PageIo.setPageId(pageAddr, pageId);
                assert (!PageHeader.isAcquired(absPtr)) : "Pin counter must be 0 for a new page [relPtr=" + StringUtils.hexLong((long)relPtr) + ", absPtr=" + StringUtils.hexLong((long)absPtr) + "]";
                this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
                seg.pageReplacementPolicy.onRemove(relPtr);
                seg.pageReplacementPolicy.onMiss(relPtr);
            } else {
                absPtr = seg.absolute(relPtr);
                seg.pageReplacementPolicy.onHit(relPtr);
            }
            seg.acquirePage(absPtr);
            if (!readPageFromStore) {
                statHolder.trackLogicalRead(absPtr + 48L);
            }
            l = absPtr;
            seg.writeLock().unlock();
        }
        catch (Throwable throwable) {
            seg.writeLock().unlock();
            this.delayedPageReplacementTracker.delayedPageWrite().flushCopiedPageIfExists();
            if (readPageFromStore) {
                assert (lockedPageAbsPtr != -1L) : "Page is expected to have a valid address [pageId=" + String.valueOf(fullId) + ", lockedPageAbsPtr=" + StringUtils.hexLong((long)lockedPageAbsPtr) + "]";
                assert (this.isPageWriteLocked(lockedPageAbsPtr)) : "Page is expected to be locked: [pageId=" + String.valueOf(fullId) + "]";
                long pageAddr = lockedPageAbsPtr + 48L;
                ByteBuffer buf = GridUnsafe.wrapPointer((long)pageAddr, (int)this.pageSize());
                long actualPageId = 0L;
                try {
                    this.pageStoreManager.read(grpId, pageId, buf, false);
                    statHolder.trackPhysicalAndLogicalRead(pageAddr);
                    actualPageId = PageIo.getPageId(buf);
                    this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                }
                catch (Throwable throwable2) {
                    this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                    throw throwable2;
                }
            }
            throw throwable;
        }
        this.delayedPageReplacementTracker.delayedPageWrite().flushCopiedPageIfExists();
        if (readPageFromStore) {
            assert (lockedPageAbsPtr != -1L) : "Page is expected to have a valid address [pageId=" + String.valueOf(fullId) + ", lockedPageAbsPtr=" + StringUtils.hexLong((long)lockedPageAbsPtr) + "]";
            assert (this.isPageWriteLocked(lockedPageAbsPtr)) : "Page is expected to be locked: [pageId=" + String.valueOf(fullId) + "]";
            long pageAddr = lockedPageAbsPtr + 48L;
            ByteBuffer buf = GridUnsafe.wrapPointer((long)pageAddr, (int)this.pageSize());
            long actualPageId = 0L;
            try {
                this.pageStoreManager.read(grpId, pageId, buf, false);
                statHolder.trackPhysicalAndLogicalRead(pageAddr);
                actualPageId = PageIo.getPageId(buf);
                this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
            }
            catch (Throwable throwable) {
                this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                throw throwable;
            }
        }
        return l;
    }

    @Override
    public int pageSize() {
        return this.sysPageSize - 48;
    }

    @Override
    public int systemPageSize() {
        return this.sysPageSize;
    }

    @Override
    public int realPageSize(int grpId) {
        return this.pageSize();
    }

    public long totalPages() {
        if (this.segments == null) {
            return 0L;
        }
        long res = 0L;
        for (Segment segment : this.segments) {
            res += (long)segment.pages();
        }
        return res;
    }

    private void copyInBuffer(long absPtr, ByteBuffer tmpBuf) {
        if (tmpBuf.isDirect()) {
            long tmpPtr = GridUnsafe.bufferAddress((ByteBuffer)tmpBuf);
            GridUnsafe.copyMemory((long)(absPtr + 48L), (long)tmpPtr, (long)this.pageSize());
            assert (PageIo.getCrc(absPtr + 48L) == 0);
            assert (PageIo.getCrc(tmpPtr) == 0);
        } else {
            byte[] arr = tmpBuf.array();
            assert (arr.length == this.pageSize());
            GridUnsafe.copyMemory(null, (long)(absPtr + 48L), (Object)arr, (long)GridUnsafe.BYTE_ARR_OFF, (long)this.pageSize());
        }
    }

    private int generationTag(Segment seg, FullPageId fullPageId) {
        return seg.partGeneration(fullPageId.groupId(), PageIdUtils.partitionId(fullPageId.pageId()));
    }

    private long resolveRelativePointer(Segment seg, FullPageId fullId, int reqVer) {
        return seg.loadedPages.get(fullId.groupId(), fullId.effectivePageId(), reqVer, 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invalidate(int grpId, int partId) {
        Object object = this.segmentsLock;
        synchronized (object) {
            if (!this.started) {
                return 0;
            }
            int tag = 0;
            for (Segment segment : this.segments) {
                segment.writeLock().lock();
                try {
                    int newTag = segment.incrementPartGeneration(grpId, partId);
                    if (tag == 0) {
                        tag = newTag;
                    }
                    if ($assertionsDisabled || tag == newTag) continue;
                    throw new AssertionError();
                }
                finally {
                    segment.writeLock().unlock();
                }
            }
            return tag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGroupDestroyed(int grpId) {
        for (Segment seg : this.segments) {
            seg.writeLock().lock();
            try {
                seg.resetGroupPartitionsGeneration(grpId);
            }
            finally {
                seg.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long loadedPages() {
        long total = 0L;
        Segment[] segments = this.segments;
        if (segments != null) {
            for (Segment seg : segments) {
                if (seg == null) break;
                seg.readLock().lock();
                try {
                    if (seg.closed) continue;
                    total += (long)seg.loadedPages.size();
                }
                finally {
                    seg.readLock().unlock();
                }
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquiredPages() {
        if (this.segments == null) {
            return 0L;
        }
        long total = 0L;
        for (Segment seg : this.segments) {
            seg.readLock().lock();
            try {
                if (seg.closed) continue;
                total += (long)seg.acquiredPages();
            }
            finally {
                seg.readLock().unlock();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLoadedPage(FullPageId fullPageId) {
        int grpId = fullPageId.groupId();
        long pageId = fullPageId.effectivePageId();
        int partId = PageIdUtils.partitionId(pageId);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            long res = seg.loadedPages.get(grpId, pageId, seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL);
            boolean bl = res != 0xFFFFFFFFFFFFFFL;
            return bl;
        }
        finally {
            seg.readLock().unlock();
        }
    }

    @Override
    public long readLockForce(int grpId, long pageId, long page) {
        assert (this.started);
        return this.readLock(page, pageId, true);
    }

    void readUnlockPage(long absPtr) {
        this.rwLock.readUnlock(absPtr + 32L);
    }

    public boolean hasTempCopy(long absPtr) {
        return PageHeader.tempBufferPointer(absPtr) != 0xFFFFFFFFFFFFFFL;
    }

    private long tryWriteLockPage(long absPtr, FullPageId fullId, boolean checkTag) {
        int tag = checkTag ? PageIdUtils.tag(fullId.pageId()) : -1;
        return !this.rwLock.tryWriteLock(absPtr + 32L, tag) ? 0L : this.postWriteLockPage(absPtr, fullId);
    }

    private long writeLockPage(long absPtr, FullPageId fullId, boolean checkTag) {
        int tag = checkTag ? PageIdUtils.tag(fullId.pageId()) : -1;
        boolean locked = this.rwLock.writeLock(absPtr + 32L, tag);
        return locked ? this.postWriteLockPage(absPtr, fullId) : 0L;
    }

    private long postWriteLockPage(long absPtr, FullPageId fullId) {
        PageHeader.writeTimestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
        if (this.isInCheckpoint(fullId) && PageHeader.tempBufferPointer(absPtr) == 0xFFFFFFFFFFFFFFL) {
            long tmpRelPtr;
            PagePool checkpointPool = this.checkpointPool;
            while ((tmpRelPtr = checkpointPool.borrowOrAllocateFreePage(PageIdUtils.tag(fullId.pageId()))) == 0xFFFFFFFFFFFFFFL) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            PageHeader.acquirePage(absPtr);
            long tmpAbsPtr = checkpointPool.absolute(tmpRelPtr);
            GridUnsafe.copyMemory(null, (long)(absPtr + 48L), null, (long)(tmpAbsPtr + 48L), (long)this.pageSize());
            assert (PageIo.getType(tmpAbsPtr + 48L) != 0) : "Invalid state. Type is 0! pageId = " + StringUtils.hexLong((long)fullId.pageId());
            assert (PageIo.getVersion(tmpAbsPtr + 48L) != 0) : "Invalid state. Version is 0! pageId = " + StringUtils.hexLong((long)fullId.pageId());
            PageHeader.dirty(absPtr, false);
            PageHeader.tempBufferPointer(absPtr, tmpRelPtr);
            PageHeader.fullPageId(tmpAbsPtr, fullId);
            assert (PageIo.getCrc(absPtr + 48L) == 0);
            assert (PageIo.getCrc(tmpAbsPtr + 48L) == 0);
        }
        assert (PageIo.getCrc(absPtr + 48L) == 0);
        return absPtr + 48L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnlockPage(long page, FullPageId fullId, boolean markDirty, boolean restore) {
        block14: {
            boolean wasDirty = this.isDirty(page);
            try {
                if (!restore && markDirty && !wasDirty && this.changeTracker != null) {
                    this.changeTracker.apply(page, fullId, this);
                }
                assert (PageIo.getCrc(page + 48L) == 0);
                if (!markDirty) break block14;
                this.setDirty(fullId, page, true, false);
            }
            catch (Throwable throwable) {
                long pageId = PageIo.getPageId(page + 48L);
                try {
                    assert (pageId != 0L) : StringUtils.hexLong((long)PageHeader.readPageId(page));
                    this.rwLock.writeUnlock(page + 32L, PageIdUtils.tag(pageId));
                    assert (PageIo.getVersion(page + 48L) != 0) : this.dumpPage(pageId, fullId.groupId());
                    assert (PageIo.getType(page + 48L) != 0) : StringUtils.hexLong((long)pageId);
                }
                catch (AssertionError ex) {
                    LOG.debug("Failed to unlock page [fullPageId={}, binPage={}]", new Object[]{fullId, StringUtils.toHexString((long)page, (int)this.systemPageSize())});
                    throw ex;
                }
                throw throwable;
            }
        }
        long pageId = PageIo.getPageId(page + 48L);
        try {
            assert (pageId != 0L) : StringUtils.hexLong((long)PageHeader.readPageId(page));
            this.rwLock.writeUnlock(page + 32L, PageIdUtils.tag(pageId));
            assert (PageIo.getVersion(page + 48L) != 0) : this.dumpPage(pageId, fullId.groupId());
            assert (PageIo.getType(page + 48L) != 0) : StringUtils.hexLong((long)pageId);
        }
        catch (AssertionError ex) {
            LOG.debug("Failed to unlock page [fullPageId={}, binPage={}]", new Object[]{fullId, StringUtils.toHexString((long)page, (int)this.systemPageSize())});
            throw ex;
        }
    }

    private String dumpPage(long pageId, int grpId) {
        int pageIdx = PageIdUtils.pageIndex(pageId);
        int partId = PageIdUtils.partitionId(pageId);
        long off = (long)(pageIdx + 1) * (long)this.pageSize();
        return StringUtils.hexLong((long)pageId) + " (grpId=" + grpId + ", pageIdx=" + pageIdx + ", partId=" + partId + ", offH=" + Long.toHexString(off) + ")";
    }

    boolean isPageWriteLocked(long absPtr) {
        return this.rwLock.isWriteLocked(absPtr + 32L);
    }

    boolean isPageReadLocked(long absPtr) {
        return this.rwLock.isReadLocked(absPtr + 32L);
    }

    public int activePagesCount() {
        if (this.segments == null) {
            return 0;
        }
        int total = 0;
        for (Segment seg : this.segments) {
            total += seg.acquiredPages();
        }
        return total;
    }

    private void setDirty(FullPageId pageId, long absPtr, boolean dirty, boolean forceAdd) {
        boolean wasDirty = PageHeader.dirty(absPtr, dirty);
        if (dirty) {
            assert (this.checkpointTimeoutLock.checkpointLockIsHeldByThread());
            assert (PageIdUtils.pageIndex(pageId.pageId()) != 0) : "Partition meta should only be updated via the instance of PartitionMeta.";
            if (!wasDirty || forceAdd) {
                CheckpointUrgency urgency;
                long dirtyPagesCnt;
                Segment seg = this.segment(pageId.groupId(), pageId.pageId());
                if (seg.dirtyPages.add(pageId) && (dirtyPagesCnt = seg.dirtyPagesCntr.incrementAndGet()) >= seg.dirtyPagesSoftThreshold && (urgency = this.checkpointUrgency.get()) != CheckpointUrgency.MUST_TRIGGER) {
                    if (dirtyPagesCnt >= seg.dirtyPagesHardThreshold) {
                        this.checkpointUrgency.set(CheckpointUrgency.MUST_TRIGGER);
                    } else if (urgency != CheckpointUrgency.SHOULD_TRIGGER) {
                        this.checkpointUrgency.compareAndSet(CheckpointUrgency.NOT_REQUIRED, CheckpointUrgency.SHOULD_TRIGGER);
                    }
                }
            }
        } else {
            Segment seg = this.segment(pageId.groupId(), pageId.pageId());
            if (seg.dirtyPages.remove(pageId)) {
                seg.dirtyPagesCntr.decrementAndGet();
            }
        }
    }

    private Segment segment(int grpId, long pageId) {
        int idx = PersistentPageMemory.segmentIndex(grpId, pageId, this.segments.length);
        return this.segments[idx];
    }

    public static int segmentIndex(int grpId, long pageId, int segments) {
        pageId = PageIdUtils.effectivePageId(pageId);
        int hash = IgniteUtils.hash((long)(pageId * 65537L + (long)grpId));
        return IgniteUtils.safeAbs((int)hash) % segments;
    }

    @TestOnly
    public Set<FullPageId> dirtyPages() {
        if (this.segments == null) {
            return Set.of();
        }
        HashSet<FullPageId> res = new HashSet<FullPageId>((int)this.loadedPages());
        for (Segment seg : this.segments) {
            res.addAll(seg.dirtyPages);
        }
        return res;
    }

    private static int updateAtomicInt(long ptr, int delta) {
        int updated;
        int old;
        while (!GridUnsafe.compareAndSwapInt(null, (long)ptr, (int)(old = GridUnsafe.getInt((long)ptr)), (int)(updated = old + delta))) {
        }
        return updated;
    }

    private static long updateAtomicLong(long ptr, long delta) {
        long updated;
        long old;
        while (!GridUnsafe.compareAndSwapLong(null, (long)ptr, (long)(old = GridUnsafe.getLong((long)ptr)), (long)(updated = old + delta))) {
        }
        return updated;
    }

    @Override
    public PageIoRegistry ioRegistry() {
        return this.ioRegistry;
    }

    public CheckpointUrgency checkpointUrgency() {
        return this.checkpointUrgency.get();
    }

    public int usedCheckpointBufferPages() {
        PagePool checkpointPool = this.checkpointPool;
        return checkpointPool == null ? 0 : checkpointPool.size();
    }

    public int maxCheckpointBufferPages() {
        PagePool checkpointPool = this.checkpointPool;
        return checkpointPool == null ? 0 : checkpointPool.pages();
    }

    private void releaseCheckpointBufferPage(long tmpBufPtr) {
        this.checkpointPool.releaseFreePage(tmpBufPtr);
    }

    boolean isInCheckpoint(FullPageId pageId) {
        Segment seg = this.segment(pageId.groupId(), pageId.pageId());
        CheckpointPages pages0 = seg.checkpointPages;
        return pages0 != null && pages0.contains(pageId);
    }

    private boolean removeOnCheckpoint(FullPageId fullPageId) {
        Segment seg = this.segment(fullPageId.groupId(), fullPageId.pageId());
        CheckpointPages pages0 = seg.checkpointPages;
        assert (pages0 != null) : fullPageId;
        return pages0.removeOnCheckpoint(fullPageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPageForCheckpoint(long absPtr, FullPageId fullId, ByteBuffer buf, int tag, boolean pageSingleAcquire, PageStoreWriter pageStoreWriter, CheckpointMetricsTracker tracker) throws IgniteInternalCheckedException {
        assert (absPtr != 0L);
        assert (PageHeader.isAcquired(absPtr) || !this.isInCheckpoint(fullId));
        boolean canWrite = false;
        boolean locked = this.rwLock.tryWriteLock(absPtr + 32L, -1);
        if (!locked) {
            if (!pageSingleAcquire) {
                PageHeader.releasePage(absPtr);
            }
            buf.clear();
            if (this.isInCheckpoint(fullId)) {
                pageStoreWriter.writePage(fullId, buf, -1);
            }
            return;
        }
        if (!this.removeOnCheckpoint(fullId)) {
            this.rwLock.writeUnlock(absPtr + 32L, -1);
            if (!pageSingleAcquire) {
                PageHeader.releasePage(absPtr);
            }
            return;
        }
        try {
            long tmpRelPtr = PageHeader.tempBufferPointer(absPtr);
            if (tmpRelPtr != 0xFFFFFFFFFFFFFFL) {
                PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
                long tmpAbsPtr = this.checkpointPool.absolute(tmpRelPtr);
                this.copyInBuffer(tmpAbsPtr, buf);
                PageHeader.fullPageId(tmpAbsPtr, FullPageId.NULL_PAGE);
                GridUnsafe.zeroMemory((long)(tmpAbsPtr + 48L), (long)this.pageSize());
                tracker.onCopyOnWritePageWritten();
                this.releaseCheckpointBufferPage(tmpRelPtr);
                if (!pageSingleAcquire) {
                    PageHeader.releasePage(absPtr);
                }
            } else {
                this.copyInBuffer(absPtr, buf);
                PageHeader.dirty(absPtr, false);
            }
            assert (PageIo.getType(buf) != 0) : "Invalid state. Type is 0! pageId = " + StringUtils.hexLong((long)fullId.pageId());
            assert (PageIo.getVersion(buf) != 0) : "Invalid state. Version is 0! pageId = " + StringUtils.hexLong((long)fullId.pageId());
            canWrite = true;
        }
        finally {
            this.rwLock.writeUnlock(absPtr + 32L, -1);
            if (canWrite) {
                buf.rewind();
                pageStoreWriter.writePage(fullId, buf, tag);
                buf.rewind();
            }
            PageHeader.releasePage(absPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointWritePage(FullPageId fullId, ByteBuffer buf, PageStoreWriter pageStoreWriter, CheckpointMetricsTracker tracker) throws IgniteInternalCheckedException {
        long relPtr;
        int tag;
        assert (buf.remaining() == this.pageSize()) : buf.remaining();
        Segment seg = this.segment(fullId.groupId(), fullId.pageId());
        long absPtr = 0L;
        boolean pageSingleAcquire = false;
        seg.readLock().lock();
        try {
            if (!this.isInCheckpoint(fullId)) {
                return;
            }
            tag = this.generationTag(seg, fullId);
            relPtr = this.resolveRelativePointer(seg, fullId, tag);
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                return;
            }
            if (relPtr != 0x100000000000000L) {
                absPtr = seg.absolute(relPtr);
                if (PageHeader.tempBufferPointer(absPtr) == 0xFFFFFFFFFFFFFFL) {
                    PageHeader.acquirePage(absPtr);
                } else {
                    pageSingleAcquire = true;
                }
            }
        }
        finally {
            seg.readLock().unlock();
        }
        if (relPtr == 0x100000000000000L) {
            seg.writeLock().lock();
            try {
                relPtr = this.resolveRelativePointer(seg, fullId, this.generationTag(seg, fullId));
                if (relPtr == 0xFFFFFFFFFFFFFFL) {
                    return;
                }
                if (relPtr == 0x100000000000000L) {
                    relPtr = seg.refreshOutdatedPage(fullId.groupId(), fullId.effectivePageId(), true);
                    seg.pageReplacementPolicy.onRemove(relPtr);
                    seg.pool.releaseFreePage(relPtr);
                }
                return;
            }
            finally {
                seg.writeLock().unlock();
            }
        }
        this.copyPageForCheckpoint(absPtr, fullId, buf, tag, pageSingleAcquire, pageStoreWriter, tracker);
    }

    public FullPageId pullPageFromCpBuffer() {
        long idx = GridUnsafe.getLong((long)this.checkpointPool.lastAllocatedIdxPtr);
        long lastIdx = ThreadLocalRandom.current().nextLong(idx / 2L, idx);
        while (--lastIdx > 1L) {
            assert ((lastIdx & 0xFFFFFF0000000000L) == 0L);
            long relative = this.checkpointPool.relative(lastIdx);
            long freePageAbsPtr = this.checkpointPool.absolute(relative);
            FullPageId fullPageId = PageHeader.fullPageId(freePageAbsPtr);
            if (fullPageId.pageId() == FullPageId.NULL_PAGE.pageId() || fullPageId.groupId() == FullPageId.NULL_PAGE.groupId() || !this.isInCheckpoint(fullPageId)) continue;
            return fullPageId;
        }
        return FullPageId.NULL_PAGE;
    }

    public Collection<FullPageId> beginCheckpoint(CheckpointProgress checkpointProgress) throws IgniteInternalException {
        if (this.segments == null) {
            return List.of();
        }
        Collection[] dirtyPageIds = new Set[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            Set<FullPageId> segmentDirtyPages;
            Segment segment = this.segments[i];
            assert (segment.checkpointPages == null) : String.format("Failed to begin checkpoint (it is already in progress): [storageProfile=%s, segmentIdx=%s]", this.storageProfileView.name(), i);
            dirtyPageIds[i] = segmentDirtyPages = segment.dirtyPages;
            segment.checkpointPages = new CheckpointPages(segmentDirtyPages, checkpointProgress);
            segment.resetDirtyPages();
        }
        this.checkpointUrgency.set(CheckpointUrgency.NOT_REQUIRED);
        return CollectionUtils.concat((Collection[])dirtyPageIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCheckpoint() {
        if (this.segments == null) {
            return;
        }
        Object object = this.segmentsLock;
        synchronized (object) {
            for (Segment seg : this.segments) {
                seg.checkpointPages = null;
            }
        }
    }

    public boolean isCpBufferOverflowThresholdExceeded() {
        assert (this.started);
        PagePool checkpointPool = this.checkpointPool;
        int checkpointBufLimit = (int)((float)checkpointPool.pages() * 0.6666667f);
        return checkpointPool.size() > checkpointBufLimit;
    }

    @TestOnly
    public boolean pageReplacementOccurred() {
        return this.pageReplacementWarned > 0;
    }

    @FunctionalInterface
    public static interface PageChangeTracker {
        public void apply(long var1, FullPageId var3, PersistentPageMemory var4);
    }

    public class Segment
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 0L;
        private static final int ACQUIRED_PAGES_SIZEOF = 4;
        private static final int ACQUIRED_PAGES_PADDING = 4;
        private final LoadedPagesMap loadedPages;
        private final long acquiredPagesPtr;
        private final PagePool pool;
        private final PageReplacementPolicy pageReplacementPolicy;
        private final long memPerTbl;
        private long memPerRepl;
        private volatile Set<FullPageId> dirtyPages = ConcurrentHashMap.newKeySet();
        private final AtomicLong dirtyPagesCntr = new AtomicLong();
        @Nullable
        private volatile CheckpointPages checkpointPages;
        private final long dirtyPagesSoftThreshold;
        private final long dirtyPagesHardThreshold;
        private static final int INIT_PART_GENERATION = 1;
        private final Map<GroupPartitionId, Integer> partGenerationMap = new HashMap<GroupPartitionId, Integer>();
        private boolean closed;

        private Segment(int idx, DirectMemoryRegion region) {
            long totalMemory = region.size();
            int pages = (int)(totalMemory / (long)PersistentPageMemory.this.sysPageSize);
            this.acquiredPagesPtr = region.address();
            GridUnsafe.putIntVolatile(null, (long)this.acquiredPagesPtr, (int)0);
            int ldPagesMapOffInRegion = 8;
            long ldPagesAddr = region.address() + (long)ldPagesMapOffInRegion;
            this.memPerTbl = RobinHoodBackwardShiftHashMap.requiredMemory(pages);
            this.loadedPages = new RobinHoodBackwardShiftHashMap(ldPagesAddr, this.memPerTbl);
            pages = (int)((totalMemory - this.memPerTbl - (long)ldPagesMapOffInRegion) / (long)PersistentPageMemory.this.sysPageSize);
            this.memPerRepl = PersistentPageMemory.this.pageReplacementPolicyFactory.requiredMemory(pages);
            DirectMemoryRegion poolRegion = region.slice(this.memPerTbl + this.memPerRepl + (long)ldPagesMapOffInRegion);
            this.pool = new PagePool(idx, poolRegion, PersistentPageMemory.this.sysPageSize, PersistentPageMemory.this.rwLock);
            this.pageReplacementPolicy = PersistentPageMemory.this.pageReplacementPolicyFactory.create(this, region.address() + this.memPerTbl + (long)ldPagesMapOffInRegion, this.pool.pages());
            this.dirtyPagesSoftThreshold = (long)this.pool.pages() * 3L / 4L;
            this.dirtyPagesHardThreshold = (long)this.pool.pages() * 9L / 10L;
        }

        private void close() {
            this.writeLock().lock();
            try {
                this.closed = true;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        private int pages() {
            return this.pool.pages();
        }

        private long tableSize() {
            return this.memPerTbl;
        }

        private long replacementSize() {
            return this.memPerRepl;
        }

        private void acquirePage(long absPtr) {
            PageHeader.acquirePage(absPtr);
            PersistentPageMemory.updateAtomicInt(this.acquiredPagesPtr, 1);
        }

        private void releasePage(long absPtr) {
            PageHeader.releasePage(absPtr);
            PersistentPageMemory.updateAtomicInt(this.acquiredPagesPtr, -1);
        }

        private int acquiredPages() {
            return GridUnsafe.getInt((long)this.acquiredPagesPtr);
        }

        private long borrowOrAllocateFreePage(long pageId) {
            return this.pool.borrowOrAllocateFreePage(PageIdUtils.tag(pageId));
        }

        private void resetDirtyPages() {
            this.dirtyPages = ConcurrentHashMap.newKeySet();
            this.dirtyPagesCntr.set(0L);
        }

        public boolean tryToRemovePage(FullPageId fullPageId, long absPtr) throws IgniteInternalCheckedException {
            assert (this.writeLock().isHeldByCurrentThread());
            if (PageHeader.isAcquired(absPtr)) {
                return false;
            }
            if (PersistentPageMemory.this.isDirty(absPtr)) {
                CheckpointPages checkpointPages = this.checkpointPages;
                if (checkpointPages != null && checkpointPages.removeOnPageReplacement(fullPageId)) {
                    checkpointPages.blockFsyncOnPageReplacement(fullPageId);
                    DelayedDirtyPageWrite delayedDirtyPageWrite = PersistentPageMemory.this.delayedPageReplacementTracker.delayedPageWrite();
                    delayedDirtyPageWrite.copyPageToTemporaryBuffer(PersistentPageMemory.this, fullPageId, GridUnsafe.wrapPointer((long)(absPtr + 48L), (int)PersistentPageMemory.this.pageSize()), checkpointPages);
                    PersistentPageMemory.this.setDirty(fullPageId, absPtr, false, true);
                    this.loadedPages.remove(fullPageId.groupId(), fullPageId.effectivePageId());
                    return true;
                }
                return false;
            }
            this.loadedPages.remove(fullPageId.groupId(), fullPageId.effectivePageId());
            return true;
        }

        public long refreshOutdatedPage(int grpId, long pageId, boolean rmv) {
            assert (this.writeLock().isHeldByCurrentThread());
            int tag = this.partGeneration(grpId, PageIdUtils.partitionId(pageId));
            long relPtr = this.loadedPages.refresh(grpId, PageIdUtils.effectivePageId(pageId), tag);
            long absPtr = this.absolute(relPtr);
            GridUnsafe.zeroMemory((long)(absPtr + 48L), (long)PersistentPageMemory.this.pageSize());
            PageHeader.dirty(absPtr, false);
            long tmpBufPtr = PageHeader.tempBufferPointer(absPtr);
            if (tmpBufPtr != 0xFFFFFFFFFFFFFFL) {
                GridUnsafe.zeroMemory((long)(PersistentPageMemory.this.checkpointPool.absolute(tmpBufPtr) + 48L), (long)PersistentPageMemory.this.pageSize());
                PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
                PageHeader.releasePage(absPtr);
                PersistentPageMemory.this.releaseCheckpointBufferPage(tmpBufPtr);
            }
            if (rmv) {
                this.loadedPages.remove(grpId, PageIdUtils.effectivePageId(pageId));
            }
            return relPtr;
        }

        private long removePageForReplacement() throws IgniteInternalCheckedException {
            assert (this.getWriteHoldCount() > 0);
            if (PersistentPageMemory.this.pageReplacementWarned == 0 && pageReplacementWarnedFieldUpdater.compareAndSet(PersistentPageMemory.this, 0, 1)) {
                LOG.warn("Page replacements started, pages will be rotated with disk, this will affect storage performance (consider increasing PageMemoryDataRegionConfiguration#setMaxSize for data region) [region={}]", new Object[]{PersistentPageMemory.this.storageProfileView.name()});
            }
            if (this.acquiredPages() >= this.loadedPages.size()) {
                throw this.oomException("all pages are acquired");
            }
            return this.pageReplacementPolicy.replace();
        }

        public IgniteOutOfMemoryException oomException(String reason) {
            return new IgniteOutOfMemoryException("Failed to find a page for eviction (" + reason + ") [segmentCapacity=" + this.loadedPages.capacity() + ", loaded=" + this.loadedPages.size() + ", dirtyPagesSoftThreshold=" + this.dirtyPagesSoftThreshold + ", dirtyPagesHardThreshold=" + this.dirtyPagesHardThreshold + ", dirtyPages=" + String.valueOf(this.dirtyPagesCntr) + ", pinned=" + this.acquiredPages() + "]" + System.lineSeparator() + "Out of memory in data region [name=" + PersistentPageMemory.this.storageProfileView.name() + ", size=" + IgniteUtils.readableSize((long)PersistentPageMemory.this.storageProfileView.size(), (boolean)false) + ", persistence=true] Try the following:" + System.lineSeparator() + "  ^-- Increase off-heap memory size (PersistentPageMemoryProfileConfigurationSchema.size)" + System.lineSeparator());
        }

        public long absolute(long relPtr) {
            return this.pool.absolute(relPtr);
        }

        public long relative(long pageIdx) {
            return this.pool.relative(pageIdx);
        }

        public long pageIndex(long relPtr) {
            return this.pool.pageIndex(relPtr);
        }

        public int partGeneration(int grpId, int partId) {
            assert (this.getReadHoldCount() > 0 || this.getWriteHoldCount() > 0);
            Integer tag = this.partGenerationMap.get(new GroupPartitionId(grpId, partId));
            assert (tag == null || tag >= 0) : "Negative tag=" + tag;
            return tag == null ? 1 : tag;
        }

        public LoadedPagesMap loadedPages() {
            return this.loadedPages;
        }

        public PagePool pool() {
            return this.pool;
        }

        private int incrementPartGeneration(int grpId, int partId) {
            assert (this.getWriteHoldCount() > 0);
            GroupPartitionId grpPart = new GroupPartitionId(grpId, partId);
            Integer gen = this.partGenerationMap.get(grpPart);
            if (gen == null) {
                gen = 1;
            }
            if (gen == Integer.MAX_VALUE) {
                LOG.info("Partition tag overflow [grpId={}, partId={}]", new Object[]{grpId, partId});
                this.partGenerationMap.put(grpPart, 0);
                return 0;
            }
            this.partGenerationMap.put(grpPart, gen + 1);
            return gen + 1;
        }

        private void resetGroupPartitionsGeneration(int grpId) {
            assert (this.getWriteHoldCount() > 0);
            this.partGenerationMap.keySet().removeIf(grpPart -> grpPart.getGroupId() == grpId);
        }

        public PageIoRegistry ioRegistry() {
            return PersistentPageMemory.this.ioRegistry;
        }

        public CheckpointPages checkpointPages() {
            return this.checkpointPages;
        }
    }
}

