/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Iif;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.Statements;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.PartitionDistributionUtils;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ZoneRebalanceUtil {
    private static final IgniteLogger LOG = Loggers.forClass(ZoneRebalanceUtil.class);
    public static final String PENDING_ASSIGNMENTS_PREFIX = "zone.assignments.pending.";
    public static final byte[] PENDING_ASSIGNMENTS_PREFIX_BYTES = "zone.assignments.pending.".getBytes(StandardCharsets.UTF_8);
    public static final String STABLE_ASSIGNMENTS_PREFIX = "zone.assignments.stable.";
    public static final byte[] STABLE_ASSIGNMENTS_PREFIX_BYTES = "zone.assignments.stable.".getBytes(StandardCharsets.UTF_8);
    public static final String PLANNED_ASSIGNMENTS_PREFIX = "zone.assignments.planned.";
    public static final String ASSIGNMENTS_SWITCH_REDUCE_PREFIX = "zone.assignments.switch.reduce.";
    public static final byte[] ASSIGNMENTS_SWITCH_REDUCE_PREFIX_BYTES = "zone.assignments.switch.reduce.".getBytes(StandardCharsets.UTF_8);
    public static final String ASSIGNMENTS_SWITCH_APPEND_PREFIX = "zone.assignments.switch.append.";

    public static CompletableFuture<Void> updatePendingAssignmentsKeys(CatalogZoneDescriptor zoneDescriptor, ZonePartitionId zonePartitionId, Collection<String> dataNodes, int partitions, int replicas, long revision, MetaStorageManager metaStorageMgr, int partNum, Set<Assignment> zoneCfgPartAssignments, long assignmentsTimestamp, Set<String> aliveNodes, ConsistencyMode consistencyMode) {
        Set partAssignments;
        ByteArray partChangeTriggerKey = ZoneRebalanceUtil.pendingChangeTriggerKey(zonePartitionId);
        ByteArray partAssignmentsPendingKey = ZoneRebalanceUtil.pendingPartAssignmentsKey(zonePartitionId);
        ByteArray partAssignmentsPlannedKey = ZoneRebalanceUtil.plannedPartAssignmentsKey(zonePartitionId);
        ByteArray partAssignmentsStableKey = ZoneRebalanceUtil.stablePartAssignmentsKey(zonePartitionId);
        Set calculatedAssignments = PartitionDistributionUtils.calculateAssignmentForPartition(dataNodes, (int)partNum, (int)partitions, (int)replicas);
        if (consistencyMode == ConsistencyMode.HIGH_AVAILABILITY) {
            Set resultingAssignments = calculatedAssignments.stream().filter(a -> aliveNodes.contains(a.consistentId())).collect(Collectors.toSet());
            for (Assignment assignment : zoneCfgPartAssignments) {
                if (!calculatedAssignments.contains(assignment)) continue;
                resultingAssignments.add(assignment);
            }
            partAssignments = resultingAssignments;
        } else {
            partAssignments = calculatedAssignments;
        }
        boolean isNewAssignments = !zoneCfgPartAssignments.equals(partAssignments);
        byte[] partAssignmentsBytes = Assignments.toBytes((Set)partAssignments, (long)assignmentsTimestamp);
        Condition newAssignmentsCondition = Conditions.exists((ByteArray)partAssignmentsStableKey).and((Condition)Conditions.value((ByteArray)partAssignmentsStableKey).ne(partAssignmentsBytes));
        if (isNewAssignments) {
            newAssignmentsCondition = Conditions.notExists((ByteArray)partAssignmentsStableKey).or(newAssignmentsCondition);
        }
        byte[] revisionBytes = ByteUtils.longToBytesKeepingOrder((long)revision);
        Iif iif = Statements.iif((Condition)Conditions.or((Condition)Conditions.notExists((ByteArray)partChangeTriggerKey), (Condition)Conditions.value((ByteArray)partChangeTriggerKey).lt(revisionBytes)), (Iif)Statements.iif((Condition)Conditions.and((Condition)Conditions.notExists((ByteArray)partAssignmentsPendingKey), (Condition)newAssignmentsCondition), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)partAssignmentsPendingKey, (byte[])partAssignmentsBytes), Operations.put((ByteArray)partChangeTriggerKey, (byte[])revisionBytes)}).yield(RebalanceUtil.UpdateStatus.PENDING_KEY_UPDATED.ordinal()), (Iif)Statements.iif((Condition)Conditions.and((Condition)Conditions.value((ByteArray)partAssignmentsPendingKey).ne(partAssignmentsBytes), (Condition)Conditions.exists((ByteArray)partAssignmentsPendingKey)), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)partAssignmentsPlannedKey, (byte[])partAssignmentsBytes), Operations.put((ByteArray)partChangeTriggerKey, (byte[])revisionBytes)}).yield(RebalanceUtil.UpdateStatus.PLANNED_KEY_UPDATED.ordinal()), (Iif)Statements.iif((Condition)Conditions.value((ByteArray)partAssignmentsPendingKey).eq(partAssignmentsBytes), (Update)Operations.ops((Operation[])new Operation[]{Operations.remove((ByteArray)partAssignmentsPlannedKey), Operations.put((ByteArray)partChangeTriggerKey, (byte[])revisionBytes)}).yield(RebalanceUtil.UpdateStatus.PLANNED_KEY_REMOVED_EQUALS_PENDING.ordinal()), (Iif)Statements.iif((Condition)Conditions.notExists((ByteArray)partAssignmentsPendingKey), (Update)Operations.ops((Operation[])new Operation[]{Operations.remove((ByteArray)partAssignmentsPlannedKey), Operations.put((ByteArray)partChangeTriggerKey, (byte[])revisionBytes)}).yield(RebalanceUtil.UpdateStatus.PLANNED_KEY_REMOVED_EMPTY_PENDING.ordinal()), (Update)Operations.ops((Operation[])new Operation[0]).yield(RebalanceUtil.UpdateStatus.ASSIGNMENT_NOT_UPDATED.ordinal()))))), (Update)Operations.ops((Operation[])new Operation[0]).yield(RebalanceUtil.UpdateStatus.OUTDATED_UPDATE_RECEIVED.ordinal()));
        return metaStorageMgr.invoke(iif).thenAccept(sr -> {
            switch (UpdateStatus.valueOf(sr.getAsInt()).ordinal()) {
                case 0: {
                    LOG.info("Update metastore pending partitions key [key={}, partition={}, zone={}/{}, newVal={}]", new Object[]{partAssignmentsPendingKey.toString(), partNum, zoneDescriptor.id(), zoneDescriptor.name(), partAssignments});
                    break;
                }
                case 1: {
                    LOG.info("Update metastore planned partitions key [key={}, partition={}, zone={}/{}, newVal={}]", new Object[]{partAssignmentsPlannedKey, partNum, zoneDescriptor.id(), zoneDescriptor.name(), partAssignments});
                    break;
                }
                case 2: {
                    LOG.info("Remove planned key because current pending key has the same value [key={}, partition={}, zone={}/{}, val={}]", new Object[]{partAssignmentsPlannedKey.toString(), partNum, zoneDescriptor.id(), zoneDescriptor.name(), partAssignments});
                    break;
                }
                case 3: {
                    LOG.info("Remove planned key because pending is empty and calculated assignments are equal to current assignments [key={}, partition={}, zone={}/{}, val={}]", new Object[]{partAssignmentsPlannedKey.toString(), partNum, zoneDescriptor.id(), zoneDescriptor.name(), partAssignments});
                    break;
                }
                case 4: {
                    LOG.debug("Assignments are not updated [key={}, partition={}, zone={}/{}, val={}]", new Object[]{partAssignmentsPlannedKey.toString(), partNum, zoneDescriptor.id(), zoneDescriptor.name(), partAssignments});
                    break;
                }
                case 5: {
                    LOG.debug("Received outdated rebalance trigger event [revision={}, partition={}, zone={}/{}]", new Object[]{revision, partNum, zoneDescriptor.id(), zoneDescriptor.name()});
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown return code for rebalance metastore multi-invoke");
                }
            }
        });
    }

    static CompletableFuture<Void> triggerZonePartitionsRebalance(CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, long storageRevision, MetaStorageManager metaStorageManager, IgniteSpinBusyLock busyLock, long assignmentsTimestamp, Set<String> aliveNodes) {
        int finalPartId;
        CompletableFuture<Map<Integer, Assignments>> zoneAssignmentsFut = ZoneRebalanceUtil.zoneAssignments(metaStorageManager, zoneDescriptor.id(), Set.of(), zoneDescriptor.partitions());
        CompletableFuture[] partitionFutures = new CompletableFuture[zoneDescriptor.partitions()];
        for (int partId = 0; partId < zoneDescriptor.partitions(); ++partId) {
            ZonePartitionId replicaGrpId = new ZonePartitionId(zoneDescriptor.id(), partId);
            finalPartId = partId;
            partitionFutures[partId] = zoneAssignmentsFut.thenCompose(zoneAssignments -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)busyLock, () -> zoneAssignments.isEmpty() ? CompletableFutures.nullCompletedFuture() : ZoneRebalanceUtil.updatePendingAssignmentsKeys(zoneDescriptor, replicaGrpId, dataNodes, zoneDescriptor.partitions(), zoneDescriptor.replicas(), storageRevision, metaStorageManager, finalPartId, ((Assignments)zoneAssignments.get(finalPartId)).nodes(), assignmentsTimestamp, aliveNodes, zoneDescriptor.consistencyMode())));
        }
        ConcurrentHashMap.KeySetView unwrappedCauses = ConcurrentHashMap.newKeySet();
        for (int partId = 0; partId < partitionFutures.length; ++partId) {
            finalPartId = partId;
            partitionFutures[partId].exceptionally(e -> {
                Throwable cause = ExceptionUtils.unwrapCause((Throwable)e);
                if (unwrappedCauses.add(cause)) {
                    LOG.error("Exception on updating assignments for [zone={}, partition={}]", e, new Object[]{ZoneRebalanceUtil.zoneInfo(zoneDescriptor), finalPartId});
                } else {
                    LOG.error("Exception on updating assignments for [zone={}]", e, new Object[]{ZoneRebalanceUtil.zoneInfo(zoneDescriptor)});
                }
                return null;
            });
        }
        return CompletableFuture.allOf(partitionFutures);
    }

    private static String zoneInfo(CatalogZoneDescriptor zoneDescriptor) {
        return zoneDescriptor.id() + "/" + zoneDescriptor.name();
    }

    public static ByteArray pendingChangeTriggerKey(ZonePartitionId zonePartitionId) {
        return new ByteArray("zone.pending.change.trigger." + String.valueOf(zonePartitionId));
    }

    public static ByteArray pendingPartAssignmentsKey(ZonePartitionId zonePartitionId) {
        return new ByteArray(PENDING_ASSIGNMENTS_PREFIX + String.valueOf(zonePartitionId));
    }

    public static ByteArray plannedPartAssignmentsKey(ZonePartitionId zonePartitionId) {
        return new ByteArray(PLANNED_ASSIGNMENTS_PREFIX + String.valueOf(zonePartitionId));
    }

    public static ByteArray stablePartAssignmentsKey(ZonePartitionId zonePartitionId) {
        return new ByteArray(STABLE_ASSIGNMENTS_PREFIX + String.valueOf(zonePartitionId));
    }

    public static ByteArray switchReduceKey(ZonePartitionId zonePartitionId) {
        return new ByteArray(ASSIGNMENTS_SWITCH_REDUCE_PREFIX + String.valueOf(zonePartitionId));
    }

    public static ByteArray switchAppendKey(ZonePartitionId zonePartitionId) {
        return new ByteArray(ASSIGNMENTS_SWITCH_APPEND_PREFIX + String.valueOf(zonePartitionId));
    }

    public static ZonePartitionId extractZonePartitionId(byte[] key, byte[] prefix) {
        String zonePartitionIdString = StringUtils.toStringWithoutPrefix((byte[])key, (int)prefix.length);
        return ZonePartitionId.fromString((String)zonePartitionIdString);
    }

    public static int extractZoneIdDataNodes(byte[] key) {
        return Integer.parseInt(StringUtils.toStringWithoutPrefix((byte[])key, (int)DistributionZonesUtil.DISTRIBUTION_ZONE_DATA_NODES_VALUE_PREFIX_BYTES.length));
    }

    public static boolean recoverable(Throwable t) {
        return true;
    }

    public static <T> Set<T> subtract(Set<T> minuend, Set<T> subtrahend) {
        return minuend.stream().filter(v -> !subtrahend.contains(v)).collect(Collectors.toSet());
    }

    public static <T> Set<T> union(Set<T> op1, Set<T> op2) {
        HashSet<T> res = new HashSet<T>(op1);
        res.addAll(op2);
        return res;
    }

    public static <T> Set<T> intersect(Set<T> op1, Set<T> op2) {
        return op1.stream().filter(op2::contains).collect(Collectors.toSet());
    }

    @Nullable
    public static Set<Assignment> zonePartitionAssignmentsGetLocally(MetaStorageManager metaStorageManager, int zoneId, int partitionNumber, long revision) {
        Entry entry = metaStorageManager.getLocally(ZoneRebalanceUtil.stablePartAssignmentsKey(new ZonePartitionId(zoneId, partitionNumber)), revision);
        return entry == null || entry.empty() || entry.tombstone() ? null : Assignments.fromBytes((byte[])entry.value()).nodes();
    }

    public static List<Assignments> zoneAssignmentsGetLocally(MetaStorageManager metaStorageManager, int zoneId, int numberOfPartitions, long revision) {
        return IntStream.range(0, numberOfPartitions).mapToObj(p -> {
            Entry e = metaStorageManager.getLocally(ZoneRebalanceUtil.stablePartAssignmentsKey(new ZonePartitionId(zoneId, p)), revision);
            assert (e != null && !e.empty() && !e.tombstone()) : e;
            return Assignments.fromBytes((byte[])e.value());
        }).collect(Collectors.toList());
    }

    private static CompletableFuture<Map<Integer, Assignments>> zoneAssignments(MetaStorageManager metaStorageManager, int zoneId, Set<Integer> partitionIds, int numberOfPartitions) {
        HashMap<ByteArray, Integer> partitionKeysToPartitionNumber = new HashMap<ByteArray, Integer>();
        Set<Integer> ids = partitionIds.isEmpty() ? (Collection)IntStream.range(0, numberOfPartitions).boxed().collect(Collectors.toList()) : partitionIds;
        for (Integer partId : ids) {
            partitionKeysToPartitionNumber.put(ZoneRebalanceUtil.stablePartAssignmentsKey(new ZonePartitionId(zoneId, partId.intValue())), partId);
        }
        return metaStorageManager.getAll(partitionKeysToPartitionNumber.keySet()).thenApply(entries -> {
            if (entries.isEmpty()) {
                return Map.of();
            }
            HashMap<Integer, Assignments> result = new HashMap<Integer, Assignments>();
            int numberOfMsPartitions = 0;
            for (Map.Entry mapEntry : entries.entrySet()) {
                Entry entry = (Entry)mapEntry.getValue();
                if (entry.empty() || entry.tombstone()) continue;
                result.put((Integer)partitionKeysToPartitionNumber.get(mapEntry.getKey()), Assignments.fromBytes((byte[])entry.value()));
                ++numberOfMsPartitions;
            }
            assert (numberOfMsPartitions == 0 || numberOfMsPartitions == entries.size()) : "Invalid number of stable partition entries received from meta storage [received=" + numberOfMsPartitions + ", numberOfPartitions=" + entries.size() + ", zoneId=" + zoneId + "].";
            return numberOfMsPartitions == 0 ? Map.of() : result;
        });
    }

    public static enum UpdateStatus {
        PENDING_KEY_UPDATED,
        PLANNED_KEY_UPDATED,
        PLANNED_KEY_REMOVED_EQUALS_PENDING,
        PLANNED_KEY_REMOVED_EMPTY_PENDING,
        ASSIGNMENT_NOT_UPDATED,
        OUTDATED_UPDATE_RECEIVED;

        private static final UpdateStatus[] VALUES;

        public static UpdateStatus valueOf(int ordinal) {
            return VALUES[ordinal];
        }

        static {
            VALUES = UpdateStatus.values();
        }
    }
}

