/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite.internal.catalog.systemviews.IndexSystemViewProvider;
import org.apache.ignite.internal.catalog.systemviews.SystemViewViewProvider;
import org.apache.ignite.internal.catalog.systemviews.TablesSystemViewProvider;
import org.apache.ignite.internal.catalog.systemviews.ZonesSystemViewProvider;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViewProvider;

public class CatalogSystemViewRegistry
implements SystemViewProvider {
    private final List<CatalogSystemViewProvider> providers;
    private final Supplier<Catalog> catalogSupplier;

    public CatalogSystemViewRegistry(Supplier<Catalog> catalogSupplier) {
        this.catalogSupplier = catalogSupplier;
        this.providers = List.of(new SystemViewViewProvider(), new IndexSystemViewProvider(), new ZonesSystemViewProvider(), new TablesSystemViewProvider());
    }

    public List<SystemView<?>> systemViews() {
        return this.providers.stream().flatMap(p -> p.getView(this.catalogSupplier).stream()).collect(Collectors.toList());
    }
}

