/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcCorrelationDataContextBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;

public class JdbcImplementor
extends RelToSqlConverter {
    private final JdbcCorrelationDataContextBuilder dataContextBuilder;
    private final JavaTypeFactory typeFactory;

    JdbcImplementor(SqlDialect dialect, JavaTypeFactory typeFactory, JdbcCorrelationDataContextBuilder dataContextBuilder) {
        super(dialect);
        this.typeFactory = typeFactory;
        this.dataContextBuilder = dataContextBuilder;
    }

    public JdbcImplementor(SqlDialect dialect, JavaTypeFactory typeFactory) {
        this(dialect, typeFactory, new JdbcCorrelationDataContextBuilder(){
            private int counter = 1;

            @Override
            public int add(CorrelationId id, int ordinal, Type type) {
                return this.counter++;
            }
        });
    }

    public SqlImplementor.Result implement(RelNode node) {
        return this.dispatch(node);
    }

    @Override
    protected SqlImplementor.Context getAliasContext(final RexCorrelVariable variable) {
        SqlImplementor.Context context = (SqlImplementor.Context)this.correlTableMap.get(variable.id);
        if (context != null) {
            return context;
        }
        final List<RelDataTypeField> fieldList = variable.getType().getFieldList();
        return new SqlImplementor.Context(this.dialect, fieldList.size()){

            @Override
            public SqlNode field(int ordinal) {
                RelDataTypeField field = (RelDataTypeField)fieldList.get(ordinal);
                return new SqlDynamicParam(JdbcImplementor.this.dataContextBuilder.add(variable.id, ordinal, JdbcImplementor.this.typeFactory.getJavaClass(field.getType())), SqlParserPos.ZERO);
            }

            @Override
            public SqlImplementor implementor() {
                return JdbcImplementor.this;
            }
        };
    }
}

