/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import java.util.List;
import java.util.Objects;

class ReturnBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final OpCode returnOpCode;

    ReturnBytecodeExpression(BytecodeExpression instance) {
        super(ParameterizedType.type(Void.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.returnOpCode = ReturnBytecodeExpression.returnOpCode(instance.getType());
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(this.returnOpCode);
    }

    @Override
    protected String formatOneLine() {
        return "return " + String.valueOf(this.instance);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.instance);
    }

    private static OpCode returnOpCode(ParameterizedType componentType) {
        Class<?> primitiveType = componentType.getPrimitiveType();
        if (primitiveType != null) {
            if (primitiveType == Byte.TYPE || primitiveType == Boolean.TYPE || primitiveType == Character.TYPE || primitiveType == Short.TYPE || primitiveType == Integer.TYPE) {
                return OpCode.IRETURN;
            }
            if (primitiveType == Long.TYPE) {
                return OpCode.LRETURN;
            }
            if (primitiveType == Float.TYPE) {
                return OpCode.FRETURN;
            }
            if (primitiveType == Double.TYPE) {
                return OpCode.DRETURN;
            }
            if (primitiveType == Void.TYPE) {
                return OpCode.RETURN;
            }
            throw new IllegalArgumentException("Unsupported array type: " + String.valueOf(primitiveType));
        }
        return OpCode.ARETURN;
    }
}

