/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeSystem;
import org.apache.ignite.internal.sql.engine.util.Commons;

public class TableModifyConverterRule
extends AbstractIgniteConverterRule<LogicalTableModify> {
    public static final RelOptRule INSTANCE = new TableModifyConverterRule();

    public TableModifyConverterRule() {
        super(LogicalTableModify.class, "TableModifyConverterRule");
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalTableModify rel) {
        RelOptCluster cluster = rel.getCluster();
        RelOptTable relTable = rel.getTable();
        IgniteTable igniteTable = (IgniteTable)relTable.unwrap(IgniteTable.class);
        assert (igniteTable != null);
        IgniteDistribution distribution = igniteTable.distribution();
        if (rel.getOperation() == TableModify.Operation.DELETE) {
            ImmutableIntList keyColumns = igniteTable.keyColumns();
            distribution = distribution.apply((Mappings.TargetMapping)Commons.projectedMapping(igniteTable.descriptor().columnsCount(), keyColumns));
        }
        RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)distribution).replace((RelTrait)RelCollations.EMPTY);
        RelNode input = TableModifyConverterRule.convert((RelNode)rel.getInput(), (RelTraitSet)traits);
        IgniteTableModify tableModify = new IgniteTableModify(cluster, traits, relTable, input, rel.getOperation(), rel.getUpdateColumnList(), rel.getSourceExpressionList(), rel.isFlattened());
        if (igniteTable.distribution().equals(IgniteDistributions.single())) {
            return tableModify;
        }
        return TableModifyConverterRule.createAggregate(tableModify, cluster);
    }

    private static PhysicalNode createAggregate(IgniteTableModify tableModify, RelOptCluster cluster) {
        RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        RelDataType rowType = tableModify.getRowType();
        RelDataTypeField modifiedRowsField = (RelDataTypeField)rowType.getFieldList().get(0);
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        RelDataType rowCountType = modifiedRowsField.getType();
        RelDataType sumType = IgniteTypeSystem.INSTANCE.deriveSumType(typeFactory, rowCountType);
        AggregateCall sum = AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.SUM0, (boolean)false, (boolean)false, (boolean)false, (List)ImmutableList.of((Object)0), (int)-1, null, (RelCollation)RelCollations.EMPTY, (int)0, (RelNode)tableModify, (RelDataType)sumType, null);
        IgniteColocatedHashAggregate sumAgg = new IgniteColocatedHashAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.single()), TableModifyConverterRule.convert((RelNode)tableModify, (RelTraitSet)inTrait.replace((RelTrait)IgniteDistributions.single())), ImmutableBitSet.of(), List.of(ImmutableBitSet.of()), List.of(sum));
        RelDataType typeOfSum = modifiedRowsField.getType();
        RelDataType convertedRowType = typeFactory.createStructType(List.of(Map.entry(modifiedRowsField.getName(), typeOfSum)));
        RexBuilder rexBuilder = Commons.rexBuilder();
        RexInputRef sumRef = rexBuilder.makeInputRef((RelNode)sumAgg, 0);
        RexNode rexNode = rexBuilder.makeCast(typeOfSum, (RexNode)sumRef);
        List<RexNode> projections = Collections.singletonList(rexNode);
        return new IgniteProject(cluster, outTrait.replace((RelTrait)IgniteDistributions.single()), (RelNode)sumAgg, projections, convertedRowType);
    }
}

