/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.deployunit.DeploymentStatus;
import org.apache.ignite.internal.deployunit.DeploymentUnitAcquiredWaiter;
import org.apache.ignite.internal.deployunit.UnitDownloader;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitStore;
import org.apache.ignite.internal.deployunit.metastore.NodeEventCallback;
import org.apache.ignite.internal.deployunit.metastore.status.UnitClusterStatus;
import org.apache.ignite.internal.deployunit.metastore.status.UnitNodeStatus;
import org.apache.ignite.internal.network.ClusterNodeImpl;

public class DefaultNodeCallback
extends NodeEventCallback {
    private final DeploymentUnitStore deploymentUnitStore;
    private final DeploymentUnitAcquiredWaiter undeployer;
    private final UnitDownloader downloader;
    private final ClusterManagementGroupManager cmgManager;

    DefaultNodeCallback(DeploymentUnitStore deploymentUnitStore, DeploymentUnitAcquiredWaiter undeployer, UnitDownloader downloader, ClusterManagementGroupManager cmgManager) {
        this.deploymentUnitStore = deploymentUnitStore;
        this.undeployer = undeployer;
        this.downloader = downloader;
        this.cmgManager = cmgManager;
    }

    @Override
    public void onUploading(String id, Version version, List<UnitNodeStatus> holders) {
        this.downloader.downloadUnit(id, version, DefaultNodeCallback.getDeployedNodeIds(holders));
    }

    @Override
    public void onDeploy(String id, Version version, List<UnitNodeStatus> holders) {
        Set<String> nodeIds = DefaultNodeCallback.getDeployedNodeIds(holders);
        ((CompletableFuture)((CompletableFuture)this.deploymentUnitStore.getClusterStatus(id, version).thenApply(UnitClusterStatus::initialNodesToDeploy)).thenApply(nodeIds::containsAll)).thenAccept(allRequiredDeployed -> {
            if (allRequiredDeployed.booleanValue()) {
                this.deploymentUnitStore.updateClusterStatus(id, version, DeploymentStatus.DEPLOYED);
            }
        });
    }

    @Override
    public void onObsolete(String id, Version version, List<UnitNodeStatus> holders) {
        this.undeployer.submitToAcquireRelease(new DeploymentUnit(id, version));
    }

    @Override
    public void onRemoving(String id, Version version, List<UnitNodeStatus> holders) {
        this.cmgManager.logicalTopology().thenAccept(snapshot -> {
            Set nodes = snapshot.nodes().stream().map(ClusterNodeImpl::name).collect(Collectors.toSet());
            boolean allRemoved = holders.stream().filter(nodeStatus -> nodes.contains(nodeStatus.nodeId())).allMatch(nodeStatus -> nodeStatus.status() == DeploymentStatus.REMOVING);
            if (allRemoved) {
                this.deploymentUnitStore.updateClusterStatus(id, version, DeploymentStatus.REMOVING);
            }
        });
    }

    private static Set<String> getDeployedNodeIds(List<UnitNodeStatus> holders) {
        return holders.stream().filter(status -> status.status() == DeploymentStatus.DEPLOYED).map(UnitNodeStatus::nodeId).collect(Collectors.toSet());
    }
}

