/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.tx;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite3.internal.client.ClientChannel;
import org.apache.ignite3.internal.client.ReliableChannel;
import org.apache.ignite3.internal.client.tx.ClientTransaction;
import org.apache.ignite3.internal.client.tx.ClientTransactions;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.tx.Transaction;
import org.apache.ignite3.tx.TransactionException;
import org.apache.ignite3.tx.TransactionOptions;
import org.jetbrains.annotations.Nullable;

public class ClientLazyTransaction
implements Transaction {
    private final long observableTimestamp;
    @Nullable
    private final TransactionOptions options;
    private volatile CompletableFuture<ClientTransaction> tx;

    ClientLazyTransaction(HybridTimestampTracker observableTimestamp, @Nullable TransactionOptions options) {
        this.observableTimestamp = observableTimestamp.getLong();
        this.options = options;
    }

    @Override
    public void commit() throws TransactionException {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return;
        }
        tx0.join().commit();
    }

    @Override
    public CompletableFuture<Void> commitAsync() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return tx0.thenCompose(ClientTransaction::commitAsync);
    }

    @Override
    public void rollback() throws TransactionException {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return;
        }
        tx0.join().rollback();
    }

    @Override
    public CompletableFuture<Void> rollbackAsync() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return tx0.thenCompose(ClientTransaction::rollbackAsync);
    }

    @Override
    public boolean isReadOnly() {
        return this.options != null && this.options.readOnly();
    }

    public long timeout() {
        return this.options == null ? 0L : this.options.timeoutMillis();
    }

    public String nodeName() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        assert (tx0 != null);
        return tx0.join().nodeName();
    }

    @Nullable
    public static ClientLazyTransaction get(@Nullable Transaction tx) {
        if (tx == null) {
            return null;
        }
        if (!(tx instanceof ClientLazyTransaction)) {
            throw ClientTransaction.unsupportedTxTypeException(tx);
        }
        return (ClientLazyTransaction)tx;
    }

    public static IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean> ensureStarted(Transaction tx, ReliableChannel ch) {
        return ClientLazyTransaction.ensureStarted(tx, ch, () -> ch.getChannelAsync(null));
    }

    public static IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean> ensureStarted(Transaction tx, ReliableChannel ch, @Nullable Supplier<CompletableFuture<ClientChannel>> channelResolver) {
        if (!(tx instanceof ClientLazyTransaction)) {
            throw ClientTransaction.unsupportedTxTypeException(tx);
        }
        return ((ClientLazyTransaction)tx).ensureStarted(ch, channelResolver);
    }

    private synchronized IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean> ensureStarted(ReliableChannel ch, @Nullable Supplier<CompletableFuture<ClientChannel>> channelResolver) {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 != null) {
            return new IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean>(tx0, false);
        }
        this.tx = tx0 = channelResolver != null ? ClientTransactions.beginAsync(ch, this.options, this.observableTimestamp, channelResolver) : new CompletableFuture();
        return new IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean>(tx0, channelResolver == null);
    }

    public ClientTransaction startedTx() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        assert (tx0 != null) : "Transaction is not started";
        assert (tx0.isDone()) : "Transaction is starting";
        return tx0.join();
    }

    public long observableTimestamp() {
        return this.observableTimestamp;
    }
}

