/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.StampedLock;

public class NaiveAsyncReadWriteLock {
    private final StampedLock stampedLock = new StampedLock();
    private final Object mutex = new Object();
    private final Queue<CompletableFuture<Long>> writeLockWaiters = new ArrayDeque<CompletableFuture<Long>>();
    private final Queue<CompletableFuture<Long>> readLockWaiters = new ArrayDeque<CompletableFuture<Long>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Long> writeLock() {
        Object object = this.mutex;
        synchronized (object) {
            long stamp = this.stampedLock.tryWriteLock();
            if (stamp != 0L) {
                return CompletableFuture.completedFuture(stamp);
            }
            CompletableFuture<Long> lockFuture = new CompletableFuture<Long>();
            this.writeLockWaiters.add(lockFuture);
            return lockFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockWrite(long stamp) {
        CompletableFuture<Long> writeLockWaiter;
        long newWriteStamp = 0L;
        LongArrayList readStamps = null;
        ArrayList<CompletableFuture> readLockWaitersToComplete = null;
        Object object = this.mutex;
        synchronized (object) {
            this.stampedLock.unlockWrite(stamp);
            writeLockWaiter = this.writeLockWaiters.poll();
            if (writeLockWaiter != null) {
                newWriteStamp = this.stampedLock.tryWriteLock();
                assert (newWriteStamp != 0L);
            } else {
                for (CompletableFuture completableFuture : this.readLockWaiters) {
                    long newReadStamp = this.stampedLock.tryReadLock();
                    assert (newReadStamp != 0L);
                    if (readStamps == null) {
                        readStamps = new LongArrayList(this.readLockWaiters.size());
                        readLockWaitersToComplete = new ArrayList<CompletableFuture>(this.readLockWaiters.size());
                    }
                    readStamps.add(newReadStamp);
                    readLockWaitersToComplete.add(completableFuture);
                }
                this.readLockWaiters.clear();
            }
        }
        if (writeLockWaiter != null) {
            writeLockWaiter.complete(newWriteStamp);
        } else if (readLockWaitersToComplete != null) {
            for (int i = 0; i < readLockWaitersToComplete.size(); ++i) {
                ((CompletableFuture)readLockWaitersToComplete.get(i)).complete(readStamps.getLong(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Long> readLock() {
        Object object = this.mutex;
        synchronized (object) {
            long stamp;
            if (this.writeLockWaiters.isEmpty() && (stamp = this.stampedLock.tryReadLock()) != 0L) {
                return CompletableFuture.completedFuture(stamp);
            }
            CompletableFuture<Long> lockFuture = new CompletableFuture<Long>();
            this.readLockWaiters.add(lockFuture);
            return lockFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRead(long stamp) {
        CompletableFuture<Long> writeLockWaiter;
        long newWriteStamp = 0L;
        Object object = this.mutex;
        synchronized (object) {
            this.stampedLock.unlockRead(stamp);
            if (this.stampedLock.isReadLocked()) {
                return;
            }
            writeLockWaiter = this.writeLockWaiters.poll();
            if (writeLockWaiter != null) {
                newWriteStamp = this.stampedLock.tryWriteLock();
                assert (newWriteStamp != 0L);
            }
        }
        if (writeLockWaiter != null) {
            writeLockWaiter.complete(newWriteStamp);
        }
    }

    boolean isReadLocked() {
        return this.stampedLock.isReadLocked();
    }
}

