/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.disaster;

import java.util.Set;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStatesRequest;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStatesRequestBuilder;

class LocalPartitionStatesRequestDeserializer
implements MessageDeserializer<LocalPartitionStatesRequest> {
    private final LocalPartitionStatesRequestBuilder msg;

    LocalPartitionStatesRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.localPartitionStatesRequest();
    }

    @Override
    public Class<LocalPartitionStatesRequest> klass() {
        return LocalPartitionStatesRequest.class;
    }

    @Override
    public LocalPartitionStatesRequest getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("catalogVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.catalogVersion(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readSet("partitionIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitionIds((Set<Integer>)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readSet("zoneIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.zoneIds((Set<Integer>)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LocalPartitionStatesRequest.class);
    }
}

