/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.meta.io;

import java.util.UUID;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMeta;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaKey;

public interface IndexMetaIo {
    public static final int INDEX_ID_OFFSET = 0;
    public static final int INDEX_TYPE_OFFSET = 4;
    public static final int INDEX_TREE_META_PAGE_ID_OFFSET = 5;
    public static final int NEXT_ROW_ID_TO_BUILT_MSB_OFFSET = 13;
    public static final int NEXT_ROW_ID_TO_BUILT_LSB_OFFSET = 21;
    public static final int SIZE_IN_BYTES = 29;

    public int offset(int var1);

    default public int compare(long pageAddr, int idx, IndexMetaKey indexMeta) {
        int elementOffset = this.offset(idx);
        return Integer.compare(PageUtils.getInt(pageAddr, elementOffset + 0), indexMeta.indexId());
    }

    default public IndexMeta getRow(long pageAddr, int idx) {
        int elementOffset = this.offset(idx);
        int indexId = PageUtils.getInt(pageAddr, elementOffset + 0);
        IndexMeta.IndexType indexType = IndexMeta.IndexType.deserialize(PageUtils.getByte(pageAddr, elementOffset + 4));
        long indexTreeMetaPageId = PageUtils.getLong(pageAddr, elementOffset + 5);
        long nextRowIdUuidToBuiltMsb = PageUtils.getLong(pageAddr, elementOffset + 13);
        long nextRowIdUuidToBuiltLsb = PageUtils.getLong(pageAddr, elementOffset + 21);
        UUID nextRowIdUuid = nextRowIdUuidToBuiltMsb == 0L && nextRowIdUuidToBuiltLsb == 0L ? null : new UUID(nextRowIdUuidToBuiltMsb, nextRowIdUuidToBuiltLsb);
        return new IndexMeta(indexId, indexType, indexTreeMetaPageId, nextRowIdUuid);
    }

    default public void store(long dstPageAddr, int dstIdx, BplusIo<IndexMetaKey> srcIo, long srcPageAddr, int srcIdx) {
        int dstOffset = this.offset(dstIdx);
        int srcOffset = srcIo.offset(srcIdx);
        PageUtils.copyMemory(srcPageAddr, (long)srcOffset, dstPageAddr, (long)dstOffset, 29L);
    }

    default public void storeByOffset(long pageAddr, int off, IndexMetaKey rowKey) {
        if (!1.$assertionsDisabled && !(rowKey instanceof IndexMeta)) {
            throw new AssertionError(rowKey);
        }
        IndexMeta row = (IndexMeta)rowKey;
        PageUtils.putInt(pageAddr, off + 0, row.indexId());
        PageUtils.putByte(pageAddr, off + 4, row.indexType().serialize());
        PageUtils.putLong(pageAddr, off + 5, row.metaPageId());
        UUID nextRowIdUuidToBuild = row.nextRowIdUuidToBuild();
        long nextRowIdUuidToBuildMsb = nextRowIdUuidToBuild == null ? 0L : nextRowIdUuidToBuild.getMostSignificantBits();
        long nextRowIdUuidToBuildLsb = nextRowIdUuidToBuild == null ? 0L : nextRowIdUuidToBuild.getLeastSignificantBits();
        PageUtils.putLong(pageAddr, off + 13, nextRowIdUuidToBuildMsb);
        PageUtils.putLong(pageAddr, off + 21, nextRowIdUuidToBuildLsb);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

