/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.internal.tx.impl.PrimaryReplicaExpiredException;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.TraceableException;
import org.apache.ignite3.tx.TransactionException;

class TransactionsExceptionMapperUtil {
    TransactionsExceptionMapperUtil() {
    }

    static <T> CompletableFuture<T> convertToPublicFuture(CompletableFuture<T> origin, int defaultCode) {
        if (CompletableFutures.isCompletedSuccessfully(origin)) {
            return origin;
        }
        return origin.handle((res, err) -> {
            if (err != null) {
                throw new CompletionException(TransactionsExceptionMapperUtil.mapToPublicTransactionException(ExceptionUtils.unwrapCause(err), defaultCode));
            }
            return res;
        });
    }

    private static Throwable mapToPublicTransactionException(Throwable origin, int defaultCode) {
        if (origin instanceof PrimaryReplicaExpiredException) {
            PrimaryReplicaExpiredException err = (PrimaryReplicaExpiredException)origin;
            return new TransactionException(err.traceId(), err.code(), err.getMessage(), err);
        }
        if (origin instanceof AssertionError) {
            return new TransactionException(defaultCode, origin);
        }
        if (origin instanceof Error) {
            return origin;
        }
        Throwable mapped = IgniteExceptionMapperUtil.mapToPublicException(origin, ex -> new TransactionException(defaultCode, (Throwable)ex));
        if (mapped instanceof TransactionException) {
            return mapped;
        }
        if (mapped instanceof TraceableException) {
            TraceableException traceable = (TraceableException)((Object)mapped);
            return new TransactionException(traceable.traceId(), traceable.code(), mapped.getMessage(), mapped);
        }
        return new TransactionException(defaultCode, mapped);
    }
}

