/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.ProjectOffPushDownRule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.Util;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.QueryCardinalityUtil;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;

public class PruneCorrelatedJoinColumns
extends ProjectOffPushDownRule<CorrelatedJoinNode> {
    public PruneCorrelatedJoinColumns() {
        super(Patterns.correlatedJoin());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, CorrelatedJoinNode correlatedJoinNode, Set<Symbol> referencedOutputs) {
        boolean pruned;
        PlanNode input = correlatedJoinNode.getInput();
        PlanNode subquery = correlatedJoinNode.getSubquery();
        if (Sets.intersection((Set)ImmutableSet.copyOf(subquery.getOutputSymbols()), referencedOutputs).isEmpty()) {
            if (correlatedJoinNode.getJoinType() == JoinNode.JoinType.INNER && QueryCardinalityUtil.isScalar(subquery, context.getLookup()) && correlatedJoinNode.getFilter().equals(BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(input);
            }
            if (correlatedJoinNode.getJoinType() == JoinNode.JoinType.LEFT && QueryCardinalityUtil.isAtMostScalar(subquery, context.getLookup())) {
                return Optional.of(input);
            }
        }
        ImmutableSet referencedAndCorrelationSymbols = ImmutableSet.builder().addAll(referencedOutputs).addAll(correlatedJoinNode.getCorrelation()).build();
        if (Sets.intersection((Set)ImmutableSet.copyOf(input.getOutputSymbols()), (Set)referencedAndCorrelationSymbols).isEmpty()) {
            if (correlatedJoinNode.getJoinType() == JoinNode.JoinType.INNER && QueryCardinalityUtil.isScalar(input, context.getLookup()) && correlatedJoinNode.getFilter().equals(BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(subquery);
            }
            if (correlatedJoinNode.getJoinType() == JoinNode.JoinType.RIGHT && QueryCardinalityUtil.isAtMostScalar(input, context.getLookup())) {
                return Optional.of(subquery);
            }
        }
        Set<Symbol> filterSymbols = SymbolsExtractor.extractUnique(correlatedJoinNode.getFilter());
        ImmutableSet referencedAndFilterSymbols = ImmutableSet.builder().addAll(referencedOutputs).addAll(filterSymbols).build();
        Optional<PlanNode> newSubquery = Util.restrictOutputs(context.getIdAllocator(), subquery, (Set<Symbol>)referencedAndFilterSymbols);
        ImmutableSet referencedAndFilterAndCorrelationSymbols = ImmutableSet.builder().addAll((Iterable)referencedAndFilterSymbols).addAll(correlatedJoinNode.getCorrelation()).build();
        Optional<PlanNode> newInput = Util.restrictOutputs(context.getIdAllocator(), input, (Set<Symbol>)referencedAndFilterAndCorrelationSymbols);
        boolean bl = pruned = newSubquery.isPresent() || newInput.isPresent();
        if (pruned) {
            return Optional.of(new CorrelatedJoinNode(correlatedJoinNode.getPlanNodeId(), newInput.orElse(input), newSubquery.orElse(subquery), correlatedJoinNode.getCorrelation(), correlatedJoinNode.getJoinType(), correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery()));
        }
        return Optional.empty();
    }
}

