/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="An HDFS file descriptor.")
public class ApiHdfsFile {
    @SerializedName(value="absolutePath")
    private String absolutePath = null;
    @SerializedName(value="length")
    private BigDecimal length = null;
    @SerializedName(value="dir")
    private Boolean dir = null;
    @SerializedName(value="replication")
    private BigDecimal replication = null;
    @SerializedName(value="blockSize")
    private BigDecimal blockSize = null;
    @SerializedName(value="modificationTime")
    private String modificationTime = null;
    @SerializedName(value="accessTime")
    private String accessTime = null;
    @SerializedName(value="permission")
    private BigDecimal permission = null;
    @SerializedName(value="owner")
    private String owner = null;
    @SerializedName(value="group")
    private String group = null;

    public ApiHdfsFile absolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
        return this;
    }

    @ApiModelProperty(value="Fully qualified path of file.")
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public ApiHdfsFile length(BigDecimal length) {
        this.length = length;
        return this;
    }

    @ApiModelProperty(required=true, value="Size of file.")
    public BigDecimal getLength() {
        return this.length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public ApiHdfsFile dir(Boolean dir) {
        this.dir = dir;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the file is a directory.")
    public Boolean getDir() {
        return this.dir;
    }

    public void setDir(Boolean dir) {
        this.dir = dir;
    }

    public ApiHdfsFile replication(BigDecimal replication) {
        this.replication = replication;
        return this;
    }

    @ApiModelProperty(required=true, value="Configured block replication factor of file.")
    public BigDecimal getReplication() {
        return this.replication;
    }

    public void setReplication(BigDecimal replication) {
        this.replication = replication;
    }

    public ApiHdfsFile blockSize(BigDecimal blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    @ApiModelProperty(required=true, value="Configured block size of file in bytes.")
    public BigDecimal getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(BigDecimal blockSize) {
        this.blockSize = blockSize;
    }

    public ApiHdfsFile modificationTime(String modificationTime) {
        this.modificationTime = modificationTime;
        return this;
    }

    @ApiModelProperty(value="Last modification time of file in milliseconds since January 1, 1970 UTC.")
    public String getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(String modificationTime) {
        this.modificationTime = modificationTime;
    }

    public ApiHdfsFile accessTime(String accessTime) {
        this.accessTime = accessTime;
        return this;
    }

    @ApiModelProperty(value="Last access time of file in milliseconds since January 1, 1970 UTC.")
    public String getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(String accessTime) {
        this.accessTime = accessTime;
    }

    public ApiHdfsFile permission(BigDecimal permission) {
        this.permission = permission;
        return this;
    }

    @ApiModelProperty(required=true, value="Permission of the file where the digits in order represent: Sticky bit, User action, Group action, Other action.")
    public BigDecimal getPermission() {
        return this.permission;
    }

    public void setPermission(BigDecimal permission) {
        this.permission = permission;
    }

    public ApiHdfsFile owner(String owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(value="Owner of the file.")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ApiHdfsFile group(String group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(value="Group of the file.")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHdfsFile apiHdfsFile = (ApiHdfsFile)o;
        return Objects.equals(this.absolutePath, apiHdfsFile.absolutePath) && Objects.equals(this.length, apiHdfsFile.length) && Objects.equals(this.dir, apiHdfsFile.dir) && Objects.equals(this.replication, apiHdfsFile.replication) && Objects.equals(this.blockSize, apiHdfsFile.blockSize) && Objects.equals(this.modificationTime, apiHdfsFile.modificationTime) && Objects.equals(this.accessTime, apiHdfsFile.accessTime) && Objects.equals(this.permission, apiHdfsFile.permission) && Objects.equals(this.owner, apiHdfsFile.owner) && Objects.equals(this.group, apiHdfsFile.group);
    }

    public int hashCode() {
        return Objects.hash(this.absolutePath, this.length, this.dir, this.replication, this.blockSize, this.modificationTime, this.accessTime, this.permission, this.owner, this.group);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHdfsFile {\n");
        sb.append("    absolutePath: ").append(this.toIndentedString(this.absolutePath)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    dir: ").append(this.toIndentedString(this.dir)).append("\n");
        sb.append("    replication: ").append(this.toIndentedString(this.replication)).append("\n");
        sb.append("    blockSize: ").append(this.toIndentedString(this.blockSize)).append("\n");
        sb.append("    modificationTime: ").append(this.toIndentedString(this.modificationTime)).append("\n");
        sb.append("    accessTime: ").append(this.toIndentedString(this.accessTime)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

