/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiMr2AppInformation;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a Yarn application")
public class ApiYarnApplication {
    @SerializedName(value="allocatedMB")
    private BigDecimal allocatedMB = null;
    @SerializedName(value="allocatedVCores")
    private BigDecimal allocatedVCores = null;
    @SerializedName(value="runningContainers")
    private BigDecimal runningContainers = null;
    @SerializedName(value="applicationTags")
    private List<String> applicationTags = null;
    @SerializedName(value="allocatedMemorySeconds")
    private BigDecimal allocatedMemorySeconds = null;
    @SerializedName(value="allocatedVcoreSeconds")
    private BigDecimal allocatedVcoreSeconds = null;
    @SerializedName(value="applicationId")
    private String applicationId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="user")
    private String user = null;
    @SerializedName(value="pool")
    private String pool = null;
    @SerializedName(value="progress")
    private BigDecimal progress = null;
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;
    @SerializedName(value="mr2AppInformation")
    private ApiMr2AppInformation mr2AppInformation = null;
    @SerializedName(value="state")
    private String state = null;
    @SerializedName(value="containerUsedMemorySeconds")
    private BigDecimal containerUsedMemorySeconds = null;
    @SerializedName(value="containerUsedMemoryMax")
    private BigDecimal containerUsedMemoryMax = null;
    @SerializedName(value="containerUsedCpuSeconds")
    private BigDecimal containerUsedCpuSeconds = null;
    @SerializedName(value="containerUsedVcoreSeconds")
    private BigDecimal containerUsedVcoreSeconds = null;
    @SerializedName(value="containerAllocatedMemorySeconds")
    private BigDecimal containerAllocatedMemorySeconds = null;
    @SerializedName(value="containerAllocatedVcoreSeconds")
    private BigDecimal containerAllocatedVcoreSeconds = null;

    public ApiYarnApplication allocatedMB(BigDecimal allocatedMB) {
        this.allocatedMB = allocatedMB;
        return this;
    }

    @ApiModelProperty(value="The sum of memory in MB allocated to the application's running containers Available since v12.")
    public BigDecimal getAllocatedMB() {
        return this.allocatedMB;
    }

    public void setAllocatedMB(BigDecimal allocatedMB) {
        this.allocatedMB = allocatedMB;
    }

    public ApiYarnApplication allocatedVCores(BigDecimal allocatedVCores) {
        this.allocatedVCores = allocatedVCores;
        return this;
    }

    @ApiModelProperty(value="The sum of virtual cores allocated to the application's running containers Available since v12.")
    public BigDecimal getAllocatedVCores() {
        return this.allocatedVCores;
    }

    public void setAllocatedVCores(BigDecimal allocatedVCores) {
        this.allocatedVCores = allocatedVCores;
    }

    public ApiYarnApplication runningContainers(BigDecimal runningContainers) {
        this.runningContainers = runningContainers;
        return this;
    }

    @ApiModelProperty(value="The number of containers currently running for the application Available since v12.")
    public BigDecimal getRunningContainers() {
        return this.runningContainers;
    }

    public void setRunningContainers(BigDecimal runningContainers) {
        this.runningContainers = runningContainers;
    }

    public ApiYarnApplication applicationTags(List<String> applicationTags) {
        this.applicationTags = applicationTags;
        return this;
    }

    public ApiYarnApplication addApplicationTagsItem(String applicationTagsItem) {
        if (this.applicationTags == null) {
            this.applicationTags = new ArrayList<String>();
        }
        this.applicationTags.add(applicationTagsItem);
        return this;
    }

    @ApiModelProperty(value="List of YARN application tags. Available since v12.")
    public List<String> getApplicationTags() {
        return this.applicationTags;
    }

    public void setApplicationTags(List<String> applicationTags) {
        this.applicationTags = applicationTags;
    }

    public ApiYarnApplication allocatedMemorySeconds(BigDecimal allocatedMemorySeconds) {
        this.allocatedMemorySeconds = allocatedMemorySeconds;
        return this;
    }

    @ApiModelProperty(value="Allocated memory to the application in units of mb-secs. Available since v12.")
    public BigDecimal getAllocatedMemorySeconds() {
        return this.allocatedMemorySeconds;
    }

    public void setAllocatedMemorySeconds(BigDecimal allocatedMemorySeconds) {
        this.allocatedMemorySeconds = allocatedMemorySeconds;
    }

    public ApiYarnApplication allocatedVcoreSeconds(BigDecimal allocatedVcoreSeconds) {
        this.allocatedVcoreSeconds = allocatedVcoreSeconds;
        return this;
    }

    @ApiModelProperty(value="Allocated vcore-secs to the application. Available since v12.")
    public BigDecimal getAllocatedVcoreSeconds() {
        return this.allocatedVcoreSeconds;
    }

    public void setAllocatedVcoreSeconds(BigDecimal allocatedVcoreSeconds) {
        this.allocatedVcoreSeconds = allocatedVcoreSeconds;
    }

    public ApiYarnApplication applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(value="The application id.")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ApiYarnApplication name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the application.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiYarnApplication startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The time the application was submitted.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiYarnApplication endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The time the application finished. If the application hasn't finished this will return null.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiYarnApplication user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="The user who submitted the application.")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public ApiYarnApplication pool(String pool) {
        this.pool = pool;
        return this;
    }

    @ApiModelProperty(value="The pool the application was submitted to.")
    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public ApiYarnApplication progress(BigDecimal progress) {
        this.progress = progress;
        return this;
    }

    @ApiModelProperty(value="The progress, as a percentage, the application has made. This is only set if the application is currently executing.")
    public BigDecimal getProgress() {
        return this.progress;
    }

    public void setProgress(BigDecimal progress) {
        this.progress = progress;
    }

    public ApiYarnApplication attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ApiYarnApplication putAttributesItem(String key, String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @ApiModelProperty(value="A map of additional application attributes which is generated by Cloudera Manager. For example MR2 job counters are exposed as key/value pairs here. For more details see the Cloudera Manager documentation.")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ApiYarnApplication mr2AppInformation(ApiMr2AppInformation mr2AppInformation) {
        this.mr2AppInformation = mr2AppInformation;
        return this;
    }

    @ApiModelProperty(value="")
    public ApiMr2AppInformation getMr2AppInformation() {
        return this.mr2AppInformation;
    }

    public void setMr2AppInformation(ApiMr2AppInformation mr2AppInformation) {
        this.mr2AppInformation = mr2AppInformation;
    }

    public ApiYarnApplication state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ApiYarnApplication containerUsedMemorySeconds(BigDecimal containerUsedMemorySeconds) {
        this.containerUsedMemorySeconds = containerUsedMemorySeconds;
        return this;
    }

    @ApiModelProperty(value="Actual memory (in MB-secs) used by containers launched by the YARN application. Computed by running a MapReduce job from Cloudera Service Monitor to aggregate YARN usage metrics. Available since v12.")
    public BigDecimal getContainerUsedMemorySeconds() {
        return this.containerUsedMemorySeconds;
    }

    public void setContainerUsedMemorySeconds(BigDecimal containerUsedMemorySeconds) {
        this.containerUsedMemorySeconds = containerUsedMemorySeconds;
    }

    public ApiYarnApplication containerUsedMemoryMax(BigDecimal containerUsedMemoryMax) {
        this.containerUsedMemoryMax = containerUsedMemoryMax;
        return this;
    }

    @ApiModelProperty(value="Maximum memory used by containers launched by the YARN application. Computed by running a MapReduce job from Cloudera Service Monitor to aggregate YARN usage metrics Available since v16")
    public BigDecimal getContainerUsedMemoryMax() {
        return this.containerUsedMemoryMax;
    }

    public void setContainerUsedMemoryMax(BigDecimal containerUsedMemoryMax) {
        this.containerUsedMemoryMax = containerUsedMemoryMax;
    }

    public ApiYarnApplication containerUsedCpuSeconds(BigDecimal containerUsedCpuSeconds) {
        this.containerUsedCpuSeconds = containerUsedCpuSeconds;
        return this;
    }

    @ApiModelProperty(value="Actual CPU (in percent-secs) used by containers launched by the YARN application. Computed by running a MapReduce job from Cloudera Service Monitor to aggregate YARN usage metrics. Available since v12.")
    public BigDecimal getContainerUsedCpuSeconds() {
        return this.containerUsedCpuSeconds;
    }

    public void setContainerUsedCpuSeconds(BigDecimal containerUsedCpuSeconds) {
        this.containerUsedCpuSeconds = containerUsedCpuSeconds;
    }

    public ApiYarnApplication containerUsedVcoreSeconds(BigDecimal containerUsedVcoreSeconds) {
        this.containerUsedVcoreSeconds = containerUsedVcoreSeconds;
        return this;
    }

    @ApiModelProperty(value="Actual VCore-secs used by containers launched by the YARN application. Computed by running a MapReduce job from Cloudera Service Monitor to aggregate YARN usage metrics. Available since v12.")
    public BigDecimal getContainerUsedVcoreSeconds() {
        return this.containerUsedVcoreSeconds;
    }

    public void setContainerUsedVcoreSeconds(BigDecimal containerUsedVcoreSeconds) {
        this.containerUsedVcoreSeconds = containerUsedVcoreSeconds;
    }

    public ApiYarnApplication containerAllocatedMemorySeconds(BigDecimal containerAllocatedMemorySeconds) {
        this.containerAllocatedMemorySeconds = containerAllocatedMemorySeconds;
        return this;
    }

    @ApiModelProperty(value="Total memory (in mb-secs) allocated to containers launched by the YARN application. Computed by running a MapReduce job from Cloudera Service Monitor to aggregate YARN usage metrics. Available since v12.")
    public BigDecimal getContainerAllocatedMemorySeconds() {
        return this.containerAllocatedMemorySeconds;
    }

    public void setContainerAllocatedMemorySeconds(BigDecimal containerAllocatedMemorySeconds) {
        this.containerAllocatedMemorySeconds = containerAllocatedMemorySeconds;
    }

    public ApiYarnApplication containerAllocatedVcoreSeconds(BigDecimal containerAllocatedVcoreSeconds) {
        this.containerAllocatedVcoreSeconds = containerAllocatedVcoreSeconds;
        return this;
    }

    @ApiModelProperty(value="Total vcore-secs allocated to containers launched by the YARN application. Computed by running a MapReduce job from Cloudera Service Monitor to aggregate YARN usage metrics. Available since v12.")
    public BigDecimal getContainerAllocatedVcoreSeconds() {
        return this.containerAllocatedVcoreSeconds;
    }

    public void setContainerAllocatedVcoreSeconds(BigDecimal containerAllocatedVcoreSeconds) {
        this.containerAllocatedVcoreSeconds = containerAllocatedVcoreSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiYarnApplication apiYarnApplication = (ApiYarnApplication)o;
        return Objects.equals(this.allocatedMB, apiYarnApplication.allocatedMB) && Objects.equals(this.allocatedVCores, apiYarnApplication.allocatedVCores) && Objects.equals(this.runningContainers, apiYarnApplication.runningContainers) && Objects.equals(this.applicationTags, apiYarnApplication.applicationTags) && Objects.equals(this.allocatedMemorySeconds, apiYarnApplication.allocatedMemorySeconds) && Objects.equals(this.allocatedVcoreSeconds, apiYarnApplication.allocatedVcoreSeconds) && Objects.equals(this.applicationId, apiYarnApplication.applicationId) && Objects.equals(this.name, apiYarnApplication.name) && Objects.equals(this.startTime, apiYarnApplication.startTime) && Objects.equals(this.endTime, apiYarnApplication.endTime) && Objects.equals(this.user, apiYarnApplication.user) && Objects.equals(this.pool, apiYarnApplication.pool) && Objects.equals(this.progress, apiYarnApplication.progress) && Objects.equals(this.attributes, apiYarnApplication.attributes) && Objects.equals(this.mr2AppInformation, apiYarnApplication.mr2AppInformation) && Objects.equals(this.state, apiYarnApplication.state) && Objects.equals(this.containerUsedMemorySeconds, apiYarnApplication.containerUsedMemorySeconds) && Objects.equals(this.containerUsedMemoryMax, apiYarnApplication.containerUsedMemoryMax) && Objects.equals(this.containerUsedCpuSeconds, apiYarnApplication.containerUsedCpuSeconds) && Objects.equals(this.containerUsedVcoreSeconds, apiYarnApplication.containerUsedVcoreSeconds) && Objects.equals(this.containerAllocatedMemorySeconds, apiYarnApplication.containerAllocatedMemorySeconds) && Objects.equals(this.containerAllocatedVcoreSeconds, apiYarnApplication.containerAllocatedVcoreSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.allocatedMB, this.allocatedVCores, this.runningContainers, this.applicationTags, this.allocatedMemorySeconds, this.allocatedVcoreSeconds, this.applicationId, this.name, this.startTime, this.endTime, this.user, this.pool, this.progress, this.attributes, this.mr2AppInformation, this.state, this.containerUsedMemorySeconds, this.containerUsedMemoryMax, this.containerUsedCpuSeconds, this.containerUsedVcoreSeconds, this.containerAllocatedMemorySeconds, this.containerAllocatedVcoreSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiYarnApplication {\n");
        sb.append("    allocatedMB: ").append(this.toIndentedString(this.allocatedMB)).append("\n");
        sb.append("    allocatedVCores: ").append(this.toIndentedString(this.allocatedVCores)).append("\n");
        sb.append("    runningContainers: ").append(this.toIndentedString(this.runningContainers)).append("\n");
        sb.append("    applicationTags: ").append(this.toIndentedString(this.applicationTags)).append("\n");
        sb.append("    allocatedMemorySeconds: ").append(this.toIndentedString(this.allocatedMemorySeconds)).append("\n");
        sb.append("    allocatedVcoreSeconds: ").append(this.toIndentedString(this.allocatedVcoreSeconds)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    mr2AppInformation: ").append(this.toIndentedString(this.mr2AppInformation)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    containerUsedMemorySeconds: ").append(this.toIndentedString(this.containerUsedMemorySeconds)).append("\n");
        sb.append("    containerUsedMemoryMax: ").append(this.toIndentedString(this.containerUsedMemoryMax)).append("\n");
        sb.append("    containerUsedCpuSeconds: ").append(this.toIndentedString(this.containerUsedCpuSeconds)).append("\n");
        sb.append("    containerUsedVcoreSeconds: ").append(this.toIndentedString(this.containerUsedVcoreSeconds)).append("\n");
        sb.append("    containerAllocatedMemorySeconds: ").append(this.toIndentedString(this.containerAllocatedMemorySeconds)).append("\n");
        sb.append("    containerAllocatedVcoreSeconds: ").append(this.toIndentedString(this.containerAllocatedVcoreSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

