/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.monitor.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class LocalDirectory {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private final File base;

    public LocalDirectory(File base) {
        this.base = base;
        this.ensureExists(base);
    }

    private void ensureExists(File base) {
        try {
            if (!base.exists()) {
                Files.createDirectories(Paths.get(base.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOG.cannotCreateLocalDirectory(base, e);
        }
    }

    public void writeFile(String name, String content) throws IOException {
        FileUtils.writeStringToFile((File)this.file(name), (String)content, (Charset)CHARSET);
    }

    public boolean deleteFile(String name) {
        return FileUtils.deleteQuietly((File)this.file(name));
    }

    public String fileContent(String name) throws IOException {
        try {
            return FileUtils.readFileToString((File)this.file(name), (Charset)CHARSET);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public Set<String> list() {
        return FileUtils.listFiles((File)this.base, null, (boolean)false).stream().map(File::getName).collect(Collectors.toSet());
    }

    private File file(String name) {
        return new File(this.base, name);
    }

    public String toString() {
        return "LocalDirectory{base='" + this.base + '\'' + '}';
    }
}

