/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.taglib;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.taglib.Log4jTaglibLogger;
import org.apache.logging.log4j.taglib.Log4jTaglibLoggerContext;

final class TagUtils {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final Set<Object> WARNED_FOR = new HashSet<Object>();
    private static final String LOGGER_SCOPE_ATTRIBUTE = "org.apache.logging.log4j.taglib.LOGGER_SCOPE_ATTRIBUTE";

    private TagUtils() {
        throw new RuntimeException("TagUtils cannot be instantiated.");
    }

    static int getScope(String scope) {
        if ("request".equalsIgnoreCase(scope)) {
            return 2;
        }
        if ("session".equalsIgnoreCase(scope)) {
            return 3;
        }
        if ("application".equalsIgnoreCase(scope)) {
            return 4;
        }
        return 1;
    }

    static Level resolveLevel(Object level) {
        if (level instanceof Level) {
            return (Level)level;
        }
        if (level instanceof String) {
            return Level.toLevel((String)((String)level));
        }
        return null;
    }

    static Log4jTaglibLogger resolveLogger(Log4jTaglibLoggerContext context, Object logger, MessageFactory factory) throws JspException {
        if (logger instanceof Logger) {
            if (logger instanceof Log4jTaglibLogger) {
                return (Log4jTaglibLogger)((Object)logger);
            }
            if (logger instanceof AbstractLogger) {
                if (LOGGER.isInfoEnabled() && !WARNED_FOR.contains(logger)) {
                    LOGGER.info("Constructing new Log4jTaglibLogger from AbstractLogger {} name and message factory.", (Object)logger.getClass().getName());
                    WARNED_FOR.add(logger);
                }
                AbstractLogger original = (AbstractLogger)logger;
                return TagUtils.getLogger(context, original.getName(), original.getMessageFactory());
            }
            throw new JspException("Log4j Tag Library requires base logging system to extend Log4j AbstractLogger.");
        }
        if (logger instanceof String) {
            return TagUtils.getLogger(context, (String)logger, factory);
        }
        throw new JspException("Logger must be of type String or org.apache.logging.log4j.Logger.");
    }

    private static Log4jTaglibLogger getLogger(Log4jTaglibLoggerContext context, String name, MessageFactory factory) throws JspException {
        try {
            return context.getLogger(name, factory);
        }
        catch (LoggingException e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
    }

    static void setDefaultLogger(PageContext pageContext, Log4jTaglibLogger logger) {
        pageContext.setAttribute(LOGGER_SCOPE_ATTRIBUTE, (Object)logger, 1);
    }

    static Log4jTaglibLogger getDefaultLogger(PageContext pageContext) {
        return (Log4jTaglibLogger)((Object)pageContext.getAttribute(LOGGER_SCOPE_ATTRIBUTE, 1));
    }

    static boolean isEnabled(Log4jTaglibLogger logger, Level level, Marker marker) {
        if (marker == null) {
            return logger.isEnabled(level);
        }
        return logger.isEnabled(level, marker, null, null);
    }
}

