/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.externalize.RelJson;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelJsonReader {
    private static final TypeReference<LinkedHashMap<String, Object>> TYPE_REF = new TypeReference<LinkedHashMap<String, Object>>(){};
    private final RelOptCluster cluster;
    private final RelOptSchema relOptSchema;
    private final RelJson relJson;
    private final Map<String, RelNode> relMap = new LinkedHashMap<String, RelNode>();
    private @Nullable RelNode lastRel;

    public RelJsonReader(RelOptCluster cluster, RelOptSchema relOptSchema, Schema schema) {
        this(cluster, relOptSchema, schema, UnaryOperator.identity());
    }

    public RelJsonReader(RelOptCluster cluster, RelOptSchema relOptSchema, Schema schema, UnaryOperator<RelJson> relJsonTransform) {
        this.cluster = cluster;
        this.relOptSchema = relOptSchema;
        Util.discard(schema);
        this.relJson = (RelJson)relJsonTransform.apply(RelJson.create());
    }

    public RelNode read(String s) throws IOException {
        this.lastRel = null;
        ObjectMapper mapper = new ObjectMapper();
        Map o = (Map)mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).readValue(s, TYPE_REF);
        List rels = (List)Objects.requireNonNull(o.get("rels"), "rels");
        this.readRels(rels);
        return Objects.requireNonNull(this.lastRel, "lastRel");
    }

    public static RelDataType readType(RelDataTypeFactory typeFactory, String s) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Map o = (Map)mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).readValue(s, TYPE_REF);
        return RelJson.create().toType(typeFactory, o);
    }

    public static RexNode readRex(RelOptCluster typeFactory, String s) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Map o = (Map)mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).readValue(s, TYPE_REF);
        return RelJson.create().toRex(typeFactory, (Object)o);
    }

    private void readRels(List<Map<String, Object>> jsonRels) {
        for (Map<String, Object> jsonRel : jsonRels) {
            this.readRel(jsonRel);
        }
    }

    private void readRel(final Map<String, Object> jsonRel) {
        String id = (String)Objects.requireNonNull(jsonRel.get("id"), "jsonRel.id");
        String type = (String)Objects.requireNonNull(jsonRel.get("relOp"), "jsonRel.relOp");
        Constructor constructor = this.relJson.getConstructor(type);
        RelInput input = new RelInput(){

            @Override
            public RelOptCluster getCluster() {
                return RelJsonReader.this.cluster;
            }

            @Override
            public RelTraitSet getTraitSet() {
                return RelJsonReader.this.cluster.traitSetOf((RelTrait)Convention.NONE);
            }

            @Override
            public RelOptTable getTable(String table) {
                List<String> list = Objects.requireNonNull(this.getStringList(table), () -> "getStringList for " + table);
                return Objects.requireNonNull(RelJsonReader.this.relOptSchema.getTableForMember(list), () -> "table " + table + " is not found in schema " + RelJsonReader.this.relOptSchema);
            }

            @Override
            public RelNode getInput() {
                List<RelNode> inputs = this.getInputs();
                assert (inputs.size() == 1);
                return inputs.get(0);
            }

            @Override
            public List<RelNode> getInputs() {
                List<String> jsonInputs = this.getStringList("inputs");
                if (jsonInputs == null) {
                    return ImmutableList.of((Object)Objects.requireNonNull(RelJsonReader.this.lastRel, "lastRel"));
                }
                ImmutableList.Builder inputs = new ImmutableList.Builder();
                for (String jsonInput : jsonInputs) {
                    inputs.add((Object)RelJsonReader.this.lookupInput(jsonInput));
                }
                return inputs.build();
            }

            @Override
            public @Nullable RexNode getExpression(String tag) {
                return RelJsonReader.this.relJson.toRex(this, jsonRel.get(tag));
            }

            @Override
            public ImmutableBitSet getBitSet(String tag) {
                return ImmutableBitSet.of((Iterable<Integer>)Objects.requireNonNull(this.getIntegerList(tag), tag));
            }

            @Override
            public @Nullable List<ImmutableBitSet> getBitSetList(String tag) {
                List<List<Integer>> list = this.getIntegerListList(tag);
                if (list == null) {
                    return null;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (List<Integer> integers : list) {
                    builder.add((Object)ImmutableBitSet.of(integers));
                }
                return builder.build();
            }

            @Override
            public @Nullable List<String> getStringList(String tag) {
                return (List)jsonRel.get(tag);
            }

            @Override
            public @Nullable List<Integer> getIntegerList(String tag) {
                return (List)jsonRel.get(tag);
            }

            @Override
            public @Nullable List<List<Integer>> getIntegerListList(String tag) {
                return (List)jsonRel.get(tag);
            }

            @Override
            public List<AggregateCall> getAggregateCalls(String tag) {
                List jsonAggs = (List)this.getNonNull(tag);
                ArrayList<AggregateCall> inputs = new ArrayList<AggregateCall>();
                for (Map jsonAggCall : jsonAggs) {
                    inputs.add(RelJsonReader.this.toAggCall(jsonAggCall));
                }
                return inputs;
            }

            @Override
            public @Nullable Object get(String tag) {
                return jsonRel.get(tag);
            }

            private Object getNonNull(String tag) {
                return Objects.requireNonNull(this.get(tag), () -> "no entry for tag " + tag);
            }

            @Override
            public @Nullable String getString(String tag) {
                return (String)this.get(tag);
            }

            @Override
            public float getFloat(String tag) {
                return ((Number)this.getNonNull(tag)).floatValue();
            }

            @Override
            public boolean getBoolean(String tag, boolean default_) {
                Boolean b = (Boolean)this.get(tag);
                return b != null ? b : default_;
            }

            @Override
            public <E extends Enum<E>> @Nullable E getEnum(String tag, Class<E> enumClass) {
                return (E)Util.enumVal(enumClass, ((String)this.getNonNull(tag)).toUpperCase(Locale.ROOT));
            }

            @Override
            public @Nullable List<RexNode> getExpressionList(String tag) {
                List jsonNodes = (List)jsonRel.get(tag);
                if (jsonNodes == null) {
                    return null;
                }
                ArrayList<RexNode> nodes = new ArrayList<RexNode>();
                for (Object jsonNode : jsonNodes) {
                    nodes.add(RelJsonReader.this.relJson.toRex(this, jsonNode));
                }
                return nodes;
            }

            @Override
            public RelDataType getRowType(String tag) {
                Object o = this.getNonNull(tag);
                return RelJsonReader.this.relJson.toType(RelJsonReader.this.cluster.getTypeFactory(), o);
            }

            @Override
            public RelDataType getRowType(String expressionsTag, String fieldsTag) {
                final List<RexNode> expressionList = this.getExpressionList(expressionsTag);
                final List names = (List)this.getNonNull(fieldsTag);
                return RelJsonReader.this.cluster.getTypeFactory().createStructType((List<? extends Map.Entry<String, RelDataType>>)new AbstractList<Map.Entry<String, RelDataType>>(){

                    @Override
                    public Map.Entry<String, RelDataType> get(int index) {
                        return Pair.of(names.get(index), ((RexNode)Objects.requireNonNull(expressionList, "expressionList").get(index)).getType());
                    }

                    @Override
                    public int size() {
                        return names.size();
                    }
                });
            }

            @Override
            public RelCollation getCollation() {
                return RelJsonReader.this.relJson.toCollation((List)this.getNonNull("collation"));
            }

            @Override
            public RelDistribution getDistribution() {
                return RelJsonReader.this.relJson.toDistribution((Map)this.getNonNull("distribution"));
            }

            @Override
            public ImmutableList<ImmutableList<RexLiteral>> getTuples(String tag) {
                List jsonTuples = (List)this.getNonNull(tag);
                ImmutableList.Builder builder = ImmutableList.builder();
                for (List jsonTuple : jsonTuples) {
                    builder.add(this.getTuple(jsonTuple));
                }
                return builder.build();
            }

            public ImmutableList<RexLiteral> getTuple(List jsonTuple) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object jsonValue : jsonTuple) {
                    builder.add((Object)((RexLiteral)RelJsonReader.this.relJson.toRex(this, jsonValue)));
                }
                return builder.build();
            }
        };
        try {
            RelNode rel = (RelNode)constructor.newInstance(input);
            this.relMap.put(id, rel);
            this.lastRel = rel;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e2);
        }
    }

    private AggregateCall toAggCall(Map<String, Object> jsonAggCall) {
        Map aggMap = (Map)Objects.requireNonNull(jsonAggCall.get("agg"), "agg key is not found");
        SqlAggFunction aggregation = Objects.requireNonNull(this.relJson.toAggregation(aggMap), () -> "relJson.toAggregation output for " + aggMap);
        boolean distinct = Objects.requireNonNull((Boolean)jsonAggCall.get("distinct"), "jsonAggCall.distinct");
        List operands = Objects.requireNonNull((List)jsonAggCall.get("operands"), "jsonAggCall.operands");
        Integer filterOperand = (Integer)jsonAggCall.get("filter");
        Object jsonAggType = Objects.requireNonNull(jsonAggCall.get("type"), "jsonAggCall.type");
        RelDataType type = this.relJson.toType(this.cluster.getTypeFactory(), jsonAggType);
        String name = (String)jsonAggCall.get("name");
        return AggregateCall.create(aggregation, distinct, false, false, (List<RexNode>)ImmutableList.of(), operands, filterOperand == null ? -1 : filterOperand, null, RelCollations.EMPTY, type, name);
    }

    private RelNode lookupInput(String jsonInput) {
        RelNode node = this.relMap.get(jsonInput);
        if (node == null) {
            throw new RuntimeException("unknown id " + jsonInput + " for relational expression");
        }
        return node;
    }
}

