/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceCallback;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.ClientUtils;
import org.apache.kafka.common.utils.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumer<K, V>
implements Consumer<K, V> {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumer.class);
    private final long metadataFetchTimeoutMs;
    private final long totalMemorySize;
    private final Metrics metrics;
    private final Set<String> subscribedTopics;
    private final Set<TopicPartition> subscribedPartitions;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;

    public KafkaConsumer(Map<String, Object> configs) {
        this(configs, null);
    }

    public KafkaConsumer(Map<String, Object> configs, ConsumerRebalanceCallback callback) {
        this(configs, callback, null, null);
    }

    public KafkaConsumer(Map<String, Object> configs, ConsumerRebalanceCallback callback, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(KafkaConsumer.addDeserializerToConfig(configs, keyDeserializer, valueDeserializer)), callback, keyDeserializer, valueDeserializer);
    }

    private static Map<String, Object> addDeserializerToConfig(Map<String, Object> configs, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        newConfigs.putAll(configs);
        if (keyDeserializer != null) {
            newConfigs.put("key.deserializer", keyDeserializer.getClass());
        }
        if (keyDeserializer != null) {
            newConfigs.put("value.deserializer", valueDeserializer.getClass());
        }
        return newConfigs;
    }

    public KafkaConsumer(Properties properties) {
        this(properties, (ConsumerRebalanceCallback)null);
    }

    public KafkaConsumer(Properties properties, ConsumerRebalanceCallback callback) {
        this(properties, callback, (Deserializer<K>)null, (Deserializer<V>)null);
    }

    public KafkaConsumer(Properties properties, ConsumerRebalanceCallback callback, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(KafkaConsumer.addDeserializerToConfig(properties, keyDeserializer, valueDeserializer)), callback, keyDeserializer, valueDeserializer);
    }

    private static Properties addDeserializerToConfig(Properties properties, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer) {
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)properties);
        if (keyDeserializer != null) {
            newProperties.put("key.deserializer", keyDeserializer.getClass().getName());
        }
        if (keyDeserializer != null) {
            newProperties.put("value.deserializer", valueDeserializer.getClass().getName());
        }
        return newProperties;
    }

    private KafkaConsumer(ConsumerConfig config, ConsumerRebalanceCallback callback, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        log.trace("Starting the Kafka consumer");
        this.subscribedTopics = new HashSet<String>();
        this.subscribedPartitions = new HashSet<TopicPartition>();
        this.metrics = new Metrics(new MetricConfig(), Collections.singletonList(new JmxReporter("kafka.consumer.")), new SystemTime());
        this.metadataFetchTimeoutMs = config.getLong("metadata.fetch.timeout.ms");
        this.totalMemorySize = config.getLong("total.memory.bytes");
        List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config.getList("bootstrap.servers"));
        this.keyDeserializer = keyDeserializer == null ? config.getConfiguredInstance("key.deserializer", Deserializer.class) : keyDeserializer;
        this.valueDeserializer = valueDeserializer == null ? config.getConfiguredInstance("value.deserializer", Deserializer.class) : valueDeserializer;
        config.logUnused();
        log.debug("Kafka consumer started");
    }

    @Override
    public void subscribe(String ... topics) {
        if (this.subscribedPartitions.size() > 0) {
            throw new IllegalStateException("Subcription to topics and partitions is mutually exclusive");
        }
        for (String topic : topics) {
            this.subscribedTopics.add(topic);
        }
    }

    @Override
    public void subscribe(TopicPartition ... partitions) {
        if (this.subscribedTopics.size() > 0) {
            throw new IllegalStateException("Subcription to topics and partitions is mutually exclusive");
        }
        for (TopicPartition partition : partitions) {
            this.subscribedPartitions.add(partition);
        }
    }

    @Override
    public void unsubscribe(String ... topics) {
        for (String topic : topics) {
            if (!this.subscribedTopics.contains(topic)) {
                throw new IllegalStateException("Topic " + topic + " was never subscribed to. subscribe(" + topic + ") should be called prior" + " to unsubscribe(" + topic + ")");
            }
            this.subscribedTopics.remove(topic);
        }
    }

    @Override
    public void unsubscribe(TopicPartition ... partitions) {
        for (TopicPartition partition : partitions) {
            if (!this.subscribedPartitions.contains(partition)) {
                throw new IllegalStateException("Partition " + partition + " was never subscribed to. subscribe(new TopicPartition(" + partition.topic() + "," + partition.partition() + ") should be called prior" + " to unsubscribe(new TopicPartition(" + partition.topic() + "," + partition.partition() + ")");
            }
            this.subscribedPartitions.remove(partition);
        }
    }

    @Override
    public Map<String, ConsumerRecords<K, V>> poll(long timeout) {
        return null;
    }

    @Override
    public OffsetMetadata commit(Map<TopicPartition, Long> offsets, boolean sync) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OffsetMetadata commit(boolean sync) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(Map<TopicPartition, Long> offsets) {
    }

    @Override
    public Map<TopicPartition, Long> position(Collection<TopicPartition> partitions) {
        return null;
    }

    @Override
    public Map<TopicPartition, Long> committed(Collection<TopicPartition> partitions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<TopicPartition, Long> offsetsBeforeTime(long timestamp, Collection<TopicPartition> partitions) {
        return null;
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    public void close() {
        log.trace("Closing the Kafka consumer.");
        this.subscribedTopics.clear();
        this.subscribedPartitions.clear();
        this.metrics.close();
        log.debug("The Kafka consumer has closed.");
    }
}

